/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.trove.list.array.TDoubleArrayList;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AbstractIndexFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.DoubleValuesComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.DoubleArrayAtomicFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.settings.IndexSettings;

public class DoubleArrayIndexFieldData
extends AbstractIndexFieldData<DoubleArrayAtomicFieldData>
implements IndexNumericFieldData<DoubleArrayAtomicFieldData> {
    public DoubleArrayIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return IndexNumericFieldData.NumericType.DOUBLE;
    }

    @Override
    public boolean valuesOrdered() {
        return false;
    }

    @Override
    public DoubleArrayAtomicFieldData load(AtomicReaderContext context) {
        try {
            return (DoubleArrayAtomicFieldData)this.cache.load(context, this);
        }
        catch (Throwable e) {
            if (e instanceof ElasticSearchException) {
                throw (ElasticSearchException)e;
            }
            throw new ElasticSearchException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DoubleArrayAtomicFieldData loadDirect(AtomicReaderContext context) throws Exception {
        AtomicReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        if (terms == null) {
            return DoubleArrayAtomicFieldData.EMPTY;
        }
        TDoubleArrayList values = new TDoubleArrayList();
        values.add(0.0);
        OrdinalsBuilder builder = new OrdinalsBuilder(terms, reader.maxDoc());
        try {
            BytesRef term;
            BytesRefIterator iter = builder.buildFromTerms(builder.wrapNumeric64Bit(terms.iterator(null)), reader.getLiveDocs());
            while ((term = iter.next()) != null) {
                values.add(NumericUtils.sortableLongToDouble((long)NumericUtils.prefixCodedToLong((BytesRef)term)));
            }
            Ordinals build = builder.build(this.fieldDataType.getSettings());
            if (!build.isMultiValued() && IndexFieldData.CommonSettings.removeOrdsOnSingleValue(this.fieldDataType)) {
                long ordinalsSize;
                Ordinals.Docs ordinals = build.ordinals();
                FixedBitSet set = builder.buildDocsWithValuesSet();
                long singleValuesArraySize = reader.maxDoc() * 8 + (set == null ? 0 : set.getBits().length * 8 + 4);
                long uniqueValuesArraySize = values.size() * 8;
                if (uniqueValuesArraySize + (ordinalsSize = build.getMemorySizeInBytes()) < singleValuesArraySize) {
                    DoubleArrayAtomicFieldData.WithOrdinals withOrdinals = new DoubleArrayAtomicFieldData.WithOrdinals(values.toArray(new double[values.size()]), reader.maxDoc(), build);
                    return withOrdinals;
                }
                double[] sValues = new double[reader.maxDoc()];
                int maxDoc = reader.maxDoc();
                for (int i = 0; i < maxDoc; ++i) {
                    sValues[i] = values.get(ordinals.getOrd(i));
                }
                if (set == null) {
                    DoubleArrayAtomicFieldData.Single single = new DoubleArrayAtomicFieldData.Single(sValues, reader.maxDoc());
                    return single;
                }
                DoubleArrayAtomicFieldData.SingleFixedSet singleFixedSet = new DoubleArrayAtomicFieldData.SingleFixedSet(sValues, reader.maxDoc(), set);
                return singleFixedSet;
            }
            DoubleArrayAtomicFieldData.WithOrdinals withOrdinals = new DoubleArrayAtomicFieldData.WithOrdinals(values.toArray(new double[values.size()]), reader.maxDoc(), build);
            return withOrdinals;
        }
        finally {
            builder.close();
        }
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, SortMode sortMode) {
        return new DoubleValuesComparatorSource(this, missingValue, sortMode);
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData build(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType type, IndexFieldDataCache cache) {
            return new DoubleArrayIndexFieldData(index, indexSettings, fieldNames, type, cache);
        }
    }
}

