/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Util;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.EmptyOrdinals;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public class FSTBytesAtomicFieldData
implements AtomicFieldData.WithOrdinals<ScriptDocValues.Strings> {
    protected final Ordinals ordinals;
    private volatile int[] hashes;
    private long size = -1L;
    private final FST<Long> fst;

    public static FSTBytesAtomicFieldData empty(int numDocs) {
        return new Empty(numDocs);
    }

    public FSTBytesAtomicFieldData(FST<Long> fst, Ordinals ordinals) {
        this.ordinals = ordinals;
        this.fst = fst;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isMultiValued() {
        return this.ordinals.isMultiValued();
    }

    @Override
    public int getNumDocs() {
        return this.ordinals.getNumDocs();
    }

    @Override
    public boolean isValuesOrdered() {
        return true;
    }

    @Override
    public long getMemorySizeInBytes() {
        if (this.size == -1L) {
            long size = this.ordinals.getMemorySizeInBytes();
            this.size = size += this.fst == null ? 0L : this.fst.sizeInBytes();
        }
        return this.size;
    }

    @Override
    public BytesValues.WithOrdinals getBytesValues() {
        assert (this.fst != null);
        return this.ordinals.isMultiValued() ? new BytesValues.Multi(this.fst, this.ordinals.ordinals()) : new BytesValues.Single(this.fst, this.ordinals.ordinals());
    }

    @Override
    public ScriptDocValues.Strings getScriptValues() {
        assert (this.fst != null);
        return new ScriptDocValues.Strings(this.getBytesValues());
    }

    @Override
    public BytesValues.WithOrdinals getHashedBytesValues() {
        assert (this.fst != null);
        if (this.hashes == null) {
            BytesRefFSTEnum fstEnum = new BytesRefFSTEnum(this.fst);
            int[] hashes = new int[this.ordinals.getMaxOrd()];
            hashes[0] = new BytesRef().hashCode();
            int i = 1;
            try {
                BytesRefFSTEnum.InputOutput next;
                while ((next = fstEnum.next()) != null) {
                    hashes[i++] = next.input.hashCode();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.hashes = hashes;
        }
        return this.ordinals.isMultiValued() ? new BytesValues.MultiHashed(this.fst, this.ordinals.ordinals(), this.hashes) : new BytesValues.SingleHashed(this.fst, this.ordinals.ordinals(), this.hashes);
    }

    static class Empty
    extends FSTBytesAtomicFieldData {
        Empty(int numDocs) {
            super(null, new EmptyOrdinals(numDocs));
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public int getNumDocs() {
            return this.ordinals.getNumDocs();
        }

        @Override
        public boolean isValuesOrdered() {
            return true;
        }

        @Override
        public BytesValues.WithOrdinals getBytesValues() {
            return new BytesValues.WithOrdinals.Empty(this.ordinals.ordinals());
        }

        @Override
        public ScriptDocValues.Strings getScriptValues() {
            return ScriptDocValues.EMPTY_STRINGS;
        }

        @Override
        public BytesValues.WithOrdinals getHashedBytesValues() {
            return this.getBytesValues();
        }
    }

    static abstract class BytesValues
    extends BytesValues.WithOrdinals {
        protected final FST<Long> fst;
        protected final Ordinals.Docs ordinals;
        protected final FST.BytesReader in;
        protected final FST.Arc<Long> firstArc = new FST.Arc();
        protected final FST.Arc<Long> scratchArc = new FST.Arc();
        protected final IntsRef scratchInts = new IntsRef();

        BytesValues(FST<Long> fst, Ordinals.Docs ordinals) {
            super(ordinals);
            this.fst = fst;
            this.ordinals = ordinals;
            this.in = fst.getBytesReader();
        }

        @Override
        public BytesRef getValueScratchByOrd(int ord, BytesRef ret) {
            if (ord == 0) {
                ret.length = 0;
                return ret;
            }
            this.in.setPosition(0L);
            this.fst.getFirstArc(this.firstArc);
            try {
                IntsRef output = Util.getByOutput(this.fst, (long)ord, (FST.BytesReader)this.in, this.firstArc, this.scratchArc, (IntsRef)this.scratchInts);
                ret.grow(output.length);
                ret.offset = 0;
                ret.length = 0;
                Util.toBytesRef((IntsRef)output, (BytesRef)ret);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return ret;
        }

        static final class MultiHashed
        extends Multi {
            private final int[] hashes;

            MultiHashed(FST<Long> fst, Ordinals.Docs ordinals, int[] hashes) {
                super(fst, ordinals);
                this.hashes = hashes;
            }

            @Override
            protected BytesValues.Iter.Multi newMultiIter() {
                return new BytesValues.Iter.Multi(this){

                    @Override
                    public int hash() {
                        return MultiHashed.this.hashes[this.ord];
                    }
                };
            }

            @Override
            public int getValueHashed(int docId, BytesRef ret) {
                int ord = this.ordinals.getOrd(docId);
                this.getValueScratchByOrd(ord, ret);
                return this.hashes[ord];
            }
        }

        static class Multi
        extends BytesValues {
            private final BytesValues.Iter.Multi iter;

            Multi(FST<Long> fst, Ordinals.Docs ordinals) {
                super(fst, ordinals);
                assert (ordinals.isMultiValued());
                this.iter = this.newMultiIter();
            }

            @Override
            public BytesValues.Iter getIter(int docId) {
                return this.iter.reset(this.ordinals.getIter(docId));
            }
        }

        static final class SingleHashed
        extends Single {
            private final int[] hashes;

            SingleHashed(FST<Long> fst, Ordinals.Docs ordinals, int[] hashes) {
                super(fst, ordinals);
                this.hashes = hashes;
            }

            @Override
            protected BytesValues.Iter.Single newSingleIter() {
                return new BytesValues.Iter.Single(){

                    @Override
                    public int hash() {
                        return SingleHashed.this.hashes[this.ord];
                    }
                };
            }

            @Override
            public int getValueHashed(int docId, BytesRef ret) {
                int ord = this.ordinals.getOrd(docId);
                this.getValueScratchByOrd(ord, ret);
                return this.hashes[ord];
            }
        }

        static class Single
        extends BytesValues {
            private final BytesValues.Iter.Single iter;

            Single(FST<Long> fst, Ordinals.Docs ordinals) {
                super(fst, ordinals);
                assert (!ordinals.isMultiValued());
                this.iter = this.newSingleIter();
            }

            @Override
            public BytesValues.Iter getIter(int docId) {
                int ord = this.ordinals.getOrd(docId);
                if (ord == 0) {
                    return BytesValues.Iter.Empty.INSTANCE;
                }
                return this.iter.reset(this.getValueByOrd(ord), ord);
            }
        }
    }
}

