/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.AbstractBytesIndexFieldData;
import org.elasticsearch.index.fielddata.plain.FSTBytesAtomicFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.settings.IndexSettings;

public class FSTBytesIndexFieldData
extends AbstractBytesIndexFieldData<FSTBytesAtomicFieldData> {
    FSTBytesIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FSTBytesAtomicFieldData loadDirect(AtomicReaderContext context) throws Exception {
        AtomicReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        if (terms == null) {
            return FSTBytesAtomicFieldData.empty(reader.maxDoc());
        }
        PositiveIntOutputs outputs = PositiveIntOutputs.getSingleton((boolean)true);
        org.apache.lucene.util.fst.Builder fstBuilder = new org.apache.lucene.util.fst.Builder(FST.INPUT_TYPE.BYTE1, (Outputs)outputs);
        IntsRef scratch = new IntsRef();
        OrdinalsBuilder builder = new OrdinalsBuilder(terms, reader.maxDoc());
        try {
            TermsEnum termsEnum = this.filter(terms, reader);
            DocsEnum docsEnum = null;
            BytesRef term = termsEnum.next();
            while (term != null) {
                int termOrd = builder.nextOrdinal();
                assert (termOrd > 0);
                fstBuilder.add(Util.toIntsRef((BytesRef)term, (IntsRef)scratch), (Object)termOrd);
                docsEnum = termsEnum.docs(reader.getLiveDocs(), docsEnum, 0);
                int docId = docsEnum.nextDoc();
                while (docId != Integer.MAX_VALUE) {
                    builder.addDoc(docId);
                    docId = docsEnum.nextDoc();
                }
                term = termsEnum.next();
            }
            FST fst = fstBuilder.finish();
            Ordinals ordinals = builder.build(this.fieldDataType.getSettings());
            FSTBytesAtomicFieldData fSTBytesAtomicFieldData = new FSTBytesAtomicFieldData((FST<Long>)fst, ordinals);
            return fSTBytesAtomicFieldData;
        }
        finally {
            builder.close();
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<FSTBytesAtomicFieldData> build(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType type, IndexFieldDataCache cache) {
            return new FSTBytesIndexFieldData(index, indexSettings, fieldNames, type, cache);
        }
    }
}

