/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public abstract class GeoPointDoubleArrayAtomicFieldData
extends AtomicGeoPointFieldData<ScriptDocValues> {
    public static final GeoPointDoubleArrayAtomicFieldData EMPTY = new Empty();
    protected final double[] lon;
    protected final double[] lat;
    private final int numDocs;
    protected long size = -1L;

    public GeoPointDoubleArrayAtomicFieldData(double[] lon, double[] lat, int numDocs) {
        this.lon = lon;
        this.lat = lat;
        this.numDocs = numDocs;
    }

    @Override
    public void close() {
    }

    @Override
    public int getNumDocs() {
        return this.numDocs;
    }

    @Override
    public ScriptDocValues getScriptValues() {
        return new ScriptDocValues.GeoPoints(this.getGeoPointValues());
    }

    public static class Single
    extends GeoPointDoubleArrayAtomicFieldData {
        public Single(double[] lon, double[] lat, int numDocs) {
            super(lon, lat, numDocs);
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isValuesOrdered() {
            return false;
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = 8 + (RamUsage.NUM_BYTES_ARRAY_HEADER + this.lon.length * 8) + (RamUsage.NUM_BYTES_ARRAY_HEADER + this.lat.length * 8);
            }
            return this.size;
        }

        @Override
        public GeoPointValues getGeoPointValues() {
            return new GeoPointValues(this.lon, this.lat);
        }

        static class GeoPointValues
        implements org.elasticsearch.index.fielddata.GeoPointValues {
            private final double[] lon;
            private final double[] lat;
            private final GeoPoint scratch = new GeoPoint();
            private final GeoPointValues.Iter.Single iter = new GeoPointValues.Iter.Single();

            GeoPointValues(double[] lon, double[] lat) {
                this.lon = lon;
                this.lat = lat;
            }

            @Override
            public boolean isMultiValued() {
                return false;
            }

            @Override
            public boolean hasValue(int docId) {
                return true;
            }

            @Override
            public GeoPoint getValue(int docId) {
                return this.scratch.reset(this.lat[docId], this.lon[docId]);
            }

            @Override
            public GeoPoint getValueSafe(int docId) {
                return new GeoPoint(this.lat[docId], this.lon[docId]);
            }

            @Override
            public GeoPointValues.Iter getIter(int docId) {
                return this.iter.reset(this.scratch.reset(this.lat[docId], this.lon[docId]));
            }

            @Override
            public GeoPointValues.Iter getIterSafe(int docId) {
                return this.iter.reset(new GeoPoint(this.lat[docId], this.lon[docId]));
            }
        }
    }

    public static class SingleFixedSet
    extends GeoPointDoubleArrayAtomicFieldData {
        private final FixedBitSet set;

        public SingleFixedSet(double[] lon, double[] lat, int numDocs, FixedBitSet set) {
            super(lon, lat, numDocs);
            this.set = set;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isValuesOrdered() {
            return false;
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = 8 + (RamUsage.NUM_BYTES_ARRAY_HEADER + this.lon.length * 8) + (RamUsage.NUM_BYTES_ARRAY_HEADER + this.lat.length * 8) + this.set.getBits().length * 8;
            }
            return this.size;
        }

        @Override
        public GeoPointValues getGeoPointValues() {
            return new GeoPointValues(this.lon, this.lat, this.set);
        }

        static class GeoPointValues
        implements org.elasticsearch.index.fielddata.GeoPointValues {
            private final double[] lon;
            private final double[] lat;
            private final FixedBitSet set;
            private final GeoPoint scratch = new GeoPoint();
            private final GeoPointValues.Iter.Single iter = new GeoPointValues.Iter.Single();

            GeoPointValues(double[] lon, double[] lat, FixedBitSet set) {
                this.lon = lon;
                this.lat = lat;
                this.set = set;
            }

            @Override
            public boolean isMultiValued() {
                return false;
            }

            @Override
            public boolean hasValue(int docId) {
                return this.set.get(docId);
            }

            @Override
            public GeoPoint getValue(int docId) {
                if (this.set.get(docId)) {
                    return this.scratch.reset(this.lat[docId], this.lon[docId]);
                }
                return null;
            }

            @Override
            public GeoPoint getValueSafe(int docId) {
                if (this.set.get(docId)) {
                    return new GeoPoint(this.lat[docId], this.lon[docId]);
                }
                return null;
            }

            @Override
            public GeoPointValues.Iter getIter(int docId) {
                if (this.set.get(docId)) {
                    return this.iter.reset(this.scratch.reset(this.lat[docId], this.lon[docId]));
                }
                return GeoPointValues.Iter.Empty.INSTANCE;
            }

            @Override
            public GeoPointValues.Iter getIterSafe(int docId) {
                if (this.set.get(docId)) {
                    return this.iter.reset(new GeoPoint(this.lat[docId], this.lon[docId]));
                }
                return GeoPointValues.Iter.Empty.INSTANCE;
            }
        }
    }

    public static class WithOrdinals
    extends GeoPointDoubleArrayAtomicFieldData {
        private final Ordinals ordinals;

        public WithOrdinals(double[] lon, double[] lat, int numDocs, Ordinals ordinals) {
            super(lon, lat, numDocs);
            this.ordinals = ordinals;
        }

        @Override
        public boolean isMultiValued() {
            return this.ordinals.isMultiValued();
        }

        @Override
        public boolean isValuesOrdered() {
            return true;
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = (long)(8 + (RamUsage.NUM_BYTES_ARRAY_HEADER + this.lon.length * 8) + (RamUsage.NUM_BYTES_ARRAY_HEADER + this.lat.length * 8)) + this.ordinals.getMemorySizeInBytes();
            }
            return this.size;
        }

        @Override
        public GeoPointValues getGeoPointValues() {
            return new GeoPointValues(this.lon, this.lat, this.ordinals.ordinals());
        }

        static class GeoPointValues
        implements org.elasticsearch.index.fielddata.GeoPointValues {
            private final double[] lon;
            private final double[] lat;
            private final Ordinals.Docs ordinals;
            private final GeoPoint scratch = new GeoPoint();
            private final ValuesIter valuesIter;
            private final SafeValuesIter safeValuesIter;

            GeoPointValues(double[] lon, double[] lat, Ordinals.Docs ordinals) {
                this.lon = lon;
                this.lat = lat;
                this.ordinals = ordinals;
                this.valuesIter = new ValuesIter(lon, lat);
                this.safeValuesIter = new SafeValuesIter(lon, lat);
            }

            @Override
            public boolean isMultiValued() {
                return this.ordinals.isMultiValued();
            }

            @Override
            public boolean hasValue(int docId) {
                return this.ordinals.getOrd(docId) != 0;
            }

            @Override
            public GeoPoint getValue(int docId) {
                int ord = this.ordinals.getOrd(docId);
                if (ord == 0) {
                    return null;
                }
                return this.scratch.reset(this.lat[ord], this.lon[ord]);
            }

            @Override
            public GeoPoint getValueSafe(int docId) {
                int ord = this.ordinals.getOrd(docId);
                if (ord == 0) {
                    return null;
                }
                return new GeoPoint(this.lat[ord], this.lon[ord]);
            }

            @Override
            public GeoPointValues.Iter getIter(int docId) {
                return this.valuesIter.reset(this.ordinals.getIter(docId));
            }

            @Override
            public GeoPointValues.Iter getIterSafe(int docId) {
                return this.safeValuesIter.reset(this.ordinals.getIter(docId));
            }

            static class SafeValuesIter
            implements GeoPointValues.Iter {
                private final double[] lon;
                private final double[] lat;
                private Ordinals.Docs.Iter ordsIter;
                private int ord;

                SafeValuesIter(double[] lon, double[] lat) {
                    this.lon = lon;
                    this.lat = lat;
                }

                public SafeValuesIter reset(Ordinals.Docs.Iter ordsIter) {
                    this.ordsIter = ordsIter;
                    this.ord = ordsIter.next();
                    return this;
                }

                @Override
                public boolean hasNext() {
                    return this.ord != 0;
                }

                @Override
                public GeoPoint next() {
                    GeoPoint value = new GeoPoint(this.lat[this.ord], this.lon[this.ord]);
                    this.ord = this.ordsIter.next();
                    return value;
                }
            }

            static class ValuesIter
            implements GeoPointValues.Iter {
                private final double[] lon;
                private final double[] lat;
                private final GeoPoint scratch = new GeoPoint();
                private Ordinals.Docs.Iter ordsIter;
                private int ord;

                ValuesIter(double[] lon, double[] lat) {
                    this.lon = lon;
                    this.lat = lat;
                }

                public ValuesIter reset(Ordinals.Docs.Iter ordsIter) {
                    this.ordsIter = ordsIter;
                    this.ord = ordsIter.next();
                    return this;
                }

                @Override
                public boolean hasNext() {
                    return this.ord != 0;
                }

                @Override
                public GeoPoint next() {
                    this.scratch.reset(this.lat[this.ord], this.lon[this.ord]);
                    this.ord = this.ordsIter.next();
                    return this.scratch;
                }
            }
        }
    }

    static class Empty
    extends GeoPointDoubleArrayAtomicFieldData {
        Empty() {
            super(null, null, 0);
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isValuesOrdered() {
            return false;
        }

        @Override
        public long getMemorySizeInBytes() {
            return 0L;
        }

        @Override
        public BytesValues getBytesValues() {
            return BytesValues.EMPTY;
        }

        @Override
        public GeoPointValues getGeoPointValues() {
            return GeoPointValues.EMPTY;
        }

        @Override
        public ScriptDocValues getScriptValues() {
            return ScriptDocValues.EMPTY;
        }
    }
}

