/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.trove.list.array.TDoubleArrayList;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AbstractIndexFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.GeoPointDoubleArrayAtomicFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.settings.IndexSettings;

public class GeoPointDoubleArrayIndexFieldData
extends AbstractIndexFieldData<GeoPointDoubleArrayAtomicFieldData>
implements IndexGeoPointFieldData<GeoPointDoubleArrayAtomicFieldData> {
    public GeoPointDoubleArrayIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
    }

    @Override
    public boolean valuesOrdered() {
        return false;
    }

    @Override
    public GeoPointDoubleArrayAtomicFieldData load(AtomicReaderContext context) {
        try {
            return (GeoPointDoubleArrayAtomicFieldData)this.cache.load(context, this);
        }
        catch (Throwable e) {
            if (e instanceof ElasticSearchException) {
                throw (ElasticSearchException)e;
            }
            throw new ElasticSearchException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeoPointDoubleArrayAtomicFieldData loadDirect(AtomicReaderContext context) throws Exception {
        AtomicReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        if (terms == null) {
            return GeoPointDoubleArrayAtomicFieldData.EMPTY;
        }
        TDoubleArrayList lat = new TDoubleArrayList();
        TDoubleArrayList lon = new TDoubleArrayList();
        lat.add(0.0);
        lon.add(0.0);
        OrdinalsBuilder builder = new OrdinalsBuilder(terms, reader.maxDoc());
        CharsRef spare = new CharsRef();
        try {
            BytesRef term;
            BytesRefIterator iter = builder.buildFromTerms(terms.iterator(null), reader.getLiveDocs());
            while ((term = iter.next()) != null) {
                UnicodeUtil.UTF8toUTF16((BytesRef)term, (CharsRef)spare);
                boolean parsed = false;
                for (int i = spare.offset; i < spare.length; ++i) {
                    if (spare.chars[i] != ',') continue;
                    lat.add(Double.parseDouble(new String(spare.chars, spare.offset, i - spare.offset)));
                    lon.add(Double.parseDouble(new String(spare.chars, spare.offset + (i + 1), spare.length - (i + 1 - spare.offset))));
                    parsed = true;
                    break;
                }
                assert (parsed);
            }
            Ordinals build = builder.build(this.fieldDataType.getSettings());
            if (!build.isMultiValued() && IndexFieldData.CommonSettings.removeOrdsOnSingleValue(this.fieldDataType)) {
                Ordinals.Docs ordinals = build.ordinals();
                double[] sLat = new double[reader.maxDoc()];
                double[] sLon = new double[reader.maxDoc()];
                for (int i = 0; i < sLat.length; ++i) {
                    int nativeOrdinal = ordinals.getOrd(i);
                    sLat[i] = lat.get(nativeOrdinal);
                    sLon[i] = lon.get(nativeOrdinal);
                }
                FixedBitSet set = builder.buildDocsWithValuesSet();
                if (set == null) {
                    GeoPointDoubleArrayAtomicFieldData.Single single = new GeoPointDoubleArrayAtomicFieldData.Single(sLon, sLat, reader.maxDoc());
                    return single;
                }
                GeoPointDoubleArrayAtomicFieldData.SingleFixedSet singleFixedSet = new GeoPointDoubleArrayAtomicFieldData.SingleFixedSet(sLon, sLat, reader.maxDoc(), set);
                return singleFixedSet;
            }
            GeoPointDoubleArrayAtomicFieldData.WithOrdinals withOrdinals = new GeoPointDoubleArrayAtomicFieldData.WithOrdinals(lon.toArray(new double[lon.size()]), lat.toArray(new double[lat.size()]), reader.maxDoc(), build);
            return withOrdinals;
        }
        finally {
            builder.close();
        }
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, SortMode sortMode) {
        throw new ElasticSearchIllegalArgumentException("can't sort on geo_point field without using specific sorting feature, like geo_distance");
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData build(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType type, IndexFieldDataCache cache) {
            return new GeoPointDoubleArrayIndexFieldData(index, indexSettings, fieldNames, type, cache);
        }
    }
}

