/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.packed.GrowableWriter;
import org.apache.lucene.util.packed.PackedInts;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.EmptyOrdinals;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public class PagedBytesAtomicFieldData
implements AtomicFieldData.WithOrdinals<ScriptDocValues.Strings> {
    private final PagedBytes.Reader bytes;
    private final PackedInts.Reader termOrdToBytesOffset;
    protected final Ordinals ordinals;
    private volatile int[] hashes;
    private long size = -1L;
    private final long readerBytesSize;

    public static PagedBytesAtomicFieldData empty(int numDocs) {
        return new Empty(numDocs);
    }

    public PagedBytesAtomicFieldData(PagedBytes.Reader bytes, long readerBytesSize, PackedInts.Reader termOrdToBytesOffset, Ordinals ordinals) {
        this.bytes = bytes;
        this.termOrdToBytesOffset = termOrdToBytesOffset;
        this.ordinals = ordinals;
        this.readerBytesSize = readerBytesSize;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isMultiValued() {
        return this.ordinals.isMultiValued();
    }

    @Override
    public int getNumDocs() {
        return this.ordinals.getNumDocs();
    }

    @Override
    public boolean isValuesOrdered() {
        return true;
    }

    @Override
    public long getMemorySizeInBytes() {
        if (this.size == -1L) {
            long size = this.ordinals.getMemorySizeInBytes();
            size += this.readerBytesSize;
            this.size = size += this.termOrdToBytesOffset.ramBytesUsed();
        }
        return this.size;
    }

    private final int[] getHashes() {
        if (this.hashes == null) {
            int numberOfValues = this.termOrdToBytesOffset.size();
            int[] hashes = new int[numberOfValues];
            BytesRef scratch = new BytesRef();
            for (int i = 0; i < numberOfValues; ++i) {
                this.bytes.fill(scratch, this.termOrdToBytesOffset.get(i));
                hashes[i] = scratch.hashCode();
            }
            this.hashes = hashes;
        }
        return this.hashes;
    }

    @Override
    public BytesValues.WithOrdinals getBytesValues() {
        return this.ordinals.isMultiValued() ? new BytesValues.Multi(this.bytes, this.termOrdToBytesOffset, this.ordinals.ordinals()) : new BytesValues.Single(this.bytes, this.termOrdToBytesOffset, this.ordinals.ordinals());
    }

    @Override
    public BytesValues.WithOrdinals getHashedBytesValues() {
        int[] hashes = this.getHashes();
        return this.ordinals.isMultiValued() ? new BytesValues.MultiHashed(hashes, this.bytes, this.termOrdToBytesOffset, this.ordinals.ordinals()) : new BytesValues.SingleHashed(hashes, this.bytes, this.termOrdToBytesOffset, this.ordinals.ordinals());
    }

    @Override
    public ScriptDocValues.Strings getScriptValues() {
        return new ScriptDocValues.Strings(this.getBytesValues());
    }

    static class Empty
    extends PagedBytesAtomicFieldData {
        Empty(int numDocs) {
            super(Empty.emptyBytes(), 0L, (PackedInts.Reader)new GrowableWriter(1, 2, 7.0f).getMutable(), new EmptyOrdinals(numDocs));
        }

        static PagedBytes.Reader emptyBytes() {
            PagedBytes bytes = new PagedBytes(1);
            bytes.copyUsingLengthPrefix(new BytesRef());
            return bytes.freeze(true);
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public int getNumDocs() {
            return this.ordinals.getNumDocs();
        }

        @Override
        public boolean isValuesOrdered() {
            return true;
        }

        @Override
        public BytesValues.WithOrdinals getBytesValues() {
            return new BytesValues.WithOrdinals.Empty(this.ordinals.ordinals());
        }

        @Override
        public ScriptDocValues.Strings getScriptValues() {
            return ScriptDocValues.EMPTY_STRINGS;
        }
    }

    static abstract class BytesValues
    extends BytesValues.WithOrdinals {
        protected final PagedBytes.Reader bytes;
        protected final PackedInts.Reader termOrdToBytesOffset;
        protected final Ordinals.Docs ordinals;
        protected final BytesRef scratch = new BytesRef();

        BytesValues(PagedBytes.Reader bytes, PackedInts.Reader termOrdToBytesOffset, Ordinals.Docs ordinals) {
            super(ordinals);
            this.bytes = bytes;
            this.termOrdToBytesOffset = termOrdToBytesOffset;
            this.ordinals = ordinals;
        }

        @Override
        public BytesRef makeSafe(BytesRef bytes) {
            return new BytesRef(bytes.bytes, bytes.offset, bytes.length);
        }

        @Override
        public Ordinals.Docs ordinals() {
            return this.ordinals;
        }

        @Override
        public BytesRef getValueScratchByOrd(int ord, BytesRef ret) {
            this.bytes.fill(ret, this.termOrdToBytesOffset.get(ord));
            return ret;
        }

        static final class MultiHashed
        extends Multi {
            private final int[] hashes;

            MultiHashed(int[] hashes, PagedBytes.Reader bytes, PackedInts.Reader termOrdToBytesOffset, Ordinals.Docs ordinals) {
                super(bytes, termOrdToBytesOffset, ordinals);
                this.hashes = hashes;
            }

            @Override
            protected BytesValues.Iter.Multi newMultiIter() {
                return new BytesValues.Iter.Multi(this){

                    @Override
                    public int hash() {
                        return MultiHashed.this.hashes[this.ord];
                    }
                };
            }

            @Override
            public int getValueHashed(int docId, BytesRef ret) {
                int ord = this.ordinals.getOrd(docId);
                this.getValueScratchByOrd(ord, ret);
                return this.hashes[ord];
            }
        }

        static class Multi
        extends BytesValues {
            private final BytesValues.Iter.Multi iter;

            Multi(PagedBytes.Reader bytes, PackedInts.Reader termOrdToBytesOffset, Ordinals.Docs ordinals) {
                super(bytes, termOrdToBytesOffset, ordinals);
                assert (ordinals.isMultiValued());
                this.iter = this.newMultiIter();
            }

            @Override
            public BytesValues.Iter getIter(int docId) {
                return this.iter.reset(this.ordinals.getIter(docId));
            }
        }

        static final class SingleHashed
        extends Single {
            private final int[] hashes;

            SingleHashed(int[] hashes, PagedBytes.Reader bytes, PackedInts.Reader termOrdToBytesOffset, Ordinals.Docs ordinals) {
                super(bytes, termOrdToBytesOffset, ordinals);
                this.hashes = hashes;
            }

            @Override
            protected BytesValues.Iter.Single newSingleIter() {
                return new BytesValues.Iter.Single(){

                    @Override
                    public int hash() {
                        return SingleHashed.this.hashes[this.ord];
                    }
                };
            }

            @Override
            public int getValueHashed(int docId, BytesRef ret) {
                int ord = this.ordinals.getOrd(docId);
                this.getValueScratchByOrd(ord, ret);
                return this.hashes[ord];
            }
        }

        static class Single
        extends BytesValues {
            private final BytesValues.Iter.Single iter;

            Single(PagedBytes.Reader bytes, PackedInts.Reader termOrdToBytesOffset, Ordinals.Docs ordinals) {
                super(bytes, termOrdToBytesOffset, ordinals);
                assert (!ordinals.isMultiValued());
                this.iter = this.newSingleIter();
            }

            @Override
            public BytesValues.Iter getIter(int docId) {
                int ord = this.ordinals.getOrd(docId);
                if (ord == 0) {
                    return BytesValues.Iter.Empty.INSTANCE;
                }
                this.bytes.fill(this.scratch, this.termOrdToBytesOffset.get(ord));
                return this.iter.reset(this.scratch, ord);
            }
        }
    }
}

