/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.packed.GrowableWriter;
import org.apache.lucene.util.packed.PackedInts;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.AbstractBytesIndexFieldData;
import org.elasticsearch.index.fielddata.plain.PagedBytesAtomicFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.settings.IndexSettings;

public class PagedBytesIndexFieldData
extends AbstractBytesIndexFieldData<PagedBytesAtomicFieldData> {
    public PagedBytesIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PagedBytesAtomicFieldData loadDirect(AtomicReaderContext context) throws Exception {
        int startNumUniqueTerms;
        int startBytesBPV;
        AtomicReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        if (terms == null) {
            return PagedBytesAtomicFieldData.empty(reader.maxDoc());
        }
        PagedBytes bytes = new PagedBytes(15);
        int maxDoc = reader.maxDoc();
        int termCountHardLimit = maxDoc == Integer.MAX_VALUE ? Integer.MAX_VALUE : maxDoc + 1;
        long numUniqueTerms = terms.size();
        if (numUniqueTerms != -1L) {
            if (numUniqueTerms > (long)termCountHardLimit) {
                numUniqueTerms = termCountHardLimit;
            }
            startBytesBPV = PackedInts.bitsRequired((long)(numUniqueTerms * 4L));
            startNumUniqueTerms = (int)numUniqueTerms;
        } else {
            startBytesBPV = 1;
            startNumUniqueTerms = 1;
        }
        float acceptableOverheadRatio = 0.5f;
        GrowableWriter termOrdToBytesOffset = new GrowableWriter(startBytesBPV, 1 + startNumUniqueTerms, acceptableOverheadRatio);
        OrdinalsBuilder builder = new OrdinalsBuilder(terms, reader.maxDoc());
        try {
            bytes.copyUsingLengthPrefix(new BytesRef());
            TermsEnum termsEnum = this.filter(terms, reader);
            DocsEnum docsEnum = null;
            BytesRef term = termsEnum.next();
            while (term != null) {
                int termOrd = builder.nextOrdinal();
                if (termOrd == termOrdToBytesOffset.size()) {
                    termOrdToBytesOffset = termOrdToBytesOffset.resize(ArrayUtil.oversize((int)(1 + termOrd), (int)1));
                }
                termOrdToBytesOffset.set(termOrd, bytes.copyUsingLengthPrefix(term));
                docsEnum = termsEnum.docs(reader.getLiveDocs(), docsEnum, 0);
                int docId = docsEnum.nextDoc();
                while (docId != Integer.MAX_VALUE) {
                    builder.addDoc(docId);
                    docId = docsEnum.nextDoc();
                }
                term = termsEnum.next();
            }
            long sizePointer = bytes.getPointer();
            PagedBytes.Reader bytesReader = bytes.freeze(true);
            PackedInts.Mutable termOrdToBytesOffsetReader = termOrdToBytesOffset.getMutable();
            Ordinals ordinals = builder.build(this.fieldDataType.getSettings());
            PagedBytesAtomicFieldData pagedBytesAtomicFieldData = new PagedBytesAtomicFieldData(bytesReader, sizePointer, (PackedInts.Reader)termOrdToBytesOffsetReader, ordinals);
            return pagedBytesAtomicFieldData;
        }
        finally {
            builder.close();
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<PagedBytesAtomicFieldData> build(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType type, IndexFieldDataCache cache) {
            return new PagedBytesIndexFieldData(index, indexSettings, fieldNames, type, cache);
        }
    }
}

