/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.similarity.SimilarityProvider;

public interface FieldMapper<T> {
    public Names names();

    public FieldType fieldType();

    public float boost();

    public Analyzer indexAnalyzer();

    public Analyzer searchAnalyzer();

    public Analyzer searchQuoteAnalyzer();

    public SimilarityProvider similarity();

    public T value(Object var1);

    public Object valueForSearch(Object var1);

    public BytesRef indexedValueForSearch(Object var1);

    public boolean useTermQueryWithQueryString();

    public Query termQuery(Object var1, @Nullable QueryParseContext var2);

    public Filter termFilter(Object var1, @Nullable QueryParseContext var2);

    public Filter termsFilter(List<Object> var1, @Nullable QueryParseContext var2);

    public Query rangeQuery(Object var1, Object var2, boolean var3, boolean var4, @Nullable QueryParseContext var5);

    public Filter rangeFilter(Object var1, Object var2, boolean var3, boolean var4, @Nullable QueryParseContext var5);

    public Query fuzzyQuery(String var1, String var2, int var3, int var4, boolean var5);

    public Query prefixQuery(Object var1, @Nullable MultiTermQuery.RewriteMethod var2, @Nullable QueryParseContext var3);

    public Filter prefixFilter(Object var1, @Nullable QueryParseContext var2);

    public Query regexpQuery(Object var1, int var2, @Nullable MultiTermQuery.RewriteMethod var3, @Nullable QueryParseContext var4);

    public Filter regexpFilter(Object var1, int var2, @Nullable QueryParseContext var3);

    @Nullable
    public Query queryStringTermQuery(Term var1);

    @Nullable
    public Filter nullValueFilter();

    public FieldDataType fieldDataType();

    public PostingsFormatProvider postingsFormatProvider();

    public boolean isNumeric();

    public static class Names {
        private final String name;
        private final String indexName;
        private final String indexNameClean;
        private final String fullName;
        private final String sourcePath;

        public Names(String name) {
            this(name, name, name, name);
        }

        public Names(String name, String indexName, String indexNameClean, String fullName) {
            this(name, indexName, indexNameClean, fullName, fullName);
        }

        public Names(String name, String indexName, String indexNameClean, String fullName, @Nullable String sourcePath) {
            this.name = name.intern();
            this.indexName = indexName.intern();
            this.indexNameClean = indexNameClean.intern();
            this.fullName = fullName.intern();
            this.sourcePath = sourcePath == null ? this.fullName : sourcePath.intern();
        }

        public String name() {
            return this.name;
        }

        public String indexName() {
            return this.indexName;
        }

        public String indexNameClean() {
            return this.indexNameClean;
        }

        public String fullName() {
            return this.fullName;
        }

        public String sourcePath() {
            return this.sourcePath;
        }

        public Term createIndexNameTerm(String value) {
            return new Term(this.indexName, value);
        }

        public Term createIndexNameTerm(BytesRef value) {
            return new Term(this.indexName, value);
        }
    }
}

