/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentParser;

public class SourceToParse {
    private final BytesReference source;
    private final XContentParser parser;
    private boolean flyweight = false;
    private String type;
    private String id;
    private String routing;
    private String parentId;
    private long timestamp;
    private long ttl;

    public static SourceToParse source(XContentParser parser) {
        return new SourceToParse(parser);
    }

    public static SourceToParse source(BytesReference source) {
        return new SourceToParse(source);
    }

    public SourceToParse(XContentParser parser) {
        this.parser = parser;
        this.source = null;
    }

    public SourceToParse(BytesReference source) {
        this.source = source.toBytesArray();
        this.parser = null;
    }

    public XContentParser parser() {
        return this.parser;
    }

    public BytesReference source() {
        return this.source;
    }

    public String type() {
        return this.type;
    }

    public SourceToParse type(String type) {
        this.type = type;
        return this;
    }

    public SourceToParse flyweight(boolean flyweight) {
        this.flyweight = flyweight;
        return this;
    }

    public boolean flyweight() {
        return this.flyweight;
    }

    public String id() {
        return this.id;
    }

    public SourceToParse id(String id) {
        this.id = id;
        return this;
    }

    public String parent() {
        return this.parentId;
    }

    public SourceToParse parent(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public SourceToParse routing(String routing) {
        this.routing = routing;
        return this;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public SourceToParse timestamp(String timestamp) {
        this.timestamp = Long.parseLong(timestamp);
        return this;
    }

    public SourceToParse timestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public long ttl() {
        return this.ttl;
    }

    public SourceToParse ttl(long ttl) {
        this.ttl = ttl;
        return this;
    }
}

