/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.search.Filter;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NamedCustomAnalyzer;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.internal.AllFieldMapper;
import org.elasticsearch.index.similarity.SimilarityProvider;

public class StringFieldMapper
extends AbstractFieldMapper<String>
implements AllFieldMapper.IncludeInAll {
    public static final String CONTENT_TYPE = "string";
    private String nullValue;
    private Boolean includeInAll;
    private int positionOffsetGap;
    private NamedAnalyzer searchQuotedAnalyzer;
    private int ignoreAbove;
    private static final ThreadLocal<StringTokenStream> NOT_ANALYZED_TOKENSTREAM = new ThreadLocal<StringTokenStream>(){

        @Override
        protected StringTokenStream initialValue() {
            return new StringTokenStream();
        }
    };

    protected StringFieldMapper(FieldMapper.Names names, float boost, FieldType fieldType, String nullValue, NamedAnalyzer indexAnalyzer, NamedAnalyzer searchAnalyzer, NamedAnalyzer searchQuotedAnalyzer, int positionOffsetGap, int ignoreAbove, PostingsFormatProvider postingsFormat, SimilarityProvider similarity, @Nullable Settings fieldDataSettings) {
        super(names, boost, fieldType, indexAnalyzer, searchAnalyzer, postingsFormat, similarity, fieldDataSettings);
        this.nullValue = nullValue;
        this.positionOffsetGap = positionOffsetGap;
        this.searchQuotedAnalyzer = searchQuotedAnalyzer != null ? searchQuotedAnalyzer : this.searchAnalyzer;
        this.ignoreAbove = ignoreAbove;
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return new FieldDataType(CONTENT_TYPE);
    }

    @Override
    public void includeInAll(Boolean includeInAll) {
        if (includeInAll != null) {
            this.includeInAll = includeInAll;
        }
    }

    @Override
    public void includeInAllIfNotSet(Boolean includeInAll) {
        if (includeInAll != null && this.includeInAll == null) {
            this.includeInAll = includeInAll;
        }
    }

    @Override
    public String value(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    protected boolean customBoost() {
        return true;
    }

    public int getPositionOffsetGap() {
        return this.positionOffsetGap;
    }

    @Override
    public Analyzer searchQuoteAnalyzer() {
        return this.searchQuotedAnalyzer;
    }

    @Override
    public Filter nullValueFilter() {
        if (this.nullValue == null) {
            return null;
        }
        return this.termFilter(this.nullValue, null);
    }

    @Override
    protected Field parseCreateField(ParseContext context) throws IOException {
        String value = this.nullValue;
        float boost = this.boost;
        if (context.externalValueSet()) {
            value = (String)context.externalValue();
        } else {
            XContentParser parser = context.parser();
            if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                value = this.nullValue;
            } else if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                XContentParser.Token token;
                String currentFieldName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("value".equals(currentFieldName) || "_value".equals(currentFieldName)) {
                        value = parser.textOrNull();
                        continue;
                    }
                    if ("boost".equals(currentFieldName) || "_boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    throw new ElasticSearchIllegalArgumentException("unknown property [" + currentFieldName + "]");
                }
            } else {
                value = parser.textOrNull();
            }
        }
        if (value == null) {
            return null;
        }
        if (this.ignoreAbove > 0 && value.length() > this.ignoreAbove) {
            return null;
        }
        if (context.includeInAll(this.includeInAll, this)) {
            context.allEntries().addText(this.names.fullName(), value, boost);
        }
        if (!this.fieldType().indexed() && !this.fieldType().stored()) {
            context.ignoredValue(this.names.indexName(), value);
            return null;
        }
        StringField field = new StringField(this.names.indexName(), value, this.fieldType);
        field.setBoost(boost);
        return field;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.includeInAll = ((StringFieldMapper)mergeWith).includeInAll;
            this.nullValue = ((StringFieldMapper)mergeWith).nullValue;
            this.ignoreAbove = ((StringFieldMapper)mergeWith).ignoreAbove;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder) throws IOException {
        super.doXContentBody(builder);
        if (this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        }
        if (this.positionOffsetGap != 0) {
            builder.field("position_offset_gap", this.positionOffsetGap);
        }
        if (this.searchQuotedAnalyzer != null && this.searchAnalyzer != this.searchQuotedAnalyzer) {
            builder.field("search_quote_analyzer", this.searchQuotedAnalyzer.name());
        }
        if (this.ignoreAbove != -1) {
            builder.field("ignore_above", this.ignoreAbove);
        }
    }

    static final class StringTokenStream
    extends TokenStream {
        private final CharTermAttribute termAttribute = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private final OffsetAttribute offsetAttribute = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        private boolean used = false;
        private String value = null;

        StringTokenStream() {
        }

        StringTokenStream setValue(String value) {
            this.value = value;
            return this;
        }

        public boolean incrementToken() {
            if (this.used) {
                return false;
            }
            this.clearAttributes();
            this.termAttribute.append(this.value);
            this.offsetAttribute.setOffset(0, this.value.length());
            this.used = true;
            return true;
        }

        public void end() {
            int finalOffset = this.value.length();
            this.offsetAttribute.setOffset(finalOffset, finalOffset);
            this.value = null;
        }

        public void reset() {
            this.used = false;
        }

        public void close() {
            this.value = null;
        }
    }

    static class StringField
    extends Field {
        public StringField(String name, String value, FieldType fieldType) {
            super(name, value, fieldType);
        }

        public TokenStream tokenStream(Analyzer analyzer) throws IOException {
            if (!this.fieldType().indexed()) {
                return null;
            }
            if (this.fieldType().tokenized()) {
                return super.tokenStream(analyzer);
            }
            return ((StringTokenStream)((Object)NOT_ANALYZED_TOKENSTREAM.get())).setValue((String)this.fieldsData);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.stringField(name);
            TypeParsers.parseField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    builder.nullValue(propNode.toString());
                    continue;
                }
                if (propName.equals("search_quote_analyzer")) {
                    NamedAnalyzer analyzer = parserContext.analysisService().analyzer(propNode.toString());
                    if (analyzer == null) {
                        throw new MapperParsingException("Analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
                    }
                    builder.searchQuotedAnalyzer(analyzer);
                    continue;
                }
                if (propName.equals("position_offset_gap")) {
                    builder.positionOffsetGap(XContentMapValues.nodeIntegerValue(propNode, -1));
                    if (builder.indexAnalyzer == null) {
                        builder.indexAnalyzer = parserContext.analysisService().defaultIndexAnalyzer();
                    }
                    if (builder.searchAnalyzer == null) {
                        builder.searchAnalyzer = parserContext.analysisService().defaultSearchAnalyzer();
                    }
                    if (builder.searchQuotedAnalyzer != null) continue;
                    builder.searchQuotedAnalyzer = parserContext.analysisService().defaultSearchQuoteAnalyzer();
                    continue;
                }
                if (!propName.equals("ignore_above")) continue;
                builder.ignoreAbove(XContentMapValues.nodeIntegerValue(propNode, -1));
            }
            return builder;
        }
    }

    public static class Builder
    extends AbstractFieldMapper.OpenBuilder<Builder, StringFieldMapper> {
        protected String nullValue = Defaults.NULL_VALUE;
        protected int positionOffsetGap = 0;
        protected NamedAnalyzer searchQuotedAnalyzer;
        protected int ignoreAbove = -1;

        public Builder(String name) {
            super(name, new FieldType(Defaults.FIELD_TYPE));
            this.builder = this;
        }

        public Builder nullValue(String nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        @Override
        public Builder includeInAll(Boolean includeInAll) {
            this.includeInAll = includeInAll;
            return this;
        }

        @Override
        public Builder searchAnalyzer(NamedAnalyzer searchAnalyzer) {
            super.searchAnalyzer(searchAnalyzer);
            if (this.searchQuotedAnalyzer == null) {
                this.searchQuotedAnalyzer = searchAnalyzer;
            }
            return this;
        }

        public Builder positionOffsetGap(int positionOffsetGap) {
            this.positionOffsetGap = positionOffsetGap;
            return this;
        }

        public Builder searchQuotedAnalyzer(NamedAnalyzer analyzer) {
            this.searchQuotedAnalyzer = analyzer;
            return (Builder)this.builder;
        }

        public Builder ignoreAbove(int ignoreAbove) {
            this.ignoreAbove = ignoreAbove;
            return this;
        }

        @Override
        public StringFieldMapper build(Mapper.BuilderContext context) {
            if (this.positionOffsetGap > 0) {
                this.indexAnalyzer = new NamedCustomAnalyzer(this.indexAnalyzer, this.positionOffsetGap);
                this.searchAnalyzer = new NamedCustomAnalyzer(this.searchAnalyzer, this.positionOffsetGap);
                this.searchQuotedAnalyzer = new NamedCustomAnalyzer(this.searchQuotedAnalyzer, this.positionOffsetGap);
            }
            if (this.fieldType.indexed() && !this.fieldType.tokenized()) {
                if (!this.omitNormsSet && this.boost == 1.0f) {
                    this.fieldType.setOmitNorms(true);
                }
                if (!this.indexOptionsSet) {
                    this.fieldType.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
                }
            }
            StringFieldMapper fieldMapper = new StringFieldMapper(this.buildNames(context), this.boost, this.fieldType, this.nullValue, this.indexAnalyzer, this.searchAnalyzer, this.searchQuotedAnalyzer, this.positionOffsetGap, this.ignoreAbove, this.provider, this.similarity, this.fieldDataSettings);
            fieldMapper.includeInAll(this.includeInAll);
            return fieldMapper;
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final FieldType FIELD_TYPE = new FieldType(AbstractFieldMapper.Defaults.FIELD_TYPE);
        public static final String NULL_VALUE;
        public static final int POSITION_OFFSET_GAP = 0;
        public static final int IGNORE_ABOVE = -1;

        static {
            FIELD_TYPE.freeze();
            NULL_VALUE = null;
        }
    }
}

