/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.uid.UidField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;

public class UidFieldMapper
extends AbstractFieldMapper<Uid>
implements InternalMapper,
RootMapper {
    public static final String NAME = "_uid".intern();
    public static final String CONTENT_TYPE = "_uid";
    private ThreadLocal<UidField> fieldCache = new ThreadLocal<UidField>(){

        @Override
        protected UidField initialValue() {
            return new UidField(UidFieldMapper.this.names().indexName(), "", 0L);
        }
    };

    public UidFieldMapper() {
        this(Defaults.NAME);
    }

    protected UidFieldMapper(String name) {
        this(name, name, null);
    }

    protected UidFieldMapper(String name, String indexName, PostingsFormatProvider postingsFormat) {
        super(new FieldMapper.Names(name, indexName, indexName, name), 1.0f, new FieldType(Defaults.FIELD_TYPE), Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER, postingsFormat, null, null);
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return new FieldDataType("string");
    }

    @Override
    protected String defaultPostingFormat() {
        return "default";
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        if (context.sourceToParse().id() != null) {
            context.id(context.sourceToParse().id());
            super.parse(context);
        }
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        if (context.id() == null && !context.sourceToParse().flyweight()) {
            throw new MapperParsingException("No id found while parsing the content source");
        }
        if (context.sourceToParse().id() == null) {
            super.parse(context);
            if (context.docs().size() > 1) {
                UidField uidField = (UidField)context.rootDoc().getField(NAME);
                assert (uidField != null);
                for (int i = 1; i < context.docs().size(); ++i) {
                    context.docs().get(i).add((IndexableField)new Field(NAME, uidField.uid(), Defaults.NESTED_FIELD_TYPE));
                }
            }
        }
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    public void validate(ParseContext context) throws MapperParsingException {
    }

    @Override
    public boolean includeInObject() {
        return false;
    }

    @Override
    protected Field parseCreateField(ParseContext context) throws IOException {
        UidField field = this.fieldCache.get();
        field.setUid(Uid.createUid(context.stringBuilder(), context.type(), context.id()));
        context.uid(field);
        return field;
    }

    @Override
    public Uid value(Object value) {
        if (value == null) {
            return null;
        }
        return Uid.createUid(value.toString());
    }

    public Term term(String type, String id) {
        return this.term(Uid.createUid(type, id));
    }

    public Term term(String uid) {
        return this.names().createIndexNameTerm(uid);
    }

    @Override
    public void close() {
        this.fieldCache.remove();
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.postingsFormat == null || this.postingsFormat.name().equals(this.defaultPostingFormat())) {
            return builder;
        }
        builder.startObject(CONTENT_TYPE);
        if (this.postingsFormat != null && !this.postingsFormat.name().equals(this.defaultPostingFormat())) {
            builder.field("postings_format", this.postingsFormat.name());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        AbstractFieldMapper fieldMergeWith = (AbstractFieldMapper)mergeWith;
        if (!mergeContext.mergeFlags().simulate() && fieldMergeWith.postingsFormatProvider() != null) {
            this.postingsFormat = fieldMergeWith.postingsFormatProvider();
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.uid();
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("postings_format")) continue;
                String postingFormatName = fieldNode.toString();
                builder.postingsFormat = parserContext.postingFormatService().get(postingFormatName);
            }
            return builder;
        }
    }

    public static class Builder
    extends Mapper.Builder<Builder, UidFieldMapper> {
        protected String indexName;
        protected PostingsFormatProvider postingsFormat;

        public Builder() {
            super(Defaults.NAME);
            this.indexName = this.name;
        }

        @Override
        public UidFieldMapper build(Mapper.BuilderContext context) {
            return new UidFieldMapper(this.name, this.indexName, this.postingsFormat);
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = NAME;
        public static final FieldType FIELD_TYPE = new FieldType(AbstractFieldMapper.Defaults.FIELD_TYPE);
        public static final FieldType NESTED_FIELD_TYPE = new FieldType(AbstractFieldMapper.Defaults.FIELD_TYPE);

        static {
            FIELD_TYPE.setIndexed(true);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            FIELD_TYPE.freeze();
            NESTED_FIELD_TYPE.setIndexed(true);
            NESTED_FIELD_TYPE.setTokenized(false);
            NESTED_FIELD_TYPE.setStored(false);
            NESTED_FIELD_TYPE.setOmitNorms(true);
            NESTED_FIELD_TYPE.freeze();
        }
    }
}

