/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge.scheduler;

import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class MergeSchedulerProvider<T extends MergeScheduler>
extends AbstractIndexShardComponent
implements IndexShardComponent {
    private final ThreadPool threadPool;
    private final CopyOnWriteArrayList<FailureListener> failureListeners = new CopyOnWriteArrayList();
    private final boolean notifyOnMergeFailure;

    protected MergeSchedulerProvider(ShardId shardId, @IndexSettings Settings indexSettings, ThreadPool threadPool) {
        super(shardId, indexSettings);
        this.threadPool = threadPool;
        this.notifyOnMergeFailure = this.componentSettings.getAsBoolean("notify_on_failure", (Boolean)true);
    }

    public void addFailureListener(FailureListener listener) {
        this.failureListeners.add(listener);
    }

    protected void failedMerge(final MergePolicy.MergeException e) {
        if (!this.notifyOnMergeFailure) {
            return;
        }
        for (final FailureListener failureListener : this.failureListeners) {
            this.threadPool.generic().execute(new Runnable(){

                @Override
                public void run() {
                    failureListener.onFailedMerge(e);
                }
            });
        }
    }

    public abstract T newMergeScheduler();

    public abstract MergeStats stats();

    public static interface FailureListener {
        public void onFailedMerge(MergePolicy.MergeException var1);
    }
}

