/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.percolator;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.TermFilter;
import org.elasticsearch.common.lucene.search.XConstantScoreQuery;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fieldvisitor.UidAndSourceFieldsVisitor;
import org.elasticsearch.index.indexing.IndexingOperationListener;
import org.elasticsearch.index.percolator.PercolatorException;
import org.elasticsearch.index.percolator.PercolatorExecutor;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.IndicesService;

public class PercolatorService
extends AbstractIndexComponent {
    public static final String INDEX_NAME = "_percolator";
    private final IndicesService indicesService;
    private final PercolatorExecutor percolator;
    private final ShardLifecycleListener shardLifecycleListener;
    private final RealTimePercolatorOperationListener realTimePercolatorOperationListener = new RealTimePercolatorOperationListener();
    private final Object mutex = new Object();
    private boolean initialQueriesFetchDone = false;

    @Inject
    public PercolatorService(Index index, @IndexSettings Settings indexSettings, IndicesService indicesService, PercolatorExecutor percolator) {
        super(index, indexSettings);
        IndexService percolatorIndexService;
        this.indicesService = indicesService;
        this.percolator = percolator;
        this.shardLifecycleListener = new ShardLifecycleListener();
        this.indicesService.indicesLifecycle().addListener(this.shardLifecycleListener);
        this.percolator.setIndicesService(indicesService);
        if (this.percolatorAllocated() && (percolatorIndexService = this.percolatorIndexService()) != null) {
            for (IndexShard indexShard : percolatorIndexService) {
                try {
                    indexShard.indexingService().addListener(this.realTimePercolatorOperationListener);
                }
                catch (Exception e) {}
            }
        }
    }

    public void close() {
        this.indicesService.indicesLifecycle().removeListener(this.shardLifecycleListener);
        IndexService percolatorIndexService = this.percolatorIndexService();
        if (percolatorIndexService != null) {
            for (IndexShard indexShard : percolatorIndexService) {
                try {
                    indexShard.indexingService().removeListener(this.realTimePercolatorOperationListener);
                }
                catch (Exception e) {}
            }
        }
    }

    public PercolatorExecutor.Response percolate(PercolatorExecutor.SourceRequest request) throws PercolatorException {
        return this.percolator.percolate(request);
    }

    public PercolatorExecutor.Response percolate(PercolatorExecutor.DocAndSourceQueryRequest request) throws PercolatorException {
        return this.percolator.percolate(request);
    }

    private void loadQueries(String indexName) {
        IndexService indexService = this.percolatorIndexService();
        IndexShard shard = indexService.shard(0);
        shard.refresh(new Engine.Refresh(true));
        Engine.Searcher searcher = shard.searcher();
        try {
            XConstantScoreQuery query = new XConstantScoreQuery(this.indexQueriesFilter(indexName));
            QueriesLoaderCollector queries = new QueriesLoaderCollector();
            searcher.searcher().search((Query)query, (Collector)queries);
            this.percolator.addQueries(queries.queries());
        }
        catch (IOException e) {
            throw new PercolatorException(this.index, "failed to load queries from percolator index");
        }
        finally {
            searcher.release();
        }
    }

    private Filter indexQueriesFilter(String indexName) {
        return this.percolatorIndexService().cache().filter().cache(new TermFilter(new Term("_type", indexName)));
    }

    private boolean percolatorAllocated() {
        if (!this.indicesService.hasIndex(INDEX_NAME)) {
            return false;
        }
        if (this.percolatorIndexService().numberOfShards() == 0) {
            return false;
        }
        return this.percolatorIndexService().shard(0).state() == IndexShardState.STARTED;
    }

    private IndexService percolatorIndexService() {
        return this.indicesService.indexService(INDEX_NAME);
    }

    class RealTimePercolatorOperationListener
    extends IndexingOperationListener {
        RealTimePercolatorOperationListener() {
        }

        @Override
        public Engine.Create preCreate(Engine.Create create) {
            if (create.type().equals(PercolatorService.this.index().name())) {
                PercolatorService.this.percolator.parseQuery(create.id(), create.source());
            }
            return create;
        }

        @Override
        public void postCreateUnderLock(Engine.Create create) {
            if (create.type().equals(PercolatorService.this.index().name())) {
                PercolatorService.this.percolator.addQuery(create.id(), create.source());
            }
        }

        @Override
        public Engine.Index preIndex(Engine.Index index) {
            if (index.type().equals(PercolatorService.this.index().name())) {
                PercolatorService.this.percolator.parseQuery(index.id(), index.source());
            }
            return index;
        }

        @Override
        public void postIndexUnderLock(Engine.Index index) {
            if (index.type().equals(PercolatorService.this.index().name())) {
                PercolatorService.this.percolator.addQuery(index.id(), index.source());
            }
        }

        @Override
        public void postDeleteUnderLock(Engine.Delete delete) {
            if (delete.type().equals(PercolatorService.this.index().name())) {
                PercolatorService.this.percolator.removeQuery(delete.id());
            }
        }
    }

    class ShardLifecycleListener
    extends IndicesLifecycle.Listener {
        ShardLifecycleListener() {
        }

        @Override
        public void afterIndexShardCreated(IndexShard indexShard) {
            if (indexShard.shardId().index().name().equals(PercolatorService.INDEX_NAME)) {
                indexShard.indexingService().addListener(PercolatorService.this.realTimePercolatorOperationListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void afterIndexShardStarted(IndexShard indexShard) {
            if (indexShard.shardId().index().name().equals(PercolatorService.INDEX_NAME)) {
                Object object = PercolatorService.this.mutex;
                synchronized (object) {
                    if (PercolatorService.this.initialQueriesFetchDone) {
                        return;
                    }
                    for (IndexService indexService : PercolatorService.this.indicesService) {
                        if (!indexService.index().equals(PercolatorService.this.index())) continue;
                        PercolatorService.this.logger.debug("loading percolator queries for index [{}]...", indexService.index().name());
                        PercolatorService.this.loadQueries(indexService.index().name());
                        PercolatorService.this.logger.trace("done loading percolator queries for index [{}]", indexService.index().name());
                    }
                    PercolatorService.this.initialQueriesFetchDone = true;
                }
            }
            if (!indexShard.shardId().index().equals(PercolatorService.this.index())) {
                return;
            }
            if (!PercolatorService.this.percolatorAllocated()) {
                return;
            }
            IndexService indexService = PercolatorService.this.indicesService.indexService(indexShard.shardId().index().name());
            if (indexService == null) {
                return;
            }
            if (indexService.numberOfShards() != 1) {
                return;
            }
            Object object = PercolatorService.this.mutex;
            synchronized (object) {
                if (PercolatorService.this.initialQueriesFetchDone) {
                    return;
                }
                PercolatorService.this.logger.debug("loading percolator queries for index [{}]...", indexService.index().name());
                PercolatorService.this.loadQueries(PercolatorService.this.index.name());
                PercolatorService.this.logger.trace("done loading percolator queries for index [{}]", indexService.index().name());
                PercolatorService.this.initialQueriesFetchDone = true;
            }
        }
    }

    class QueriesLoaderCollector
    extends Collector {
        private AtomicReader reader;
        private Map<String, Query> queries = Maps.newHashMap();

        QueriesLoaderCollector() {
        }

        public Map<String, Query> queries() {
            return this.queries;
        }

        public void setScorer(Scorer scorer) throws IOException {
        }

        public void collect(int doc) throws IOException {
            UidAndSourceFieldsVisitor fieldsVisitor = new UidAndSourceFieldsVisitor();
            this.reader.document(doc, (StoredFieldVisitor)fieldsVisitor);
            String id = fieldsVisitor.uid().id();
            try {
                Query parseQuery = PercolatorService.this.percolator.parseQuery(id, fieldsVisitor.source());
                if (parseQuery != null) {
                    this.queries.put(id, parseQuery);
                } else {
                    PercolatorService.this.logger.warn("failed to add query [{}] - parser returned null", id);
                }
            }
            catch (Exception e) {
                PercolatorService.this.logger.warn("failed to add query [{}]", e, id);
            }
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.reader = context.reader();
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }
}

