/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;

public class CommonTermsQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<CommonTermsQueryBuilder> {
    private final String name;
    private final Object text;
    private Operator highFreqOperator = null;
    private Operator lowFreqOperator = null;
    private String analyzer = null;
    private Float boost = null;
    private String minimumShouldMatch = null;
    private Boolean disableCoords = null;
    private Float cutoffFrequency = null;

    public CommonTermsQueryBuilder(String name, Object text) {
        if (name == null) {
            throw new ElasticSearchIllegalArgumentException("Field name must not be null");
        }
        if (text == null) {
            throw new ElasticSearchIllegalArgumentException("Query must not be null");
        }
        this.text = text;
        this.name = name;
    }

    public CommonTermsQueryBuilder highFreqOperator(Operator operator) {
        this.highFreqOperator = operator;
        return this;
    }

    public CommonTermsQueryBuilder lowFreqOperator(Operator operator) {
        this.lowFreqOperator = operator;
        return this;
    }

    public CommonTermsQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    @Override
    public CommonTermsQueryBuilder boost(float boost) {
        this.boost = Float.valueOf(boost);
        return this;
    }

    public CommonTermsQueryBuilder cutoffFrequency(float cutoffFrequency) {
        this.cutoffFrequency = Float.valueOf(cutoffFrequency);
        return this;
    }

    public CommonTermsQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("common");
        builder.startObject(this.name);
        builder.field("query", this.text);
        if (this.disableCoords != null) {
            builder.field("disable_coords", (Object)this.disableCoords);
        }
        if (this.highFreqOperator != null) {
            builder.field("high_freq_operator", this.highFreqOperator.toString());
        }
        if (this.lowFreqOperator != null) {
            builder.field("low_freq_operator", this.lowFreqOperator.toString());
        }
        if (this.analyzer != null) {
            builder.field("analyzer", this.analyzer);
        }
        if (this.boost != null) {
            builder.field("boost", this.boost);
        }
        if (this.cutoffFrequency != null) {
            builder.field("cutoff_frequency", this.cutoffFrequency);
        }
        if (this.minimumShouldMatch != null) {
            builder.field("minimum_should_match", this.minimumShouldMatch);
        }
        builder.endObject();
        builder.endObject();
    }

    public static enum Operator {
        OR,
        AND;

    }
}

