/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class CustomScoreQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<CustomScoreQueryBuilder> {
    private final QueryBuilder queryBuilder;
    private String script;
    private String lang;
    private float boost = -1.0f;
    private Map<String, Object> params = null;

    public CustomScoreQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    public CustomScoreQueryBuilder script(String script) {
        this.script = script;
        return this;
    }

    public CustomScoreQueryBuilder lang(String lang) {
        this.lang = lang;
        return this;
    }

    public CustomScoreQueryBuilder params(Map<String, Object> params) {
        if (this.params == null) {
            this.params = params;
        } else {
            this.params.putAll(params);
        }
        return this;
    }

    public CustomScoreQueryBuilder param(String key, Object value) {
        if (this.params == null) {
            this.params = Maps.newHashMap();
        }
        this.params.put(key, value);
        return this;
    }

    @Override
    public CustomScoreQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("custom_score");
        builder.field("query");
        this.queryBuilder.toXContent(builder, params);
        builder.field("script", this.script);
        if (this.lang != null) {
            builder.field("lang", this.lang);
        }
        if (this.params != null) {
            builder.field("params", this.params);
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        builder.endObject();
    }
}

