/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.sandbox.queries.FuzzyLikeThisQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class FuzzyLikeThisQueryParser
implements QueryParser {
    public static final String NAME = "flt";

    @Inject
    public FuzzyLikeThisQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "fuzzy_like_this", "fuzzyLikeThis"};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        int maxNumTerms = 25;
        float boost = 1.0f;
        ArrayList<String> fields = null;
        String likeText = null;
        float minSimilarity = 0.5f;
        int prefixLength = 0;
        boolean ignoreTF = false;
        Analyzer analyzer = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("like_text".equals(currentFieldName) || "likeText".equals(currentFieldName)) {
                    likeText = parser.text();
                    continue;
                }
                if ("max_query_terms".equals(currentFieldName) || "maxQueryTerms".equals(currentFieldName)) {
                    maxNumTerms = parser.intValue();
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    boost = parser.floatValue();
                    continue;
                }
                if ("ignore_tf".equals(currentFieldName) || "ignoreTF".equals(currentFieldName)) {
                    ignoreTF = parser.booleanValue();
                    continue;
                }
                if ("min_similarity".equals(currentFieldName) || "minSimilarity".equals(currentFieldName)) {
                    minSimilarity = parser.floatValue();
                    continue;
                }
                if ("prefix_length".equals(currentFieldName) || "prefixLength".equals(currentFieldName)) {
                    prefixLength = parser.intValue();
                    continue;
                }
                if ("analyzer".equals(currentFieldName)) {
                    analyzer = parseContext.analysisService().analyzer(parser.text());
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[flt] query does not support [" + currentFieldName + "]");
            }
            if (token != XContentParser.Token.START_ARRAY) continue;
            if ("fields".equals(currentFieldName)) {
                fields = Lists.newArrayList();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    fields.add(parseContext.indexName(parser.text()));
                }
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[flt] query does not support [" + currentFieldName + "]");
        }
        if (likeText == null) {
            throw new QueryParsingException(parseContext.index(), "fuzzy_like_this requires 'like_text' to be specified");
        }
        if (analyzer == null) {
            analyzer = parseContext.mapperService().searchAnalyzer();
        }
        FuzzyLikeThisQuery query = new FuzzyLikeThisQuery(maxNumTerms, analyzer);
        if (fields == null) {
            query.addTerms(likeText, parseContext.defaultField(), minSimilarity, prefixLength);
        } else {
            for (String field : fields) {
                query.addTerms(likeText, field, minSimilarity, prefixLength);
            }
        }
        query.setBoost(boost);
        query.setIgnoreTF(ignoreTF);
        return query;
    }
}

