/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.search.geo.InMemoryGeoBoundingBoxFilter;
import org.elasticsearch.index.search.geo.IndexedGeoBoundingBoxFilter;

public class GeoBoundingBoxFilterParser
implements FilterParser {
    public static final String NAME = "geo_bbox";

    @Inject
    public GeoBoundingBoxFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "geoBbox", "geo_bounding_box", "geoBoundingBox"};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Filter filter;
        MapperService.SmartNameFieldMappers smartMappers;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        boolean cache = false;
        CacheKeyFilter.Key cacheKey = null;
        String fieldName = null;
        GeoPoint topLeft = new GeoPoint();
        GeoPoint bottomRight = new GeoPoint();
        String filterName = null;
        String currentFieldName = null;
        boolean normalize = true;
        String type = "memory";
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    GeoPoint point;
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        point = null;
                        if ("top_left".equals(currentFieldName) || "topLeft".equals(currentFieldName)) {
                            point = topLeft;
                        } else if ("bottom_right".equals(currentFieldName) || "bottomRight".equals(currentFieldName)) {
                            point = bottomRight;
                        }
                        if (point == null) continue;
                        token = parser.nextToken();
                        point.resetLon(parser.doubleValue());
                        token = parser.nextToken();
                        point.resetLat(parser.doubleValue());
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        }
                        continue;
                    }
                    if (token == XContentParser.Token.START_OBJECT) {
                        point = null;
                        if ("top_left".equals(currentFieldName) || "topLeft".equals(currentFieldName)) {
                            point = topLeft;
                        } else if ("bottom_right".equals(currentFieldName) || "bottomRight".equals(currentFieldName)) {
                            point = bottomRight;
                        }
                        if (point == null) continue;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (!token.isValue()) continue;
                            if (currentFieldName.equals("lat")) {
                                point.resetLat(parser.doubleValue());
                                continue;
                            }
                            if (currentFieldName.equals("lon")) {
                                point.resetLon(parser.doubleValue());
                                continue;
                            }
                            if (!currentFieldName.equals("geohash")) continue;
                            GeoHashUtils.decode(parser.text(), point);
                        }
                        continue;
                    }
                    if (!token.isValue()) continue;
                    if ("field".equals(currentFieldName)) {
                        fieldName = parser.text();
                        continue;
                    }
                    point = null;
                    if ("top_left".equals(currentFieldName) || "topLeft".equals(currentFieldName)) {
                        point = topLeft;
                    } else if ("bottom_right".equals(currentFieldName) || "bottomRight".equals(currentFieldName)) {
                        point = bottomRight;
                    }
                    if (point == null) continue;
                    String value = parser.text();
                    point.resetFromString(value);
                }
                continue;
            }
            if (!token.isValue()) continue;
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                cacheKey = new CacheKeyFilter.Key(parser.text());
                continue;
            }
            if ("normalize".equals(currentFieldName)) {
                normalize = parser.booleanValue();
                continue;
            }
            if ("type".equals(currentFieldName)) {
                type = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[geo_bbox] filter does not support [" + currentFieldName + "]");
        }
        if (normalize) {
            GeoUtils.normalizePoint(topLeft);
            GeoUtils.normalizePoint(bottomRight);
        }
        if ((smartMappers = parseContext.smartFieldMappers(fieldName)) == null || !smartMappers.hasMapper()) {
            throw new QueryParsingException(parseContext.index(), "failed to find geo_point field [" + fieldName + "]");
        }
        FieldMapper mapper = smartMappers.mapper();
        if (!(mapper instanceof GeoPointFieldMapper.GeoStringFieldMapper)) {
            throw new QueryParsingException(parseContext.index(), "field [" + fieldName + "] is not a geo_point field");
        }
        GeoPointFieldMapper geoMapper = ((GeoPointFieldMapper.GeoStringFieldMapper)mapper).geoMapper();
        if ("indexed".equals(type)) {
            filter = IndexedGeoBoundingBoxFilter.create(topLeft, bottomRight, geoMapper);
        } else if ("memory".equals(type)) {
            IndexGeoPointFieldData indexFieldData = (IndexGeoPointFieldData)parseContext.fieldData().getForField(mapper);
            filter = new InMemoryGeoBoundingBoxFilter(topLeft, bottomRight, indexFieldData);
        } else {
            throw new QueryParsingException(parseContext.index(), "geo bounding box type [" + type + "] not supported, either 'indexed' or 'memory' are allowed");
        }
        if (cache) {
            filter = parseContext.cacheFilter(filter, cacheKey);
        }
        filter = QueryParsers.wrapSmartNameFilter(filter, smartMappers, parseContext);
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter);
        }
        return filter;
    }
}

