/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import org.elasticsearch.common.geo.GeoJSONShapeSerializer;
import org.elasticsearch.common.geo.SpatialStrategy;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;

public class GeoShapeQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<GeoShapeQueryBuilder> {
    private final String name;
    private SpatialStrategy strategy = null;
    private final Shape shape;
    private float boost = -1.0f;
    private final String indexedShapeId;
    private final String indexedShapeType;
    private String indexedShapeIndex;
    private String indexedShapeFieldName;

    public GeoShapeQueryBuilder(String name, Shape shape) {
        this(name, shape, null, null);
    }

    public GeoShapeQueryBuilder(String name, String indexedShapeId, String indexedShapeType) {
        this(name, null, indexedShapeId, indexedShapeType);
    }

    private GeoShapeQueryBuilder(String name, Shape shape, String indexedShapeId, String indexedShapeType) {
        this.name = name;
        this.shape = shape;
        this.indexedShapeId = indexedShapeId;
        this.indexedShapeType = indexedShapeType;
    }

    @Override
    public GeoShapeQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public GeoShapeQueryBuilder strategy(SpatialStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public GeoShapeQueryBuilder indexedShapeIndex(String indexedShapeIndex) {
        this.indexedShapeIndex = indexedShapeIndex;
        return this;
    }

    public GeoShapeQueryBuilder indexedShapeFieldName(String indexedShapeFieldName) {
        this.indexedShapeFieldName = indexedShapeFieldName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("geo_shape");
        builder.startObject(this.name);
        if (this.strategy != null) {
            builder.field("strategy", this.strategy.getStrategyName());
        }
        if (this.shape != null) {
            builder.startObject("shape");
            GeoJSONShapeSerializer.serialize(this.shape, builder);
            builder.endObject();
        } else {
            builder.startObject("indexed_shape").field("id", this.indexedShapeId).field("type", this.indexedShapeType);
            if (this.indexedShapeIndex != null) {
                builder.field("index", this.indexedShapeIndex);
            }
            if (this.indexedShapeFieldName != null) {
                builder.field("shape_field_name", this.indexedShapeFieldName);
            }
            builder.endObject();
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        builder.endObject();
    }
}

