/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.search.AndFilter;
import org.elasticsearch.common.lucene.search.OrFilter;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.lucene.search.TermFilter;
import org.elasticsearch.common.lucene.search.XBooleanFilter;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.indices.cache.filter.terms.IndicesTermsFilterCache;
import org.elasticsearch.indices.cache.filter.terms.TermsLookup;

public class TermsFilterParser
implements FilterParser {
    public static final String NAME = "terms";
    private IndicesTermsFilterCache termsFilterCache;

    @Inject
    public TermsFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "in"};
    }

    @Inject(optional=true)
    public void setIndicesTermsFilterCache(IndicesTermsFilterCache termsFilterCache) {
        this.termsFilterCache = termsFilterCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Filter filter;
        block77: {
            XContentParser.Token token;
            XContentParser parser = parseContext.parser();
            Boolean cache = null;
            String filterName = null;
            String currentFieldName = null;
            String lookupIndex = parseContext.index().name();
            String lookupType = null;
            String lookupId = null;
            String lookupPath = null;
            CacheKeyFilter.Key cacheKey = null;
            String execution = "plain";
            ArrayList<Object> terms = Lists.newArrayList();
            String fieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    fieldName = currentFieldName;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        Object value = parser.objectBytes();
                        if (value == null) {
                            throw new QueryParsingException(parseContext.index(), "No value specified for term filter");
                        }
                        terms.add(value);
                    }
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    fieldName = currentFieldName;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (!token.isValue()) continue;
                        if ("index".equals(currentFieldName)) {
                            lookupIndex = parser.text();
                            continue;
                        }
                        if ("type".equals(currentFieldName)) {
                            lookupType = parser.text();
                            continue;
                        }
                        if ("id".equals(currentFieldName)) {
                            lookupId = parser.text();
                            continue;
                        }
                        if ("path".equals(currentFieldName)) {
                            lookupPath = parser.text();
                            continue;
                        }
                        throw new QueryParsingException(parseContext.index(), "[terms] filter does not support [" + currentFieldName + "] within lookup element");
                    }
                    if (lookupType == null) {
                        throw new QueryParsingException(parseContext.index(), "[terms] filter lookup element requires specifying the type");
                    }
                    if (lookupId == null) {
                        throw new QueryParsingException(parseContext.index(), "[terms] filter lookup element requires specifying the id");
                    }
                    if (lookupPath != null) continue;
                    throw new QueryParsingException(parseContext.index(), "[terms] filter lookup element requires specifying the path");
                }
                if (!token.isValue()) continue;
                if ("execution".equals(currentFieldName)) {
                    execution = parser.text();
                    continue;
                }
                if ("_name".equals(currentFieldName)) {
                    filterName = parser.text();
                    continue;
                }
                if ("_cache".equals(currentFieldName)) {
                    cache = parser.booleanValue();
                    continue;
                }
                if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                    cacheKey = new CacheKeyFilter.Key(parser.text());
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[terms] filter does not support [" + currentFieldName + "]");
            }
            if (fieldName == null) {
                throw new QueryParsingException(parseContext.index(), "terms filter requires a field name, followed by array of terms");
            }
            FieldMapper fieldMapper = null;
            MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
            String[] previousTypes = null;
            if (smartNameFieldMappers != null) {
                if (smartNameFieldMappers.hasMapper()) {
                    fieldMapper = smartNameFieldMappers.mapper();
                    fieldName = fieldMapper.names().indexName();
                }
                if (smartNameFieldMappers.explicitTypeInNameWithDocMapper()) {
                    previousTypes = QueryParseContext.setTypesWithPrevious(new String[]{smartNameFieldMappers.docMapper().type()});
                }
            }
            if (lookupId != null) {
                TermsLookup termsLookup = new TermsLookup(fieldMapper, lookupIndex, lookupType, lookupId, lookupPath, parseContext);
                if (cacheKey == null) {
                    cacheKey = new CacheKeyFilter.Key(termsLookup.toString());
                }
                Filter filter2 = this.termsFilterCache.lookupTermsFilter(cacheKey, termsLookup);
                filter2 = parseContext.cacheFilter(filter2, null);
                return filter2;
            }
            if (terms.isEmpty()) {
                return Queries.MATCH_NO_FILTER;
            }
            try {
                ArrayList<Filter> filters;
                XBooleanFilter boolFiler;
                Filter filter2;
                if ("plain".equals(execution)) {
                    if (fieldMapper != null) {
                        Filter filter3 = fieldMapper.termsFilter(terms, parseContext);
                    } else {
                        BytesRef[] filterValues = new BytesRef[terms.size()];
                        for (int i = 0; i < filterValues.length; ++i) {
                            filterValues[i] = BytesRefs.toBytesRef(terms.get(i));
                        }
                        filter2 = new TermsFilter(fieldName, filterValues);
                    }
                    if (cache == null || cache.booleanValue()) {
                        filter2 = parseContext.cacheFilter(filter2, cacheKey);
                    }
                } else if ("bool".equals(execution)) {
                    boolFiler = new XBooleanFilter();
                    if (fieldMapper != null) {
                        for (Object e : terms) {
                            boolFiler.add(parseContext.cacheFilter(fieldMapper.termFilter(e, parseContext), null), BooleanClause.Occur.SHOULD);
                        }
                    } else {
                        for (Object e : terms) {
                            boolFiler.add(parseContext.cacheFilter(new TermFilter(new Term(fieldName, BytesRefs.toBytesRef(e))), null), BooleanClause.Occur.SHOULD);
                        }
                    }
                    filter2 = boolFiler;
                    if (cache != null && cache.booleanValue()) {
                        filter2 = parseContext.cacheFilter(filter2, cacheKey);
                    }
                } else if ("bool_nocache".equals(execution)) {
                    boolFiler = new XBooleanFilter();
                    if (fieldMapper != null) {
                        for (Object e : terms) {
                            boolFiler.add(fieldMapper.termFilter(e, parseContext), BooleanClause.Occur.SHOULD);
                        }
                    } else {
                        for (Object e : terms) {
                            boolFiler.add(new TermFilter(new Term(fieldName, BytesRefs.toBytesRef(e))), BooleanClause.Occur.SHOULD);
                        }
                    }
                    filter2 = boolFiler;
                    if (cache == null || cache.booleanValue()) {
                        filter2 = parseContext.cacheFilter(filter2, cacheKey);
                    }
                } else if ("and".equals(execution)) {
                    filters = Lists.newArrayList();
                    if (fieldMapper != null) {
                        for (Object e : terms) {
                            filters.add(parseContext.cacheFilter(fieldMapper.termFilter(e, parseContext), null));
                        }
                    } else {
                        for (Object e : terms) {
                            filters.add(parseContext.cacheFilter(new TermFilter(new Term(fieldName, BytesRefs.toBytesRef(e))), null));
                        }
                    }
                    filter2 = new AndFilter(filters);
                    if (cache != null && cache.booleanValue()) {
                        filter2 = parseContext.cacheFilter(filter2, cacheKey);
                    }
                } else if ("and_nocache".equals(execution)) {
                    filters = Lists.newArrayList();
                    if (fieldMapper != null) {
                        for (Object e : terms) {
                            filters.add(fieldMapper.termFilter(e, parseContext));
                        }
                    } else {
                        for (Object e : terms) {
                            filters.add(new TermFilter(new Term(fieldName, BytesRefs.toBytesRef(e))));
                        }
                    }
                    filter2 = new AndFilter(filters);
                    if (cache == null || cache.booleanValue()) {
                        filter2 = parseContext.cacheFilter(filter2, cacheKey);
                    }
                } else if ("or".equals(execution)) {
                    filters = Lists.newArrayList();
                    if (fieldMapper != null) {
                        for (Object e : terms) {
                            filters.add(parseContext.cacheFilter(fieldMapper.termFilter(e, parseContext), null));
                        }
                    } else {
                        for (Object e : terms) {
                            filters.add(parseContext.cacheFilter(new TermFilter(new Term(fieldName, BytesRefs.toBytesRef(e))), null));
                        }
                    }
                    filter2 = new OrFilter(filters);
                    if (cache != null && cache.booleanValue()) {
                        filter2 = parseContext.cacheFilter(filter2, cacheKey);
                    }
                } else if ("or_nocache".equals(execution)) {
                    filters = Lists.newArrayList();
                    if (fieldMapper != null) {
                        for (Object e : terms) {
                            filters.add(fieldMapper.termFilter(e, parseContext));
                        }
                    } else {
                        for (Object e : terms) {
                            filters.add(new TermFilter(new Term(fieldName, BytesRefs.toBytesRef(e))));
                        }
                    }
                    filter2 = new OrFilter(filters);
                    if (cache == null || cache.booleanValue()) {
                        filter2 = parseContext.cacheFilter(filter2, cacheKey);
                    }
                } else {
                    throw new QueryParsingException(parseContext.index(), "bool filter execution value [" + execution + "] not supported");
                }
                filter2 = QueryParsers.wrapSmartNameFilter(filter2, smartNameFieldMappers, parseContext);
                if (filterName != null) {
                    parseContext.addNamedFilter(filterName, filter2);
                }
                filter = filter2;
                if (smartNameFieldMappers == null || !smartNameFieldMappers.explicitTypeInNameWithDocMapper()) break block77;
            }
            catch (Throwable throwable) {
                if (smartNameFieldMappers != null && smartNameFieldMappers.explicitTypeInNameWithDocMapper()) {
                    QueryParseContext.setTypes(previousTypes);
                }
                throw throwable;
            }
            QueryParseContext.setTypes(previousTypes);
        }
        return filter;
    }
}

