/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.search.MatchQuery;

public class MultiMatchQuery
extends MatchQuery {
    private boolean useDisMax = true;
    private float tieBreaker;

    public void setUseDisMax(boolean useDisMax) {
        this.useDisMax = useDisMax;
    }

    public void setTieBreaker(float tieBreaker) {
        this.tieBreaker = tieBreaker;
    }

    public MultiMatchQuery(QueryParseContext parseContext) {
        super(parseContext);
    }

    private Query parseAndApply(MatchQuery.Type type, String fieldName, Object value, String minimumShouldMatch) throws IOException {
        Query query = this.parse(type, fieldName, value);
        if (query instanceof BooleanQuery) {
            Queries.applyMinimumShouldMatch((BooleanQuery)query, minimumShouldMatch);
        }
        return query;
    }

    public Query parse(MatchQuery.Type type, Map<String, Float> fieldNames, Object value, String minimumShouldMatch) throws IOException {
        if (fieldNames.size() == 1) {
            Map.Entry<String, Float> fieldBoost = fieldNames.entrySet().iterator().next();
            Float boostValue = fieldBoost.getValue();
            Query query = this.parseAndApply(type, fieldBoost.getKey(), value, minimumShouldMatch);
            if (boostValue != null) {
                query.setBoost(boostValue.floatValue());
            }
            return query;
        }
        if (this.useDisMax) {
            DisjunctionMaxQuery disMaxQuery = new DisjunctionMaxQuery(this.tieBreaker);
            boolean clauseAdded = false;
            for (String fieldName : fieldNames.keySet()) {
                Query query = this.parseAndApply(type, fieldName, value, minimumShouldMatch);
                Float boostValue = fieldNames.get(fieldName);
                if (boostValue != null) {
                    query.setBoost(boostValue.floatValue());
                }
                if (query == null) continue;
                clauseAdded = true;
                disMaxQuery.add(query);
            }
            return clauseAdded ? disMaxQuery : null;
        }
        BooleanQuery booleanQuery = new BooleanQuery();
        for (String fieldName : fieldNames.keySet()) {
            Query query = this.parseAndApply(type, fieldName, value, minimumShouldMatch);
            Float boostValue = fieldNames.get(fieldName);
            if (boostValue != null) {
                query.setBoost(boostValue.floatValue());
            }
            if (query == null) continue;
            booleanQuery.add(query, BooleanClause.Occur.SHOULD);
        }
        return !booleanQuery.clauses().isEmpty() ? booleanQuery : null;
    }
}

