/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Bits;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.docset.MatchDocIdSet;
import org.elasticsearch.common.lucene.search.NoopCollector;
import org.elasticsearch.common.trove.set.hash.THashSet;
import org.elasticsearch.index.cache.id.IdReaderTypeCache;
import org.elasticsearch.search.internal.SearchContext;

public class HasParentFilter
extends Filter
implements SearchContext.Rewrite {
    final Query parentQuery;
    final String parentType;
    final SearchContext context;
    final Filter childrenFilter;
    THashSet<HashedBytesArray> parents;

    public HasParentFilter(Query parentQuery, String parentType, SearchContext context, Filter childrenFilter) {
        this.parentQuery = parentQuery;
        this.parentType = parentType;
        this.context = context;
        this.childrenFilter = childrenFilter;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        HasParentFilter that = (HasParentFilter)obj;
        if (!this.parentQuery.equals((Object)that.parentQuery)) {
            return false;
        }
        return this.parentType.equals(that.parentType);
    }

    public DocIdSet getDocIdSet(AtomicReaderContext readerContext, Bits acceptDocs) throws IOException {
        if (this.parents == null) {
            throw new ElasticSearchIllegalStateException("has_parent filter hasn't executed properly");
        }
        DocIdSet childrenDocIdSet = this.childrenFilter.getDocIdSet(readerContext, null);
        if (DocIdSets.isEmpty(childrenDocIdSet)) {
            return null;
        }
        Bits childrenBits = DocIdSets.toSafeBits(readerContext.reader(), childrenDocIdSet);
        IdReaderTypeCache idReaderTypeCache = this.context.idCache().reader(readerContext.reader()).type(this.parentType);
        if (idReaderTypeCache != null) {
            return new ChildrenDocSet((IndexReader)readerContext.reader(), childrenBits, this.parents, idReaderTypeCache);
        }
        return null;
    }

    @Override
    public void contextRewrite(SearchContext searchContext) throws Exception {
        searchContext.idCache().refresh(searchContext.searcher().getTopReaderContext().leaves());
        this.parents = CacheRecycler.popHashSet();
        ParentUidsCollector collector = new ParentUidsCollector(this.parents, this.context, this.parentType);
        searchContext.searcher().search(this.parentQuery, collector);
        this.parents = collector.collectedUids;
    }

    @Override
    public void contextClear() {
        if (this.parents != null) {
            CacheRecycler.pushHashSet(this.parents);
        }
        this.parents = null;
    }

    public int hashCode() {
        int result = this.parentQuery.hashCode();
        result = 31 * result + this.parentType.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("parent_filter[").append(this.parentType).append("](").append(this.parentQuery).append(')');
        return sb.toString();
    }

    static final class ParentUidsCollector
    extends NoopCollector {
        final THashSet<HashedBytesArray> collectedUids;
        final SearchContext context;
        final String parentType;
        IdReaderTypeCache typeCache;

        ParentUidsCollector(THashSet<HashedBytesArray> collectedUids, SearchContext context, String parentType) {
            this.collectedUids = collectedUids;
            this.context = context;
            this.parentType = parentType;
        }

        @Override
        public void collect(int doc) throws IOException {
            if (this.typeCache != null) {
                this.collectedUids.add(this.typeCache.idByDoc(doc));
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext readerContext) throws IOException {
            this.typeCache = this.context.idCache().reader(readerContext.reader()).type(this.parentType);
        }
    }

    static final class ChildrenDocSet
    extends MatchDocIdSet {
        final IndexReader reader;
        final THashSet<HashedBytesArray> parents;
        final IdReaderTypeCache idReaderTypeCache;

        ChildrenDocSet(IndexReader reader, Bits acceptDocs, THashSet<HashedBytesArray> parents, IdReaderTypeCache idReaderTypeCache) {
            super(reader.maxDoc(), acceptDocs);
            this.reader = reader;
            this.parents = parents;
            this.idReaderTypeCache = idReaderTypeCache;
        }

        @Override
        protected boolean matchDoc(int doc) {
            return this.parents.contains(this.idReaderTypeCache.parentIdByDoc(doc));
        }
    }
}

