/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.lucene.search.NoopCollector;
import org.elasticsearch.common.trove.map.hash.TObjectFloatHashMap;
import org.elasticsearch.index.cache.id.IdReaderTypeCache;
import org.elasticsearch.index.search.child.HasParentFilter;
import org.elasticsearch.search.internal.SearchContext;

public class ParentQuery
extends Query
implements SearchContext.Rewrite {
    private final SearchContext searchContext;
    private final Query originalParentQuery;
    private final String parentType;
    private final Filter childrenFilter;
    private Query rewrittenParentQuery;
    private TObjectFloatHashMap<HashedBytesArray> uidToScore;

    public ParentQuery(SearchContext searchContext, Query parentQuery, String parentType, Filter childrenFilter) {
        this.searchContext = searchContext;
        this.originalParentQuery = parentQuery;
        this.parentType = parentType;
        this.childrenFilter = childrenFilter;
    }

    private ParentQuery(ParentQuery unwritten, Query rewrittenParentQuery) {
        this.searchContext = unwritten.searchContext;
        this.originalParentQuery = unwritten.originalParentQuery;
        this.parentType = unwritten.parentType;
        this.childrenFilter = unwritten.childrenFilter;
        this.rewrittenParentQuery = rewrittenParentQuery;
        this.uidToScore = unwritten.uidToScore;
    }

    @Override
    public void contextRewrite(SearchContext searchContext) throws Exception {
        searchContext.idCache().refresh(searchContext.searcher().getTopReaderContext().leaves());
        this.uidToScore = CacheRecycler.popObjectFloatMap();
        ParentUidCollector collector = new ParentUidCollector(this.uidToScore, searchContext, this.parentType);
        Query parentQuery = this.rewrittenParentQuery == null ? (this.rewrittenParentQuery = searchContext.searcher().rewrite(this.originalParentQuery)) : this.rewrittenParentQuery;
        searchContext.searcher().search(parentQuery, collector);
    }

    @Override
    public void contextClear() {
        if (this.uidToScore != null) {
            CacheRecycler.pushObjectFloatMap(this.uidToScore);
        }
        this.uidToScore = null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        HasParentFilter that = (HasParentFilter)obj;
        if (!this.originalParentQuery.equals((Object)that.parentQuery)) {
            return false;
        }
        return this.parentType.equals(that.parentType);
    }

    public int hashCode() {
        int result = this.originalParentQuery.hashCode();
        result = 31 * result + this.parentType.hashCode();
        return result;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("ParentQuery[").append(this.parentType).append("](").append(this.originalParentQuery.toString(field)).append(')').append(ToStringUtils.boost((float)this.getBoost()));
        return sb.toString();
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.rewrittenParentQuery == null ? this.originalParentQuery.rewrite(reader) : this.rewrittenParentQuery;
        if (rewritten == this.rewrittenParentQuery) {
            return this;
        }
        ParentQuery rewrite = new ParentQuery(this, rewritten);
        int index = this.searchContext.rewrites().indexOf(this);
        this.searchContext.rewrites().set(index, rewrite);
        return rewrite;
    }

    public void extractTerms(Set<Term> terms) {
        this.rewrittenParentQuery.extractTerms(terms);
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        if (this.uidToScore == null) {
            throw new ElasticSearchIllegalStateException("has_parent query hasn't executed properly");
        }
        return new ChildWeight(this.rewrittenParentQuery.createWeight(searcher));
    }

    static class ChildScorer
    extends Scorer {
        final TObjectFloatHashMap<HashedBytesArray> uidToScore;
        final DocIdSetIterator childrenIterator;
        final IdReaderTypeCache typeCache;
        int currentChildDoc = -1;
        float currentScore;

        ChildScorer(Weight weight, TObjectFloatHashMap<HashedBytesArray> uidToScore, DocIdSetIterator childrenIterator, IdReaderTypeCache typeCache) {
            super(weight);
            this.uidToScore = uidToScore;
            this.childrenIterator = childrenIterator;
            this.typeCache = typeCache;
        }

        public float score() throws IOException {
            return this.currentScore;
        }

        public int freq() throws IOException {
            return 1;
        }

        public int docID() {
            return this.currentChildDoc;
        }

        public int nextDoc() throws IOException {
            while (true) {
                this.currentChildDoc = this.childrenIterator.nextDoc();
                if (this.currentChildDoc == Integer.MAX_VALUE) {
                    return this.currentChildDoc;
                }
                HashedBytesArray uid = this.typeCache.parentIdByDoc(this.currentChildDoc);
                if (uid == null) continue;
                this.currentScore = this.uidToScore.get(uid);
                if (this.currentScore != 0.0f) break;
            }
            return this.currentChildDoc;
        }

        public int advance(int target) throws IOException {
            this.currentChildDoc = this.childrenIterator.advance(target);
            if (this.currentChildDoc == Integer.MAX_VALUE) {
                return this.currentChildDoc;
            }
            HashedBytesArray uid = this.typeCache.idByDoc(this.currentChildDoc);
            if (uid == null) {
                return this.nextDoc();
            }
            this.currentScore = this.uidToScore.get(uid);
            if (this.currentScore == 0.0f) {
                return this.nextDoc();
            }
            return this.currentChildDoc;
        }

        public long cost() {
            return this.childrenIterator.cost();
        }
    }

    class ChildWeight
    extends Weight {
        private final Weight parentWeight;

        ChildWeight(Weight parentWeight) {
            this.parentWeight = parentWeight;
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            return new Explanation(ParentQuery.this.getBoost(), "not implemented yet...");
        }

        public Query getQuery() {
            return ParentQuery.this;
        }

        public float getValueForNormalization() throws IOException {
            float sum = this.parentWeight.getValueForNormalization();
            return sum *= ParentQuery.this.getBoost() * ParentQuery.this.getBoost();
        }

        public void normalize(float norm, float topLevelBoost) {
        }

        public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            DocIdSet childrenDocSet = ParentQuery.this.childrenFilter.getDocIdSet(context, acceptDocs);
            if (childrenDocSet == null || childrenDocSet == DocIdSet.EMPTY_DOCIDSET) {
                return null;
            }
            IdReaderTypeCache idTypeCache = ParentQuery.this.searchContext.idCache().reader(context.reader()).type(ParentQuery.this.parentType);
            if (idTypeCache == null) {
                return null;
            }
            return new ChildScorer(this, ParentQuery.this.uidToScore, childrenDocSet.iterator(), idTypeCache);
        }
    }

    static class ParentUidCollector
    extends NoopCollector {
        final TObjectFloatHashMap<HashedBytesArray> uidToScore;
        final SearchContext searchContext;
        final String parentType;
        Scorer scorer;
        IdReaderTypeCache typeCache;

        ParentUidCollector(TObjectFloatHashMap<HashedBytesArray> uidToScore, SearchContext searchContext, String parentType) {
            this.uidToScore = uidToScore;
            this.searchContext = searchContext;
            this.parentType = parentType;
        }

        @Override
        public void collect(int doc) throws IOException {
            if (this.typeCache == null) {
                return;
            }
            HashedBytesArray parentUid = this.typeCache.idByDoc(doc);
            this.uidToScore.put(parentUid, this.scorer.score());
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.typeCache = this.searchContext.idCache().reader(context.reader()).type(this.parentType);
        }
    }
}

