/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.lucene.search.EmptyScorer;
import org.elasticsearch.common.trove.ExtTHashMap;
import org.elasticsearch.common.trove.map.hash.TIntObjectHashMap;
import org.elasticsearch.index.search.child.HasChildFilter;
import org.elasticsearch.index.search.child.ScoreType;
import org.elasticsearch.search.internal.SearchContext;

public class TopChildrenQuery
extends Query
implements SearchContext.Rewrite {
    private final SearchContext searchContext;
    private final String parentType;
    private final String childType;
    private final ScoreType scoreType;
    private final int factor;
    private final int incrementalFactor;
    private final Query originalChildQuery;
    private Query rewrittenChildQuery;
    private ExtTHashMap<Object, ParentDoc[]> parentDocs;
    private static final ParentDocComparator PARENT_DOC_COMP = new ParentDocComparator();

    public TopChildrenQuery(SearchContext searchContext, Query childQuery, String childType, String parentType, ScoreType scoreType, int factor, int incrementalFactor) {
        this.searchContext = searchContext;
        this.originalChildQuery = childQuery;
        this.childType = childType;
        this.parentType = parentType;
        this.scoreType = scoreType;
        this.factor = factor;
        this.incrementalFactor = incrementalFactor;
    }

    private TopChildrenQuery(TopChildrenQuery existing, Query rewrittenChildQuery) {
        this.searchContext = existing.searchContext;
        this.originalChildQuery = existing.originalChildQuery;
        this.parentType = existing.parentType;
        this.childType = existing.childType;
        this.scoreType = existing.scoreType;
        this.factor = existing.factor;
        this.incrementalFactor = existing.incrementalFactor;
        this.parentDocs = existing.parentDocs;
        this.rewrittenChildQuery = rewrittenChildQuery;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.rewrittenChildQuery == null ? this.originalChildQuery.rewrite(reader) : this.rewrittenChildQuery;
        if (rewritten == this.rewrittenChildQuery) {
            return this;
        }
        int index = this.searchContext.rewrites().indexOf(this);
        TopChildrenQuery rewrite = new TopChildrenQuery(this, rewritten);
        this.searchContext.rewrites().set(index, rewrite);
        return rewrite;
    }

    @Override
    public void contextRewrite(SearchContext searchContext) throws Exception {
        this.parentDocs = CacheRecycler.popHashMap();
        searchContext.idCache().refresh(searchContext.searcher().getTopReaderContext().leaves());
        int numChildDocs = searchContext.from() + searchContext.size();
        if (numChildDocs == 0) {
            numChildDocs = 1;
        }
        numChildDocs *= this.factor;
        Query childQuery = this.rewrittenChildQuery == null ? (this.rewrittenChildQuery = searchContext.searcher().rewrite(this.originalChildQuery)) : this.rewrittenChildQuery;
        while (true) {
            this.parentDocs.clear();
            TopDocs topChildDocs = searchContext.searcher().search(childQuery, numChildDocs);
            int parentHitsResolved = this.resolveParentDocuments(topChildDocs, searchContext);
            if (parentHitsResolved >= searchContext.from() + searchContext.size() || topChildDocs.totalHits <= numChildDocs) break;
            if ((numChildDocs *= this.incrementalFactor) <= topChildDocs.totalHits) continue;
            numChildDocs = topChildDocs.totalHits;
        }
    }

    @Override
    public void contextClear() {
        if (this.parentDocs != null) {
            CacheRecycler.pushHashMap(this.parentDocs);
            this.parentDocs = null;
        }
    }

    int resolveParentDocuments(TopDocs topDocs, SearchContext context) {
        int parentHitsResolved = 0;
        ExtTHashMap parentDocsPerReader = CacheRecycler.popHashMap();
        for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
            int readerIndex = ReaderUtil.subIndex((int)scoreDoc.doc, (List)context.searcher().getIndexReader().leaves());
            AtomicReaderContext subContext = (AtomicReaderContext)context.searcher().getIndexReader().leaves().get(readerIndex);
            int subDoc = scoreDoc.doc - subContext.docBase;
            HashedBytesArray parentId = context.idCache().reader(subContext.reader()).parentIdByDoc(this.parentType, subDoc);
            if (parentId == null) continue;
            for (AtomicReaderContext atomicReaderContext : context.searcher().getIndexReader().leaves()) {
                ParentDoc parentDoc;
                AtomicReader indexReader = atomicReaderContext.reader();
                int parentDocId = context.idCache().reader(indexReader).docById(this.parentType, parentId);
                Bits liveDocs = indexReader.getLiveDocs();
                if (parentDocId == -1 || liveDocs != null && !liveDocs.get(parentDocId)) continue;
                TIntObjectHashMap readerParentDocs = (TIntObjectHashMap)parentDocsPerReader.get(indexReader.getCoreCacheKey());
                if (readerParentDocs == null) {
                    readerParentDocs = CacheRecycler.popIntObjectMap();
                    parentDocsPerReader.put(indexReader.getCoreCacheKey(), readerParentDocs);
                }
                if ((parentDoc = (ParentDoc)readerParentDocs.get(parentDocId)) == null) {
                    ++parentHitsResolved;
                    parentDoc = new ParentDoc();
                    parentDoc.docId = parentDocId;
                    parentDoc.count = 1;
                    parentDoc.maxScore = scoreDoc.score;
                    parentDoc.sumScores = scoreDoc.score;
                    readerParentDocs.put(parentDocId, parentDoc);
                    continue;
                }
                ++parentDoc.count;
                parentDoc.sumScores += scoreDoc.score;
                if (!(scoreDoc.score > parentDoc.maxScore)) continue;
                parentDoc.maxScore = scoreDoc.score;
            }
        }
        for (Map.Entry entry : parentDocsPerReader.entrySet()) {
            ParentDoc[] values = ((TIntObjectHashMap)entry.getValue()).values(new ParentDoc[((TIntObjectHashMap)entry.getValue()).size()]);
            Arrays.sort(values, PARENT_DOC_COMP);
            this.parentDocs.put(entry.getKey(), values);
            CacheRecycler.pushIntObjectMap((TIntObjectHashMap)entry.getValue());
        }
        CacheRecycler.pushHashMap(parentDocsPerReader);
        return parentHitsResolved;
    }

    public void extractTerms(Set<Term> terms) {
        this.rewrittenChildQuery.extractTerms(terms);
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        if (this.parentDocs == null) {
            throw new ElasticSearchIllegalStateException("top_children query hasn't executed properly");
        }
        return new ParentWeight(searcher, this.rewrittenChildQuery.createWeight(searcher));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        HasChildFilter that = (HasChildFilter)obj;
        if (!this.originalChildQuery.equals((Object)that.childQuery)) {
            return false;
        }
        if (!this.childType.equals(that.childType)) {
            return false;
        }
        return this.parentType.equals(that.parentType);
    }

    public int hashCode() {
        int result = this.originalChildQuery.hashCode();
        result = 31 * result + this.parentType.hashCode();
        result = 31 * result + this.childType.hashCode();
        return result;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("score_child[").append(this.childType).append("/").append(this.parentType).append("](").append(this.originalChildQuery.toString(field)).append(')');
        sb.append(ToStringUtils.boost((float)this.getBoost()));
        return sb.toString();
    }

    static abstract class ParentScorer
    extends Scorer {
        private final ParentDoc spare;
        protected final ParentDoc[] docs;
        protected ParentDoc doc;
        private int index;

        ParentScorer(ParentWeight weight, ParentDoc[] docs) throws IOException {
            super((Weight)weight);
            this.doc = this.spare = new ParentDoc();
            this.index = -1;
            this.docs = docs;
            this.spare.docId = -1;
            this.spare.count = -1;
        }

        public final int docID() {
            return this.doc.docId;
        }

        public final int advance(int target) throws IOException {
            int doc;
            while ((doc = this.nextDoc()) < target) {
            }
            return doc;
        }

        public final int nextDoc() throws IOException {
            if (++this.index >= this.docs.length) {
                this.doc = this.spare;
                this.doc.count = 0;
                this.doc.docId = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = this.docs[this.index];
            return this.doc.docId;
        }

        public final int freq() throws IOException {
            return this.doc.count;
        }

        public final long cost() {
            return this.docs.length;
        }
    }

    class ParentWeight
    extends Weight {
        final IndexSearcher searcher;
        final Weight queryWeight;

        public ParentWeight(IndexSearcher searcher, Weight queryWeight) throws IOException {
            this.searcher = searcher;
            this.queryWeight = queryWeight;
        }

        public Query getQuery() {
            return TopChildrenQuery.this;
        }

        public float getValueForNormalization() throws IOException {
            float sum = this.queryWeight.getValueForNormalization();
            return sum *= TopChildrenQuery.this.getBoost() * TopChildrenQuery.this.getBoost();
        }

        public void normalize(float norm, float topLevelBoost) {
        }

        public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            ParentDoc[] readerParentDocs = (ParentDoc[])TopChildrenQuery.this.parentDocs.get(context.reader().getCoreCacheKey());
            if (readerParentDocs != null) {
                if (TopChildrenQuery.this.scoreType == ScoreType.MAX) {
                    return new ParentScorer(this, readerParentDocs){

                        public float score() throws IOException {
                            assert (this.doc.docId >= 0 || this.doc.docId < Integer.MAX_VALUE);
                            return this.doc.maxScore;
                        }
                    };
                }
                if (TopChildrenQuery.this.scoreType == ScoreType.AVG) {
                    return new ParentScorer(this, readerParentDocs){

                        public float score() throws IOException {
                            assert (this.doc.docId >= 0 || this.doc.docId < Integer.MAX_VALUE);
                            return this.doc.sumScores / (float)this.doc.count;
                        }
                    };
                }
                if (TopChildrenQuery.this.scoreType == ScoreType.SUM) {
                    return new ParentScorer(this, readerParentDocs){

                        public float score() throws IOException {
                            assert (this.doc.docId >= 0 || this.doc.docId < Integer.MAX_VALUE);
                            return this.doc.sumScores;
                        }
                    };
                }
                throw new ElasticSearchIllegalStateException("No support for score type [" + (Object)((Object)TopChildrenQuery.this.scoreType) + "]");
            }
            return new EmptyScorer(this);
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            return new Explanation(TopChildrenQuery.this.getBoost(), "not implemented yet...");
        }
    }

    static class ParentDoc {
        public int docId;
        public int count;
        public float maxScore = Float.NaN;
        public float sumScores = 0.0f;

        ParentDoc() {
        }
    }

    static class ParentDocComparator
    implements Comparator<ParentDoc> {
        ParentDocComparator() {
        }

        @Override
        public int compare(ParentDoc o1, ParentDoc o2) {
            return o1.docId - o2.docId;
        }
    }
}

