/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.lucene.docset.MatchDocIdSet;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;

public class InMemoryGeoBoundingBoxFilter
extends Filter {
    private final GeoPoint topLeft;
    private final GeoPoint bottomRight;
    private final IndexGeoPointFieldData indexFieldData;

    public InMemoryGeoBoundingBoxFilter(GeoPoint topLeft, GeoPoint bottomRight, IndexGeoPointFieldData indexFieldData) {
        this.topLeft = topLeft;
        this.bottomRight = bottomRight;
        this.indexFieldData = indexFieldData;
    }

    public GeoPoint topLeft() {
        return this.topLeft;
    }

    public GeoPoint bottomRight() {
        return this.bottomRight;
    }

    public String fieldName() {
        return this.indexFieldData.getFieldNames().indexName();
    }

    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptedDocs) throws IOException {
        GeoPointValues values = ((AtomicGeoPointFieldData)this.indexFieldData.load(context)).getGeoPointValues();
        if (this.topLeft.lon() > this.bottomRight.lon()) {
            return new Meridian180GeoBoundingBoxDocSet(context.reader().maxDoc(), acceptedDocs, values, this.topLeft, this.bottomRight);
        }
        return new GeoBoundingBoxDocSet(context.reader().maxDoc(), acceptedDocs, values, this.topLeft, this.bottomRight);
    }

    public String toString() {
        return "GeoBoundingBoxFilter(" + this.indexFieldData.getFieldNames().indexName() + ", " + this.topLeft + ", " + this.bottomRight + ")";
    }

    public static class GeoBoundingBoxDocSet
    extends MatchDocIdSet {
        private final GeoPointValues values;
        private final GeoPoint topLeft;
        private final GeoPoint bottomRight;

        public GeoBoundingBoxDocSet(int maxDoc, @Nullable Bits acceptDocs, GeoPointValues values, GeoPoint topLeft, GeoPoint bottomRight) {
            super(maxDoc, acceptDocs);
            this.values = values;
            this.topLeft = topLeft;
            this.bottomRight = bottomRight;
        }

        public boolean isCacheable() {
            return true;
        }

        @Override
        protected boolean matchDoc(int doc) {
            if (!this.values.hasValue(doc)) {
                return false;
            }
            if (this.values.isMultiValued()) {
                GeoPointValues.Iter iter = this.values.getIter(doc);
                while (iter.hasNext()) {
                    GeoPoint point = iter.next();
                    if (!(this.topLeft.lon() <= point.lon()) || !(this.bottomRight.lon() >= point.lon()) || !(this.topLeft.lat() >= point.lat()) || !(this.bottomRight.lat() <= point.lat())) continue;
                    return true;
                }
            } else {
                GeoPoint point = this.values.getValue(doc);
                if (this.topLeft.lon() <= point.lon() && this.bottomRight.lon() >= point.lon() && this.topLeft.lat() >= point.lat() && this.bottomRight.lat() <= point.lat()) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class Meridian180GeoBoundingBoxDocSet
    extends MatchDocIdSet {
        private final GeoPointValues values;
        private final GeoPoint topLeft;
        private final GeoPoint bottomRight;

        public Meridian180GeoBoundingBoxDocSet(int maxDoc, @Nullable Bits acceptDocs, GeoPointValues values, GeoPoint topLeft, GeoPoint bottomRight) {
            super(maxDoc, acceptDocs);
            this.values = values;
            this.topLeft = topLeft;
            this.bottomRight = bottomRight;
        }

        public boolean isCacheable() {
            return true;
        }

        @Override
        protected boolean matchDoc(int doc) {
            if (!this.values.hasValue(doc)) {
                return false;
            }
            if (this.values.isMultiValued()) {
                GeoPointValues.Iter iter = this.values.getIter(doc);
                while (iter.hasNext()) {
                    GeoPoint point = iter.next();
                    if (!(this.topLeft.lon() <= point.lon()) && !(this.bottomRight.lon() >= point.lon()) || !(this.topLeft.lat() >= point.lat()) || !(this.bottomRight.lat() <= point.lat())) continue;
                    return true;
                }
            } else {
                GeoPoint point = this.values.getValue(doc);
                if ((this.topLeft.lon() <= point.lon() || this.bottomRight.lon() >= point.lon()) && this.topLeft.lat() >= point.lat() && this.bottomRight.lat() <= point.lat()) {
                    return true;
                }
            }
            return false;
        }
    }
}

