/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.nested;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.index.fielddata.fieldcomparator.NumberComparatorBase;

abstract class NestedFieldComparator
extends FieldComparator {
    final Filter rootDocumentsFilter;
    final Filter innerDocumentsFilter;
    final int spareSlot;
    FieldComparator wrappedComparator;
    FixedBitSet rootDocuments;
    FixedBitSet innerDocuments;
    int bottomSlot;

    NestedFieldComparator(FieldComparator wrappedComparator, Filter rootDocumentsFilter, Filter innerDocumentsFilter, int spareSlot) {
        this.wrappedComparator = wrappedComparator;
        this.rootDocumentsFilter = rootDocumentsFilter;
        this.innerDocumentsFilter = innerDocumentsFilter;
        this.spareSlot = spareSlot;
    }

    public final int compare(int slot1, int slot2) {
        return this.wrappedComparator.compare(slot1, slot2);
    }

    public final void setBottom(int slot) {
        this.wrappedComparator.setBottom(slot);
        this.bottomSlot = slot;
    }

    public FieldComparator setNextReader(AtomicReaderContext context) throws IOException {
        DocIdSet innerDocuments = this.innerDocumentsFilter.getDocIdSet(context, null);
        this.innerDocuments = DocIdSets.isEmpty(innerDocuments) ? null : (innerDocuments instanceof FixedBitSet ? (FixedBitSet)innerDocuments : DocIdSets.toFixedBitSet(innerDocuments.iterator(), context.reader().maxDoc()));
        DocIdSet rootDocuments = this.rootDocumentsFilter.getDocIdSet(context, null);
        this.rootDocuments = DocIdSets.isEmpty(rootDocuments) ? null : (rootDocuments instanceof FixedBitSet ? (FixedBitSet)rootDocuments : DocIdSets.toFixedBitSet(rootDocuments.iterator(), context.reader().maxDoc()));
        this.wrappedComparator = this.wrappedComparator.setNextReader(context);
        return this;
    }

    public final Object value(int slot) {
        return this.wrappedComparator.value(slot);
    }

    public final int compareDocToValue(int rootDoc, Object value) throws IOException {
        throw new UnsupportedOperationException("compareDocToValue() not used for sorting in ES");
    }

    static final void copyMissing(FieldComparator comparator, int slot) {
        if (comparator instanceof NumberComparatorBase) {
            ((NumberComparatorBase)comparator).missing(slot);
        }
    }

    static final int compareBottomMissing(FieldComparator comparator) {
        if (comparator instanceof NumberComparatorBase) {
            return ((NumberComparatorBase)comparator).compareBottomMissing();
        }
        return 0;
    }

    static final class Avg
    extends NestedFieldComparator {
        NumberComparatorBase wrappedComparator;

        Avg(NumberComparatorBase wrappedComparator, Filter rootDocumentsFilter, Filter innerDocumentsFilter, int spareSlot) {
            super(wrappedComparator, rootDocumentsFilter, innerDocumentsFilter, spareSlot);
            this.wrappedComparator = wrappedComparator;
        }

        public int compareBottom(int rootDoc) throws IOException {
            if (rootDoc == 0 || this.rootDocuments == null || this.innerDocuments == null) {
                return 0;
            }
            int prevRootDoc = this.rootDocuments.prevSetBit(rootDoc - 1);
            int nestedDoc = this.innerDocuments.nextSetBit(prevRootDoc + 1);
            if (nestedDoc >= rootDoc || nestedDoc == -1) {
                return Avg.compareBottomMissing(this.wrappedComparator);
            }
            int counter = 1;
            this.wrappedComparator.copy(this.spareSlot, nestedDoc);
            nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1);
            while (nestedDoc > prevRootDoc && nestedDoc < rootDoc) {
                this.wrappedComparator.add(this.spareSlot, nestedDoc);
                nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1);
                ++counter;
            }
            this.wrappedComparator.divide(this.spareSlot, counter);
            return this.compare(this.bottomSlot, this.spareSlot);
        }

        public void copy(int slot, int rootDoc) throws IOException {
            if (rootDoc == 0 || this.rootDocuments == null || this.innerDocuments == null) {
                return;
            }
            int prevRootDoc = this.rootDocuments.prevSetBit(rootDoc - 1);
            int nestedDoc = this.innerDocuments.nextSetBit(prevRootDoc + 1);
            if (nestedDoc >= rootDoc || nestedDoc == -1) {
                Avg.copyMissing(this.wrappedComparator, slot);
                return;
            }
            int counter = 1;
            this.wrappedComparator.copy(slot, nestedDoc);
            nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1);
            while (nestedDoc > prevRootDoc && nestedDoc < rootDoc) {
                this.wrappedComparator.add(slot, nestedDoc);
                nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1);
                ++counter;
            }
            this.wrappedComparator.divide(slot, counter);
        }

        @Override
        public FieldComparator setNextReader(AtomicReaderContext context) throws IOException {
            super.setNextReader(context);
            this.wrappedComparator = (NumberComparatorBase)((NestedFieldComparator)this).wrappedComparator;
            return this;
        }
    }

    static final class Sum
    extends NestedFieldComparator {
        NumberComparatorBase wrappedComparator;

        Sum(NumberComparatorBase wrappedComparator, Filter rootDocumentsFilter, Filter innerDocumentsFilter, int spareSlot) {
            super(wrappedComparator, rootDocumentsFilter, innerDocumentsFilter, spareSlot);
            this.wrappedComparator = wrappedComparator;
        }

        public int compareBottom(int rootDoc) throws IOException {
            if (rootDoc == 0 || this.rootDocuments == null || this.innerDocuments == null) {
                return Sum.compareBottomMissing(this.wrappedComparator);
            }
            int prevRootDoc = this.rootDocuments.prevSetBit(rootDoc - 1);
            int nestedDoc = this.innerDocuments.nextSetBit(prevRootDoc + 1);
            if (nestedDoc >= rootDoc || nestedDoc == -1) {
                return Sum.compareBottomMissing(this.wrappedComparator);
            }
            this.wrappedComparator.copy(this.spareSlot, nestedDoc);
            nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1);
            while (nestedDoc > prevRootDoc && nestedDoc < rootDoc) {
                this.wrappedComparator.add(this.spareSlot, nestedDoc);
                nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1);
            }
            return this.compare(this.bottomSlot, this.spareSlot);
        }

        public void copy(int slot, int rootDoc) throws IOException {
            if (rootDoc == 0 || this.rootDocuments == null || this.innerDocuments == null) {
                Sum.copyMissing(this.wrappedComparator, slot);
                return;
            }
            int prevRootDoc = this.rootDocuments.prevSetBit(rootDoc - 1);
            int nestedDoc = this.innerDocuments.nextSetBit(prevRootDoc + 1);
            if (nestedDoc >= rootDoc || nestedDoc == -1) {
                Sum.copyMissing(this.wrappedComparator, slot);
                return;
            }
            this.wrappedComparator.copy(slot, nestedDoc);
            nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1);
            while (nestedDoc > prevRootDoc && nestedDoc < rootDoc) {
                this.wrappedComparator.add(slot, nestedDoc);
                nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1);
            }
        }

        @Override
        public FieldComparator setNextReader(AtomicReaderContext context) throws IOException {
            super.setNextReader(context);
            this.wrappedComparator = (NumberComparatorBase)((NestedFieldComparator)this).wrappedComparator;
            return this;
        }
    }

    static final class Highest
    extends NestedFieldComparator {
        Highest(FieldComparator wrappedComparator, Filter parentFilter, Filter childFilter, int spareSlot) {
            super(wrappedComparator, parentFilter, childFilter, spareSlot);
        }

        public int compareBottom(int rootDoc) throws IOException {
            if (rootDoc == 0 || this.rootDocuments == null || this.innerDocuments == null) {
                return Highest.compareBottomMissing(this.wrappedComparator);
            }
            int prevRootDoc = this.rootDocuments.prevSetBit(rootDoc - 1);
            int nestedDoc = this.innerDocuments.nextSetBit(prevRootDoc + 1);
            if (nestedDoc >= rootDoc || nestedDoc == -1) {
                return Highest.compareBottomMissing(this.wrappedComparator);
            }
            int cmp = this.wrappedComparator.compareBottom(nestedDoc);
            if (cmp < 0) {
                return cmp;
            }
            while ((nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1)) < rootDoc && nestedDoc != -1) {
                int cmp1 = this.wrappedComparator.compareBottom(nestedDoc);
                if (cmp1 < 0) {
                    return cmp1;
                }
                if (cmp1 != 0) continue;
                cmp = 0;
            }
            return cmp;
        }

        public void copy(int slot, int rootDoc) throws IOException {
            if (rootDoc == 0 || this.rootDocuments == null || this.innerDocuments == null) {
                Highest.copyMissing(this.wrappedComparator, slot);
                return;
            }
            int prevRootDoc = this.rootDocuments.prevSetBit(rootDoc - 1);
            int nestedDoc = this.innerDocuments.nextSetBit(prevRootDoc + 1);
            if (nestedDoc >= rootDoc || nestedDoc == -1) {
                Highest.copyMissing(this.wrappedComparator, slot);
                return;
            }
            this.wrappedComparator.copy(this.spareSlot, nestedDoc);
            this.wrappedComparator.copy(slot, nestedDoc);
            while ((nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1)) < rootDoc && nestedDoc != -1) {
                this.wrappedComparator.copy(this.spareSlot, nestedDoc);
                if (this.wrappedComparator.compare(this.spareSlot, slot) <= 0) continue;
                this.wrappedComparator.copy(slot, nestedDoc);
            }
            return;
        }
    }

    static final class Lowest
    extends NestedFieldComparator {
        Lowest(FieldComparator wrappedComparator, Filter parentFilter, Filter childFilter, int spareSlot) {
            super(wrappedComparator, parentFilter, childFilter, spareSlot);
        }

        public int compareBottom(int rootDoc) throws IOException {
            if (rootDoc == 0 || this.rootDocuments == null || this.innerDocuments == null) {
                return Lowest.compareBottomMissing(this.wrappedComparator);
            }
            int prevRootDoc = this.rootDocuments.prevSetBit(rootDoc - 1);
            int nestedDoc = this.innerDocuments.nextSetBit(prevRootDoc + 1);
            if (nestedDoc >= rootDoc || nestedDoc == -1) {
                return Lowest.compareBottomMissing(this.wrappedComparator);
            }
            int cmp = this.wrappedComparator.compareBottom(nestedDoc);
            if (cmp > 0) {
                return cmp;
            }
            while ((nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1)) < rootDoc && nestedDoc != -1) {
                int cmp1 = this.wrappedComparator.compareBottom(nestedDoc);
                if (cmp1 > 0) {
                    return cmp1;
                }
                if (cmp1 != 0) continue;
                cmp = 0;
            }
            return cmp;
        }

        public void copy(int slot, int rootDoc) throws IOException {
            if (rootDoc == 0 || this.rootDocuments == null || this.innerDocuments == null) {
                Lowest.copyMissing(this.wrappedComparator, slot);
                return;
            }
            int prevRootDoc = this.rootDocuments.prevSetBit(rootDoc - 1);
            int nestedDoc = this.innerDocuments.nextSetBit(prevRootDoc + 1);
            if (nestedDoc >= rootDoc || nestedDoc == -1) {
                Lowest.copyMissing(this.wrappedComparator, slot);
                return;
            }
            this.wrappedComparator.copy(this.spareSlot, nestedDoc);
            this.wrappedComparator.copy(slot, nestedDoc);
            while ((nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1)) < rootDoc && nestedDoc != -1) {
                this.wrappedComparator.copy(this.spareSlot, nestedDoc);
                if (this.wrappedComparator.compare(this.spareSlot, slot) >= 0) continue;
                this.wrappedComparator.copy(slot, nestedDoc);
            }
            return;
        }
    }
}

