/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.Locale;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.rest.RestStatus;

public class AliasMissingException
extends ElasticSearchException {
    private final String[] names;

    public AliasMissingException(String ... names) {
        super(String.format(Locale.ROOT, "alias [%s] missing", AliasMissingException.toNamesString(names)));
        this.names = names;
    }

    public String[] getName() {
        return this.names;
    }

    @Override
    public RestStatus status() {
        return RestStatus.NOT_FOUND;
    }

    private static String toNamesString(String ... names) {
        if (names == null || names.length == 0) {
            return "";
        }
        if (names.length == 1) {
            return names[0];
        }
        StringBuilder builder = new StringBuilder(names[0]);
        for (int i = 1; i < names.length; ++i) {
            builder.append(',').append(names[i]);
        }
        return builder.toString();
    }
}

