/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.fielddata.cache;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentReader;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.RemovalListener;
import org.elasticsearch.common.cache.RemovalNotification;
import org.elasticsearch.common.cache.Weigher;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardUtils;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.monitor.jvm.JvmInfo;

public class IndicesFieldDataCache
extends AbstractComponent
implements RemovalListener<Key, AtomicFieldData> {
    Cache<Key, AtomicFieldData> cache;
    private volatile String size;
    private volatile long sizeInBytes;
    private volatile TimeValue expire;

    @Inject
    public IndicesFieldDataCache(Settings settings) {
        super(settings);
        this.size = this.componentSettings.get("size", "-1");
        this.expire = this.componentSettings.getAsTime("expire", null);
        this.computeSizeInBytes();
        this.buildCache();
    }

    private void buildCache() {
        CacheBuilder<Key, AtomicFieldData> cacheBuilder = CacheBuilder.newBuilder().removalListener(this);
        if (this.sizeInBytes > 0L) {
            cacheBuilder.maximumWeight(this.sizeInBytes).weigher(new FieldDataWeigher());
        }
        cacheBuilder.concurrencyLevel(16);
        if (this.expire != null && this.expire.millis() > 0L) {
            cacheBuilder.expireAfterAccess(this.expire.millis(), TimeUnit.MILLISECONDS);
        }
        this.logger.debug("using size [{}] [{}], expire [{}]", this.size, new ByteSizeValue(this.sizeInBytes), this.expire);
        this.cache = cacheBuilder.build();
    }

    private void computeSizeInBytes() {
        if (this.size.equals("-1")) {
            this.sizeInBytes = -1L;
        } else if (this.size.endsWith("%")) {
            double percent = Double.parseDouble(this.size.substring(0, this.size.length() - 1));
            this.sizeInBytes = (long)(percent / 100.0 * (double)JvmInfo.jvmInfo().getMem().getHeapMax().bytes());
        } else {
            this.sizeInBytes = ByteSizeValue.parseBytesSizeValue(this.size).bytes();
        }
    }

    public void close() {
        this.cache.invalidateAll();
    }

    public IndexFieldDataCache buildIndexFieldDataCache(@Nullable IndexService indexService, Index index, FieldMapper.Names fieldNames, FieldDataType fieldDataType) {
        return new IndexFieldCache(indexService, index, fieldNames, fieldDataType);
    }

    @Override
    public void onRemoval(RemovalNotification<Key, AtomicFieldData> notification) {
        if (notification.getKey() != null && notification.getKey().listener != null) {
            IndexFieldCache indexCache = notification.getKey().indexCache;
            long sizeInBytes = notification.getKey().sizeInBytes;
            if (sizeInBytes == -1L && notification.getValue() != null) {
                sizeInBytes = notification.getValue().getMemorySizeInBytes();
            }
            notification.getKey().listener.onUnload(indexCache.fieldNames, indexCache.fieldDataType, notification.wasEvicted(), sizeInBytes, notification.getValue());
        }
    }

    public static class Key {
        public final IndexFieldCache indexCache;
        public final Object readerKey;
        @Nullable
        public IndexFieldDataCache.Listener listener;
        long sizeInBytes = -1L;

        Key(IndexFieldCache indexCache, Object readerKey) {
            this.indexCache = indexCache;
            this.readerKey = readerKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            Key key = (Key)o;
            if (!this.indexCache.equals(key.indexCache)) {
                return false;
            }
            return this.readerKey.equals(key.readerKey);
        }

        public int hashCode() {
            int result = this.indexCache.hashCode();
            result = 31 * result + this.readerKey.hashCode();
            return result;
        }
    }

    class IndexFieldCache
    implements IndexFieldDataCache,
    SegmentReader.CoreClosedListener {
        @Nullable
        private final IndexService indexService;
        final Index index;
        final FieldMapper.Names fieldNames;
        final FieldDataType fieldDataType;

        IndexFieldCache(IndexService indexService, Index index, FieldMapper.Names fieldNames, FieldDataType fieldDataType) {
            this.indexService = indexService;
            this.index = index;
            this.fieldNames = fieldNames;
            this.fieldDataType = fieldDataType;
        }

        @Override
        public <FD extends AtomicFieldData, IFD extends IndexFieldData<FD>> FD load(final AtomicReaderContext context, final IFD indexFieldData) throws Exception {
            final Key key = new Key(this, context.reader().getCoreCacheKey());
            return (FD)IndicesFieldDataCache.this.cache.get(key, new Callable<AtomicFieldData>(){

                @Override
                public AtomicFieldData call() throws Exception {
                    IndexShard shard;
                    ShardId shardId;
                    if (context.reader() instanceof SegmentReader) {
                        ((SegmentReader)context.reader()).addCoreClosedListener((SegmentReader.CoreClosedListener)IndexFieldCache.this);
                    }
                    Object fieldData = indexFieldData.loadDirect(context);
                    if (IndexFieldCache.this.indexService != null && (shardId = ShardUtils.extractShardId((IndexReader)context.reader())) != null && (shard = IndexFieldCache.this.indexService.shard(shardId.id())) != null) {
                        key.listener = shard.fieldData();
                    }
                    if (key.listener != null) {
                        key.listener.onLoad(IndexFieldCache.this.fieldNames, IndexFieldCache.this.fieldDataType, (AtomicFieldData)fieldData);
                    }
                    return fieldData;
                }
            });
        }

        public void onClose(SegmentReader owner) {
            IndicesFieldDataCache.this.cache.invalidate(new Key(this, owner.getCoreCacheKey()));
        }

        @Override
        public void clear() {
            for (Key key : IndicesFieldDataCache.this.cache.asMap().keySet()) {
                if (!key.indexCache.index.equals(this.index)) continue;
                IndicesFieldDataCache.this.cache.invalidate(key);
            }
        }

        @Override
        public void clear(String fieldName) {
            for (Key key : IndicesFieldDataCache.this.cache.asMap().keySet()) {
                if (!key.indexCache.index.equals(this.index) || !key.indexCache.fieldNames.fullName().equals(fieldName)) continue;
                IndicesFieldDataCache.this.cache.invalidate(key);
            }
        }

        @Override
        public void clear(IndexReader reader) {
            IndicesFieldDataCache.this.cache.invalidate(new Key(this, reader.getCoreCacheKey()));
        }
    }

    public static class FieldDataWeigher
    implements Weigher<Key, AtomicFieldData> {
        @Override
        public int weigh(Key key, AtomicFieldData fieldData) {
            int weight = (int)Math.min(fieldData.getMemorySizeInBytes(), Integer.MAX_VALUE);
            return weight == 0 ? 1 : weight;
        }
    }
}

