/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.dump;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.monitor.dump.Dump;
import org.elasticsearch.monitor.dump.DumpException;

public abstract class AbstractDump
implements Dump {
    private final long timestamp;
    private final String cause;
    private final Map<String, Object> context;
    private final ArrayList<File> files = new ArrayList();

    protected AbstractDump(long timestamp, String cause, @Nullable Map<String, Object> context) {
        this.timestamp = timestamp;
        this.cause = cause;
        if (context == null) {
            context = ImmutableMap.of();
        }
        this.context = context;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public Map<String, Object> context() {
        return this.context;
    }

    @Override
    public String cause() {
        return this.cause;
    }

    @Override
    public File[] files() {
        return this.files.toArray(new File[this.files.size()]);
    }

    @Override
    public File createFile(String name) throws DumpException {
        File file = this.doCreateFile(name);
        this.files.add(file);
        return file;
    }

    protected abstract File doCreateFile(String var1) throws DumpException;

    @Override
    public OutputStream createFileOutputStream(String name) throws DumpException {
        try {
            return new FileOutputStream(this.createFile(name));
        }
        catch (FileNotFoundException e) {
            throw new DumpException("Failed to create file [" + name + "]", e);
        }
    }

    @Override
    public Writer createFileWriter(String name) throws DumpException {
        return new OutputStreamWriter(this.createFileOutputStream(name), Streams.UTF8);
    }
}

