/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.fs;

import java.io.IOException;
import java.util.Iterator;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class FsStats
implements Iterable<Info>,
Streamable,
ToXContent {
    long timestamp;
    Info[] infos;

    FsStats() {
    }

    FsStats(long timestamp, Info[] infos) {
        this.timestamp = timestamp;
        this.infos = infos;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Iterator<Info> iterator() {
        return Iterators.forArray(this.infos);
    }

    public static FsStats readFsStats(StreamInput in) throws IOException {
        FsStats stats = new FsStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.timestamp = in.readVLong();
        this.infos = new Info[in.readVInt()];
        for (int i = 0; i < this.infos.length; ++i) {
            this.infos[i] = new Info();
            this.infos[i].readFrom(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        out.writeVInt(this.infos.length);
        for (Info info : this.infos) {
            info.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.FS);
        builder.field(Fields.TIMESTAMP, this.timestamp);
        builder.startArray(Fields.DATA);
        for (Info info : this.infos) {
            builder.startObject();
            builder.field(Fields.PATH, info.path);
            if (info.mount != null) {
                builder.field(Fields.MOUNT, info.mount);
            }
            if (info.dev != null) {
                builder.field(Fields.DEV, info.dev);
            }
            if (info.total != -1L) {
                builder.field(Fields.TOTAL, info.getTotal().toString());
                builder.field(Fields.TOTAL_IN_BYTES, info.total);
            }
            if (info.free != -1L) {
                builder.field(Fields.FREE, info.getFree().toString());
                builder.field(Fields.FREE_IN_BYTES, info.free);
            }
            if (info.available != -1L) {
                builder.field(Fields.AVAILABLE, info.getAvailable().toString());
                builder.field(Fields.AVAILABLE_IN_BYTES, info.available);
            }
            if (info.diskReads != -1L) {
                builder.field(Fields.DISK_READS, info.diskReads);
            }
            if (info.diskWrites != -1L) {
                builder.field(Fields.DISK_WRITES, info.diskWrites);
            }
            if (info.diskReadBytes != -1L) {
                builder.field(Fields.DISK_READ_SIZE, info.getDiskReadSizeSize().toString());
                builder.field(Fields.DISK_READ_SIZE_IN_BYTES, info.getDiskReadSizeInBytes());
            }
            if (info.diskWriteBytes != -1L) {
                builder.field(Fields.DISK_WRITE_SIZE, info.getDiskWriteSizeSize().toString());
                builder.field(Fields.DISK_WRITE_SIZE_IN_BYTES, info.getDiskWriteSizeInBytes());
            }
            if (info.diskQueue != -1.0) {
                builder.field(Fields.DISK_QUEUE, Strings.format1Decimals(info.diskQueue, ""));
            }
            if (info.diskServiceTime != -1.0) {
                builder.field(Fields.DISK_SERVICE_TIME, Strings.format1Decimals(info.diskServiceTime, ""));
            }
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString FS = new XContentBuilderString("fs");
        static final XContentBuilderString TIMESTAMP = new XContentBuilderString("timestamp");
        static final XContentBuilderString DATA = new XContentBuilderString("data");
        static final XContentBuilderString PATH = new XContentBuilderString("path");
        static final XContentBuilderString MOUNT = new XContentBuilderString("mount");
        static final XContentBuilderString DEV = new XContentBuilderString("dev");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString TOTAL_IN_BYTES = new XContentBuilderString("total_in_bytes");
        static final XContentBuilderString FREE = new XContentBuilderString("free");
        static final XContentBuilderString FREE_IN_BYTES = new XContentBuilderString("free_in_bytes");
        static final XContentBuilderString AVAILABLE = new XContentBuilderString("available");
        static final XContentBuilderString AVAILABLE_IN_BYTES = new XContentBuilderString("available_in_bytes");
        static final XContentBuilderString DISK_READS = new XContentBuilderString("disk_reads");
        static final XContentBuilderString DISK_WRITES = new XContentBuilderString("disk_writes");
        static final XContentBuilderString DISK_READ_SIZE = new XContentBuilderString("disk_read_size");
        static final XContentBuilderString DISK_READ_SIZE_IN_BYTES = new XContentBuilderString("disk_read_size_in_bytes");
        static final XContentBuilderString DISK_WRITE_SIZE = new XContentBuilderString("disk_write_size");
        static final XContentBuilderString DISK_WRITE_SIZE_IN_BYTES = new XContentBuilderString("disk_write_size_in_bytes");
        static final XContentBuilderString DISK_QUEUE = new XContentBuilderString("disk_queue");
        static final XContentBuilderString DISK_SERVICE_TIME = new XContentBuilderString("disk_service_time");

        Fields() {
        }
    }

    public static class Info
    implements Streamable {
        String path;
        @Nullable
        String mount;
        @Nullable
        String dev;
        long total = -1L;
        long free = -1L;
        long available = -1L;
        long diskReads = -1L;
        long diskWrites = -1L;
        long diskReadBytes = -1L;
        long diskWriteBytes = -1L;
        double diskQueue = -1.0;
        double diskServiceTime = -1.0;

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.path = in.readString();
            this.mount = in.readOptionalString();
            this.dev = in.readOptionalString();
            this.total = in.readLong();
            this.free = in.readLong();
            this.available = in.readLong();
            this.diskReads = in.readLong();
            this.diskWrites = in.readLong();
            this.diskReadBytes = in.readLong();
            this.diskWriteBytes = in.readLong();
            this.diskQueue = in.readDouble();
            this.diskServiceTime = in.readDouble();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.path);
            out.writeOptionalString(this.mount);
            out.writeOptionalString(this.dev);
            out.writeLong(this.total);
            out.writeLong(this.free);
            out.writeLong(this.available);
            out.writeLong(this.diskReads);
            out.writeLong(this.diskWrites);
            out.writeLong(this.diskReadBytes);
            out.writeLong(this.diskWriteBytes);
            out.writeDouble(this.diskQueue);
            out.writeDouble(this.diskServiceTime);
        }

        public ByteSizeValue getTotal() {
            return new ByteSizeValue(this.total);
        }

        public ByteSizeValue getFree() {
            return new ByteSizeValue(this.free);
        }

        public ByteSizeValue getAvailable() {
            return new ByteSizeValue(this.available);
        }

        public long getDiskReads() {
            return this.diskReads;
        }

        public long getDiskWrites() {
            return this.diskWrites;
        }

        public long getDiskReadSizeInBytes() {
            return this.diskReadBytes;
        }

        public ByteSizeValue getDiskReadSizeSize() {
            return new ByteSizeValue(this.diskReadBytes);
        }

        public long getDiskWriteSizeInBytes() {
            return this.diskWriteBytes;
        }

        public ByteSizeValue getDiskWriteSizeSize() {
            return new ByteSizeValue(this.diskWriteBytes);
        }

        public double getDiskQueue() {
            return this.diskQueue;
        }

        public double getDiskServiceTime() {
            return this.diskServiceTime;
        }
    }
}

