/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.alias.put;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestIndexPutAliasAction
extends BaseRestHandler {
    @Inject
    public RestIndexPutAliasAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_alias", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_alias", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        String index = request.param("index");
        String alias = request.param("name");
        Map<String, Object> filter = null;
        String routing = null;
        String indexRouting = null;
        String searchRouting = null;
        if (request.hasContent()) {
            XContentParser parser = null;
            try {
                parser = XContentFactory.xContent(request.content()).createParser(request.content());
                XContentParser.Token token = parser.nextToken();
                if (token == null) {
                    throw new ElasticSearchIllegalArgumentException("No index alias is specified");
                }
                String currentFieldName = null;
                while ((token = parser.nextToken()) != null) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token.isValue()) {
                        if ("index".equals(currentFieldName)) {
                            index = parser.text();
                            continue;
                        }
                        if ("alias".equals(currentFieldName)) {
                            alias = parser.text();
                            continue;
                        }
                        if ("routing".equals(currentFieldName)) {
                            routing = parser.textOrNull();
                            continue;
                        }
                        if ("indexRouting".equals(currentFieldName) || "index-routing".equals(currentFieldName) || "index_routing".equals(currentFieldName)) {
                            indexRouting = parser.textOrNull();
                            continue;
                        }
                        if (!"searchRouting".equals(currentFieldName) && !"search-routing".equals(currentFieldName) && !"search_routing".equals(currentFieldName)) continue;
                        searchRouting = parser.textOrNull();
                        continue;
                    }
                    if (token != XContentParser.Token.START_OBJECT || !"filter".equals(currentFieldName)) continue;
                    filter = parser.mapOrdered();
                }
            }
            catch (Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    this.logger.warn("Failed to send response", e1, new Object[0]);
                }
                return;
            }
            finally {
                if (parser != null) {
                    parser.close();
                }
            }
        }
        IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest();
        indicesAliasesRequest.timeout(request.paramAsTime("timeout", TimeValue.timeValueSeconds(10L)));
        AliasAction aliasAction = new AliasAction(AliasAction.Type.ADD, index, alias);
        indicesAliasesRequest.addAliasAction(aliasAction);
        if (routing != null) {
            aliasAction.routing(routing);
        }
        if (searchRouting != null) {
            aliasAction.searchRouting(searchRouting);
        }
        if (indexRouting != null) {
            aliasAction.indexRouting(indexRouting);
        }
        if (filter != null) {
            aliasAction.filter(filter);
        }
        this.client.admin().indices().aliases(indicesAliasesRequest, new ActionListener<IndicesAliasesResponse>(){

            @Override
            public void onResponse(IndicesAliasesResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    builder.field(Fields.OK, true);
                    builder.field(Fields.ACK, response.isAcknowledged());
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestIndexPutAliasAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }

    static class Fields {
        static final XContentBuilderString OK = new XContentBuilderString("ok");
        static final XContentBuilderString ACK = new XContentBuilderString("acknowledged");

        Fields() {
        }
    }
}

