/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.mlt;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.mlt.MoreLikeThisRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;
import org.elasticsearch.search.Scroll;

public class RestMoreLikeThisAction
extends BaseRestHandler {
    @Inject
    public RestMoreLikeThisAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/{id}/_mlt", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/{id}/_mlt", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        MoreLikeThisRequest mltRequest = Requests.moreLikeThisRequest(request.param("index")).type(request.param("type")).id(request.param("id"));
        mltRequest.routing(request.param("routing"));
        mltRequest.listenerThreaded(false);
        try {
            mltRequest.fields(request.paramAsStringArray("mlt_fields", null));
            mltRequest.percentTermsToMatch(request.paramAsFloat("percent_terms_to_match", -1.0f));
            mltRequest.minTermFreq(request.paramAsInt("min_term_freq", -1));
            mltRequest.maxQueryTerms(request.paramAsInt("max_query_terms", -1));
            mltRequest.stopWords(request.paramAsStringArray("stop_words", null));
            mltRequest.minDocFreq(request.paramAsInt("min_doc_freq", -1));
            mltRequest.maxDocFreq(request.paramAsInt("max_doc_freq", -1));
            mltRequest.minWordLen(request.paramAsInt("min_word_len", -1));
            mltRequest.maxWordLen(request.paramAsInt("max_word_len", -1));
            mltRequest.boostTerms(request.paramAsFloat("boost_terms", -1.0f));
            mltRequest.searchType(SearchType.fromString(request.param("search_type")));
            mltRequest.searchIndices(request.paramAsStringArray("search_indices", null));
            mltRequest.searchTypes(request.paramAsStringArray("search_types", null));
            mltRequest.searchQueryHint(request.param("search_query_hint"));
            mltRequest.searchSize(request.paramAsInt("search_size", mltRequest.searchSize()));
            mltRequest.searchFrom(request.paramAsInt("search_from", mltRequest.searchFrom()));
            String searchScroll = request.param("search_scroll");
            if (searchScroll != null) {
                mltRequest.searchScroll(new Scroll(TimeValue.parseTimeValue(searchScroll, null)));
            }
            if (request.hasContent()) {
                mltRequest.searchSource(request.content(), request.contentUnsafe());
            } else {
                String searchSource = request.param("search_source");
                if (searchSource != null) {
                    mltRequest.searchSource(searchSource);
                }
            }
        }
        catch (Exception e) {
            try {
                XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                channel.sendResponse(new XContentRestResponse(request, RestStatus.BAD_REQUEST, builder.startObject().field("error", e.getMessage()).endObject()));
            }
            catch (IOException e1) {
                this.logger.error("Failed to send failure response", e1, new Object[0]);
            }
            return;
        }
        this.client.moreLikeThis(mltRequest, new ActionListener<SearchResponse>(){

            @Override
            public void onResponse(SearchResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    response.toXContent(builder, request);
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestMoreLikeThisAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

