/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.trove.iterator.TObjectFloatIterator;
import org.elasticsearch.common.trove.map.hash.TObjectFloatHashMap;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilderException;
import org.elasticsearch.search.facet.FacetBuilder;
import org.elasticsearch.search.highlight.HighlightBuilder;
import org.elasticsearch.search.rescore.RescoreBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.SuggestBuilder;

public class SearchSourceBuilder
implements ToXContent {
    private QueryBuilder queryBuilder;
    private BytesReference queryBinary;
    private FilterBuilder filterBuilder;
    private BytesReference filterBinary;
    private int from = -1;
    private int size = -1;
    private Boolean explain;
    private Boolean version;
    private List<SortBuilder> sorts;
    private boolean trackScores = false;
    private Float minScore;
    private long timeoutInMillis = -1L;
    private List<String> fieldNames;
    private List<ScriptField> scriptFields;
    private List<PartialField> partialFields;
    private List<FacetBuilder> facets;
    private BytesReference facetsBinary;
    private HighlightBuilder highlightBuilder;
    private SuggestBuilder suggestBuilder;
    private RescoreBuilder rescoreBuilder;
    private TObjectFloatHashMap<String> indexBoost = null;
    private String[] stats;

    public static SearchSourceBuilder searchSource() {
        return new SearchSourceBuilder();
    }

    public static HighlightBuilder highlight() {
        return new HighlightBuilder();
    }

    public SearchSourceBuilder query(QueryBuilder query) {
        this.queryBuilder = query;
        return this;
    }

    public SearchSourceBuilder query(byte[] queryBinary) {
        return this.query(queryBinary, 0, queryBinary.length);
    }

    public SearchSourceBuilder query(byte[] queryBinary, int queryBinaryOffset, int queryBinaryLength) {
        return this.query(new BytesArray(queryBinary, queryBinaryOffset, queryBinaryLength));
    }

    public SearchSourceBuilder query(BytesReference queryBinary) {
        this.queryBinary = queryBinary;
        return this;
    }

    public SearchSourceBuilder query(String queryString) {
        return this.query(Unicode.fromStringAsBytes(queryString));
    }

    public SearchSourceBuilder query(XContentBuilder query) {
        return this.query(query.bytes());
    }

    public SearchSourceBuilder query(Map query) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(Requests.CONTENT_TYPE);
            builder.map(query);
            return this.query(builder);
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + query + "]", e);
        }
    }

    public SearchSourceBuilder filter(FilterBuilder filter) {
        this.filterBuilder = filter;
        return this;
    }

    public SearchSourceBuilder filter(String filterString) {
        return this.filter(Unicode.fromStringAsBytes(filterString));
    }

    public SearchSourceBuilder filter(byte[] filter) {
        return this.filter(filter, 0, filter.length);
    }

    public SearchSourceBuilder filter(byte[] filterBinary, int filterBinaryOffset, int filterBinaryLength) {
        return this.filter(new BytesArray(filterBinary, filterBinaryOffset, filterBinaryLength));
    }

    public SearchSourceBuilder filter(BytesReference filterBinary) {
        this.filterBinary = filterBinary;
        return this;
    }

    public SearchSourceBuilder filter(XContentBuilder filter) {
        return this.filter(filter.bytes());
    }

    public SearchSourceBuilder filter(Map filter) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(Requests.CONTENT_TYPE);
            builder.map(filter);
            return this.filter(builder);
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + filter + "]", e);
        }
    }

    public SearchSourceBuilder from(int from) {
        this.from = from;
        return this;
    }

    public SearchSourceBuilder size(int size) {
        this.size = size;
        return this;
    }

    public SearchSourceBuilder minScore(float minScore) {
        this.minScore = Float.valueOf(minScore);
        return this;
    }

    public SearchSourceBuilder explain(Boolean explain) {
        this.explain = explain;
        return this;
    }

    public SearchSourceBuilder version(Boolean version) {
        this.version = version;
        return this;
    }

    public SearchSourceBuilder timeout(TimeValue timeout) {
        this.timeoutInMillis = timeout.millis();
        return this;
    }

    public SearchSourceBuilder timeout(String timeout) {
        this.timeoutInMillis = TimeValue.parseTimeValue(timeout, null).millis();
        return this;
    }

    public SearchSourceBuilder sort(String name, SortOrder order) {
        return this.sort(SortBuilders.fieldSort(name).order(order));
    }

    public SearchSourceBuilder sort(String name) {
        return this.sort(SortBuilders.fieldSort(name));
    }

    public SearchSourceBuilder sort(SortBuilder sort) {
        if (this.sorts == null) {
            this.sorts = Lists.newArrayList();
        }
        this.sorts.add(sort);
        return this;
    }

    public SearchSourceBuilder trackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this;
    }

    public SearchSourceBuilder facet(FacetBuilder facet) {
        if (this.facets == null) {
            this.facets = Lists.newArrayList();
        }
        this.facets.add(facet);
        return this;
    }

    public SearchSourceBuilder facets(byte[] facetsBinary) {
        return this.facets(facetsBinary, 0, facetsBinary.length);
    }

    public SearchSourceBuilder facets(byte[] facetsBinary, int facetBinaryOffset, int facetBinaryLength) {
        return this.facets(new BytesArray(facetsBinary, facetBinaryOffset, facetBinaryLength));
    }

    public SearchSourceBuilder facets(BytesReference facetsBinary) {
        this.facetsBinary = facetsBinary;
        return this;
    }

    public SearchSourceBuilder facets(XContentBuilder facets) {
        return this.facets(facets.bytes());
    }

    public SearchSourceBuilder facets(Map facets) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(Requests.CONTENT_TYPE);
            builder.map(facets);
            return this.facets(builder);
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + facets + "]", e);
        }
    }

    public HighlightBuilder highlighter() {
        if (this.highlightBuilder == null) {
            this.highlightBuilder = new HighlightBuilder();
        }
        return this.highlightBuilder;
    }

    public SearchSourceBuilder highlight(HighlightBuilder highlightBuilder) {
        this.highlightBuilder = highlightBuilder;
        return this;
    }

    public SuggestBuilder suggest() {
        if (this.suggestBuilder == null) {
            this.suggestBuilder = new SuggestBuilder("suggest");
        }
        return this.suggestBuilder;
    }

    public RescoreBuilder rescore() {
        if (this.rescoreBuilder == null) {
            this.rescoreBuilder = new RescoreBuilder();
        }
        return this.rescoreBuilder;
    }

    public SearchSourceBuilder noFields() {
        this.fieldNames = ImmutableList.of();
        return this;
    }

    public SearchSourceBuilder fields(List<String> fields) {
        this.fieldNames = fields;
        return this;
    }

    public SearchSourceBuilder fields(String ... fields) {
        if (this.fieldNames == null) {
            this.fieldNames = new ArrayList<String>();
        }
        for (String field : fields) {
            this.fieldNames.add(field);
        }
        return this;
    }

    public SearchSourceBuilder field(String name) {
        if (this.fieldNames == null) {
            this.fieldNames = new ArrayList<String>();
        }
        this.fieldNames.add(name);
        return this;
    }

    public SearchSourceBuilder scriptField(String name, String script) {
        return this.scriptField(name, null, script, null);
    }

    public SearchSourceBuilder scriptField(String name, String script, Map<String, Object> params) {
        return this.scriptField(name, null, script, params);
    }

    public SearchSourceBuilder scriptField(String name, String lang, String script, Map<String, Object> params) {
        if (this.scriptFields == null) {
            this.scriptFields = Lists.newArrayList();
        }
        this.scriptFields.add(new ScriptField(name, lang, script, params));
        return this;
    }

    public SearchSourceBuilder partialField(String name, @Nullable String include, @Nullable String exclude) {
        if (this.partialFields == null) {
            this.partialFields = Lists.newArrayList();
        }
        this.partialFields.add(new PartialField(name, include, exclude));
        return this;
    }

    public SearchSourceBuilder partialField(String name, @Nullable String[] includes, @Nullable String[] excludes) {
        if (this.partialFields == null) {
            this.partialFields = Lists.newArrayList();
        }
        this.partialFields.add(new PartialField(name, includes, excludes));
        return this;
    }

    public SearchSourceBuilder indexBoost(String index, float indexBoost) {
        if (this.indexBoost == null) {
            this.indexBoost = new TObjectFloatHashMap();
        }
        this.indexBoost.put(index, indexBoost);
        return this;
    }

    public SearchSourceBuilder stats(String ... statsGroups) {
        this.stats = statsGroups;
        return this;
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON).prettyPrint();
            this.toXContent(builder, ToXContent.EMPTY_PARAMS);
            return builder.string();
        }
        catch (Exception e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }

    public BytesReference buildAsBytes() throws SearchSourceBuilderException {
        return this.buildAsBytes(Requests.CONTENT_TYPE);
    }

    public BytesReference buildAsBytes(XContentType contentType) throws SearchSourceBuilderException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            this.toXContent(builder, ToXContent.EMPTY_PARAMS);
            return builder.bytes();
        }
        catch (Exception e) {
            throw new SearchSourceBuilderException("Failed to build search source", e);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.from != -1) {
            builder.field("from", this.from);
        }
        if (this.size != -1) {
            builder.field("size", this.size);
        }
        if (this.timeoutInMillis != -1L) {
            builder.field("timeout", this.timeoutInMillis);
        }
        if (this.queryBuilder != null) {
            builder.field("query");
            this.queryBuilder.toXContent(builder, params);
        }
        if (this.queryBinary != null) {
            if (XContentFactory.xContentType(this.queryBinary) == builder.contentType()) {
                builder.rawField("query", this.queryBinary);
            } else {
                builder.field("query_binary", this.queryBinary);
            }
        }
        if (this.filterBuilder != null) {
            builder.field("filter");
            this.filterBuilder.toXContent(builder, params);
        }
        if (this.filterBinary != null) {
            if (XContentFactory.xContentType(this.filterBinary) == builder.contentType()) {
                builder.rawField("filter", this.filterBinary);
            } else {
                builder.field("filter_binary", this.filterBinary);
            }
        }
        if (this.minScore != null) {
            builder.field("min_score", this.minScore);
        }
        if (this.version != null) {
            builder.field("version", (Object)this.version);
        }
        if (this.explain != null) {
            builder.field("explain", (Object)this.explain);
        }
        if (this.fieldNames != null) {
            if (this.fieldNames.size() == 1) {
                builder.field("fields", this.fieldNames.get(0));
            } else {
                builder.startArray("fields");
                for (String fieldName : this.fieldNames) {
                    builder.value(fieldName);
                }
                builder.endArray();
            }
        }
        if (this.partialFields != null) {
            builder.startObject("partial_fields");
            for (PartialField partialField : this.partialFields) {
                builder.startObject(partialField.name());
                if (partialField.includes() != null) {
                    if (partialField.includes().length == 1) {
                        builder.field("include", partialField.includes()[0]);
                    } else {
                        builder.field("include", partialField.includes());
                    }
                }
                if (partialField.excludes() != null) {
                    if (partialField.excludes().length == 1) {
                        builder.field("exclude", partialField.excludes()[0]);
                    } else {
                        builder.field("exclude", partialField.excludes());
                    }
                }
                builder.endObject();
            }
            builder.endObject();
        }
        if (this.scriptFields != null) {
            builder.startObject("script_fields");
            for (ScriptField scriptField : this.scriptFields) {
                builder.startObject(scriptField.fieldName());
                builder.field("script", scriptField.script());
                if (scriptField.lang() != null) {
                    builder.field("lang", scriptField.lang());
                }
                if (scriptField.params() != null) {
                    builder.field("params");
                    builder.map(scriptField.params());
                }
                builder.endObject();
            }
            builder.endObject();
        }
        if (this.sorts != null) {
            builder.startArray("sort");
            for (SortBuilder sort : this.sorts) {
                builder.startObject();
                sort.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
            if (this.trackScores) {
                builder.field("track_scores", this.trackScores);
            }
        }
        if (this.indexBoost != null) {
            builder.startObject("indices_boost");
            TObjectFloatIterator<String> it = this.indexBoost.iterator();
            while (it.hasNext()) {
                it.advance();
                builder.field(it.key(), it.value());
            }
            builder.endObject();
        }
        if (this.facets != null) {
            builder.field("facets");
            builder.startObject();
            for (FacetBuilder facet : this.facets) {
                facet.toXContent(builder, params);
            }
            builder.endObject();
        }
        if (this.facetsBinary != null) {
            if (XContentFactory.xContentType(this.facetsBinary) == builder.contentType()) {
                builder.rawField("facets", this.facetsBinary);
            } else {
                builder.field("facets_binary", this.facetsBinary);
            }
        }
        if (this.highlightBuilder != null) {
            this.highlightBuilder.toXContent(builder, params);
        }
        if (this.suggestBuilder != null) {
            this.suggestBuilder.toXContent(builder, params);
        }
        if (this.rescoreBuilder != null) {
            this.rescoreBuilder.toXContent(builder, params);
        }
        if (this.stats != null) {
            builder.startArray("stats");
            for (String stat : this.stats) {
                builder.value(stat);
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    private static class PartialField {
        private final String name;
        private final String[] includes;
        private final String[] excludes;

        private PartialField(String name, String[] includes, String[] excludes) {
            this.name = name;
            this.includes = includes;
            this.excludes = excludes;
        }

        private PartialField(String name, String include, String exclude) {
            String[] stringArray;
            String[] stringArray2;
            this.name = name;
            if (include == null) {
                stringArray2 = null;
            } else {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = include;
            }
            this.includes = stringArray2;
            if (exclude == null) {
                stringArray = null;
            } else {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = exclude;
            }
            this.excludes = stringArray;
        }

        public String name() {
            return this.name;
        }

        public String[] includes() {
            return this.includes;
        }

        public String[] excludes() {
            return this.excludes;
        }
    }

    private static class ScriptField {
        private final String fieldName;
        private final String script;
        private final String lang;
        private final Map<String, Object> params;

        private ScriptField(String fieldName, String lang, String script, Map<String, Object> params) {
            this.fieldName = fieldName;
            this.lang = lang;
            this.script = script;
            this.params = params;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public String script() {
            return this.script;
        }

        public String lang() {
            return this.lang;
        }

        public Map<String, Object> params() {
            return this.params;
        }
    }
}

