/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.datehistogram;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.trove.iterator.TLongLongIterator;
import org.elasticsearch.common.trove.map.hash.TLongLongHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacet;
import org.elasticsearch.search.facet.datehistogram.InternalDateHistogramFacet;

public class InternalCountDateHistogramFacet
extends InternalDateHistogramFacet {
    private static final BytesReference STREAM_TYPE = new HashedBytesArray("cdHistogram");
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(StreamInput in) throws IOException {
            return InternalCountDateHistogramFacet.readHistogramFacet(in);
        }
    };
    private DateHistogramFacet.ComparatorType comparatorType;
    TLongLongHashMap counts;
    boolean cachedCounts;
    CountEntry[] entries = null;

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public BytesReference streamType() {
        return STREAM_TYPE;
    }

    private InternalCountDateHistogramFacet() {
    }

    public InternalCountDateHistogramFacet(String name, DateHistogramFacet.ComparatorType comparatorType, TLongLongHashMap counts, boolean cachedCounts) {
        super(name);
        this.comparatorType = comparatorType;
        this.counts = counts;
        this.cachedCounts = cachedCounts;
    }

    public List<CountEntry> getEntries() {
        return Arrays.asList(this.computeEntries());
    }

    @Override
    public Iterator<DateHistogramFacet.Entry> iterator() {
        return this.getEntries().iterator();
    }

    void releaseCache() {
        if (this.cachedCounts) {
            CacheRecycler.pushLongLongMap(this.counts);
            this.cachedCounts = false;
            this.counts = null;
        }
    }

    private CountEntry[] computeEntries() {
        if (this.entries != null) {
            return this.entries;
        }
        this.entries = new CountEntry[this.counts.size()];
        int i = 0;
        TLongLongIterator it = this.counts.iterator();
        while (it.hasNext()) {
            it.advance();
            this.entries[i++] = new CountEntry(it.key(), it.value());
        }
        this.releaseCache();
        Arrays.sort(this.entries, this.comparatorType.comparator());
        return this.entries;
    }

    @Override
    public Facet reduce(List<Facet> facets) {
        if (facets.size() == 1) {
            return facets.get(0);
        }
        TLongLongHashMap counts = CacheRecycler.popLongLongMap();
        for (Facet facet : facets) {
            InternalCountDateHistogramFacet histoFacet = (InternalCountDateHistogramFacet)facet;
            TLongLongIterator it = histoFacet.counts.iterator();
            while (it.hasNext()) {
                it.advance();
                counts.adjustOrPutValue(it.key(), it.value(), it.value());
            }
            histoFacet.releaseCache();
        }
        return new InternalCountDateHistogramFacet(this.getName(), this.comparatorType, counts, true);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field(Fields._TYPE, "date_histogram");
        builder.startArray(Fields.ENTRIES);
        for (CountEntry entry : this.computeEntries()) {
            builder.startObject();
            builder.field(Fields.TIME, entry.getTime());
            builder.field(Fields.COUNT, entry.getCount());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalCountDateHistogramFacet readHistogramFacet(StreamInput in) throws IOException {
        InternalCountDateHistogramFacet facet = new InternalCountDateHistogramFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.comparatorType = DateHistogramFacet.ComparatorType.fromId(in.readByte());
        int size = in.readVInt();
        this.counts = CacheRecycler.popLongLongMap();
        this.cachedCounts = true;
        for (int i = 0; i < size; ++i) {
            long key = in.readLong();
            this.counts.put(key, in.readVLong());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.comparatorType.id());
        out.writeVInt(this.counts.size());
        TLongLongIterator it = this.counts.iterator();
        while (it.hasNext()) {
            it.advance();
            out.writeLong(it.key());
            out.writeVLong(it.value());
        }
        this.releaseCache();
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString ENTRIES = new XContentBuilderString("entries");
        static final XContentBuilderString TIME = new XContentBuilderString("time");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");

        Fields() {
        }
    }

    public static class CountEntry
    implements DateHistogramFacet.Entry {
        private final long time;
        private final long count;

        public CountEntry(long time, long count) {
            this.time = time;
            this.count = count;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public long getTotalCount() {
            return 0L;
        }

        @Override
        public double getTotal() {
            return Double.NaN;
        }

        @Override
        public double getMean() {
            return Double.NaN;
        }

        @Override
        public double getMin() {
            return Double.NaN;
        }

        @Override
        public double getMax() {
            return Double.NaN;
        }
    }
}

