/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.datehistogram;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.joda.TimeZoneRounding;
import org.elasticsearch.common.trove.ExtTLongObjectHashMap;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.search.facet.DoubleFacetAggregatorBase;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.LongFacetAggregatorBase;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacet;
import org.elasticsearch.search.facet.datehistogram.InternalFullDateHistogramFacet;

public class ValueDateHistogramFacetExecutor
extends FacetExecutor {
    private final IndexNumericFieldData keyIndexFieldData;
    private final IndexNumericFieldData valueIndexFieldData;
    private final DateHistogramFacet.ComparatorType comparatorType;
    final TimeZoneRounding tzRounding;
    final ExtTLongObjectHashMap<InternalFullDateHistogramFacet.FullEntry> entries;

    public ValueDateHistogramFacetExecutor(IndexNumericFieldData keyIndexFieldData, IndexNumericFieldData valueIndexFieldData, TimeZoneRounding tzRounding, DateHistogramFacet.ComparatorType comparatorType) {
        this.comparatorType = comparatorType;
        this.keyIndexFieldData = keyIndexFieldData;
        this.valueIndexFieldData = valueIndexFieldData;
        this.tzRounding = tzRounding;
        this.entries = CacheRecycler.popLongObjectMap();
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        return new InternalFullDateHistogramFacet(facetName, this.comparatorType, this.entries, true);
    }

    public static class DateHistogramProc
    extends LongFacetAggregatorBase {
        final ExtTLongObjectHashMap<InternalFullDateHistogramFacet.FullEntry> entries;
        private final TimeZoneRounding tzRounding;
        DoubleValues valueValues;
        final ValueAggregator valueAggregator = new ValueAggregator();

        public DateHistogramProc(TimeZoneRounding tzRounding, ExtTLongObjectHashMap<InternalFullDateHistogramFacet.FullEntry> entries) {
            this.tzRounding = tzRounding;
            this.entries = entries;
        }

        @Override
        public void onValue(int docId, long value) {
            long time = this.tzRounding.calc(value);
            InternalFullDateHistogramFacet.FullEntry entry = (InternalFullDateHistogramFacet.FullEntry)this.entries.get(time);
            if (entry == null) {
                entry = new InternalFullDateHistogramFacet.FullEntry(time, 0L, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0L, 0.0);
                this.entries.put(time, entry);
            }
            ++entry.count;
            this.valueAggregator.entry = entry;
            this.valueAggregator.onDoc(docId, this.valueValues);
        }

        public static final class ValueAggregator
        extends DoubleFacetAggregatorBase {
            InternalFullDateHistogramFacet.FullEntry entry;

            @Override
            public void onValue(int docId, double value) {
                ++this.entry.totalCount;
                this.entry.total += value;
                if (value < this.entry.min) {
                    this.entry.min = value;
                }
                if (value > this.entry.max) {
                    this.entry.max = value;
                }
            }
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final DateHistogramProc histoProc;
        private LongValues keyValues;

        public Collector() {
            this.histoProc = new DateHistogramProc(ValueDateHistogramFacetExecutor.this.tzRounding, ValueDateHistogramFacetExecutor.this.entries);
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.keyValues = ((AtomicNumericFieldData)ValueDateHistogramFacetExecutor.this.keyIndexFieldData.load(context)).getLongValues();
            this.histoProc.valueValues = ((AtomicNumericFieldData)ValueDateHistogramFacetExecutor.this.valueIndexFieldData.load(context)).getDoubleValues();
        }

        public void collect(int doc) throws IOException {
            this.histoProc.onDoc(doc, this.keyValues);
        }

        @Override
        public void postCollection() {
        }
    }
}

