/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.trove.ExtTLongObjectHashMap;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.search.facet.DoubleFacetAggregatorBase;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.InternalFullHistogramFacet;
import org.elasticsearch.search.internal.SearchContext;

public class FullHistogramFacetExecutor
extends FacetExecutor {
    private final IndexNumericFieldData indexFieldData;
    private final HistogramFacet.ComparatorType comparatorType;
    final long interval;
    final ExtTLongObjectHashMap<InternalFullHistogramFacet.FullEntry> entries;

    public FullHistogramFacetExecutor(IndexNumericFieldData indexFieldData, long interval, HistogramFacet.ComparatorType comparatorType, SearchContext context) {
        this.comparatorType = comparatorType;
        this.indexFieldData = indexFieldData;
        this.interval = interval;
        this.entries = CacheRecycler.popLongObjectMap();
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        return new InternalFullHistogramFacet(facetName, this.comparatorType, this.entries, true);
    }

    public static long bucket(double value, long interval) {
        return (long)(value / (double)interval) * interval;
    }

    public static final class HistogramProc
    extends DoubleFacetAggregatorBase {
        final long interval;
        final ExtTLongObjectHashMap<InternalFullHistogramFacet.FullEntry> entries;

        public HistogramProc(long interval, ExtTLongObjectHashMap<InternalFullHistogramFacet.FullEntry> entries) {
            this.interval = interval;
            this.entries = entries;
        }

        @Override
        public void onValue(int docId, double value) {
            long bucket = FullHistogramFacetExecutor.bucket(value, this.interval);
            InternalFullHistogramFacet.FullEntry entry = (InternalFullHistogramFacet.FullEntry)this.entries.get(bucket);
            if (entry == null) {
                entry = new InternalFullHistogramFacet.FullEntry(bucket, 1L, value, value, 1L, value);
                this.entries.put(bucket, entry);
            } else {
                ++entry.count;
                ++entry.totalCount;
                entry.total += value;
                if (value < entry.min) {
                    entry.min = value;
                }
                if (value > entry.max) {
                    entry.max = value;
                }
            }
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final HistogramProc histoProc;
        private DoubleValues values;

        Collector() {
            this.histoProc = new HistogramProc(FullHistogramFacetExecutor.this.interval, FullHistogramFacetExecutor.this.entries);
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.values = ((AtomicNumericFieldData)FullHistogramFacetExecutor.this.indexFieldData.load(context)).getDoubleValues();
        }

        public void collect(int doc) throws IOException {
            this.histoProc.onDoc(doc, this.values);
        }

        @Override
        public void postCollection() {
        }
    }
}

