/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.trove.ExtTLongObjectHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.InternalHistogramFacet;

public class InternalFullHistogramFacet
extends InternalHistogramFacet {
    private static final BytesReference STREAM_TYPE = new HashedBytesArray("fHistogram");
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(StreamInput in) throws IOException {
            return InternalFullHistogramFacet.readHistogramFacet(in);
        }
    };
    private HistogramFacet.ComparatorType comparatorType;
    ExtTLongObjectHashMap<FullEntry> tEntries;
    boolean cachedEntries;
    Collection<FullEntry> entries;

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public BytesReference streamType() {
        return STREAM_TYPE;
    }

    InternalFullHistogramFacet() {
    }

    InternalFullHistogramFacet(String name) {
        super(name);
    }

    public InternalFullHistogramFacet(String name, HistogramFacet.ComparatorType comparatorType, ExtTLongObjectHashMap<FullEntry> entries, boolean cachedEntries) {
        super(name);
        this.comparatorType = comparatorType;
        this.tEntries = entries;
        this.cachedEntries = cachedEntries;
        this.entries = entries.valueCollection();
    }

    public List<FullEntry> getEntries() {
        if (!(this.entries instanceof List)) {
            this.entries = new ArrayList<FullEntry>(this.entries);
        }
        return (List)this.entries;
    }

    @Override
    public Iterator<HistogramFacet.Entry> iterator() {
        return this.getEntries().iterator();
    }

    void releaseCache() {
        if (this.cachedEntries) {
            CacheRecycler.pushLongObjectMap(this.tEntries);
            this.cachedEntries = false;
            this.tEntries = null;
        }
    }

    @Override
    public Facet reduce(List<Facet> facets) {
        FullEntry value;
        if (facets.size() == 1) {
            InternalFullHistogramFacet internalFacet = (InternalFullHistogramFacet)facets.get(0);
            List<FullEntry> entries = internalFacet.getEntries();
            Collections.sort(entries, this.comparatorType.comparator());
            internalFacet.releaseCache();
            return internalFacet;
        }
        ExtTLongObjectHashMap map = CacheRecycler.popLongObjectMap();
        for (Facet facet : facets) {
            InternalFullHistogramFacet histoFacet = (InternalFullHistogramFacet)facet;
            for (FullEntry fullEntry : histoFacet.entries) {
                FullEntry current = (FullEntry)map.get(fullEntry.key);
                if (current != null) {
                    current.count += fullEntry.count;
                    current.total += fullEntry.total;
                    current.totalCount += fullEntry.totalCount;
                    if (fullEntry.min < current.min) {
                        current.min = fullEntry.min;
                    }
                    if (!(fullEntry.max > current.max)) continue;
                    current.max = fullEntry.max;
                    continue;
                }
                map.put(fullEntry.key, fullEntry);
            }
            histoFacet.releaseCache();
        }
        Object[] values = map.internalValues();
        Arrays.sort(values, this.comparatorType.comparator());
        ArrayList<FullEntry> ordered = new ArrayList<FullEntry>(map.size());
        for (int i = 0; i < map.size() && (value = (FullEntry)values[i]) != null; ++i) {
            ordered.add(value);
        }
        CacheRecycler.pushLongObjectMap(map);
        InternalFullHistogramFacet ret = new InternalFullHistogramFacet(this.getName());
        ret.comparatorType = this.comparatorType;
        ret.entries = ordered;
        return ret;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field(Fields._TYPE, "histogram");
        builder.startArray(Fields.ENTRIES);
        for (FullEntry entry : this.entries) {
            builder.startObject();
            builder.field(Fields.KEY, entry.getKey());
            builder.field(Fields.COUNT, entry.getCount());
            builder.field(Fields.MIN, entry.getMin());
            builder.field(Fields.MAX, entry.getMax());
            builder.field(Fields.TOTAL, entry.getTotal());
            builder.field(Fields.TOTAL_COUNT, entry.getTotalCount());
            builder.field(Fields.MEAN, entry.getMean());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalFullHistogramFacet readHistogramFacet(StreamInput in) throws IOException {
        InternalFullHistogramFacet facet = new InternalFullHistogramFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.comparatorType = HistogramFacet.ComparatorType.fromId(in.readByte());
        this.cachedEntries = false;
        int size = in.readVInt();
        this.entries = new ArrayList<FullEntry>(size);
        for (int i = 0; i < size; ++i) {
            this.entries.add(new FullEntry(in.readLong(), in.readVLong(), in.readDouble(), in.readDouble(), in.readVLong(), in.readDouble()));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.comparatorType.id());
        out.writeVInt(this.entries.size());
        for (FullEntry entry : this.entries) {
            out.writeLong(entry.key);
            out.writeVLong(entry.count);
            out.writeDouble(entry.min);
            out.writeDouble(entry.max);
            out.writeVLong(entry.totalCount);
            out.writeDouble(entry.total);
        }
        this.releaseCache();
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString ENTRIES = new XContentBuilderString("entries");
        static final XContentBuilderString KEY = new XContentBuilderString("key");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString TOTAL_COUNT = new XContentBuilderString("total_count");
        static final XContentBuilderString MEAN = new XContentBuilderString("mean");
        static final XContentBuilderString MIN = new XContentBuilderString("min");
        static final XContentBuilderString MAX = new XContentBuilderString("max");

        Fields() {
        }
    }

    public static class FullEntry
    implements HistogramFacet.Entry {
        long key;
        long count;
        long totalCount;
        double total;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;

        public FullEntry(long key, long count, double min, double max, long totalCount, double total) {
            this.key = key;
            this.count = count;
            this.min = min;
            this.max = max;
            this.totalCount = totalCount;
            this.total = total;
        }

        @Override
        public long getKey() {
            return this.key;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public double getTotal() {
            return this.total;
        }

        @Override
        public long getTotalCount() {
            return this.totalCount;
        }

        @Override
        public double getMean() {
            return this.total / (double)this.totalCount;
        }

        @Override
        public double getMin() {
            return this.min;
        }

        @Override
        public double getMax() {
            return this.max;
        }
    }
}

