/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.longs;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.trove.iterator.TLongIntIterator;
import org.elasticsearch.common.trove.map.hash.TLongIntHashMap;
import org.elasticsearch.common.trove.set.hash.TLongHashSet;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.LongFacetAggregatorBase;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.longs.InternalLongTermsFacet;
import org.elasticsearch.search.facet.terms.support.EntryPriorityQueue;
import org.elasticsearch.search.internal.SearchContext;

public class TermsLongFacetExecutor
extends FacetExecutor {
    private final IndexNumericFieldData indexFieldData;
    private final TermsFacet.ComparatorType comparatorType;
    private final int size;
    private final SearchScript script;
    private final ImmutableSet<BytesRef> excluded;
    final TLongIntHashMap facets;
    long missing;
    long total;

    public TermsLongFacetExecutor(IndexNumericFieldData indexFieldData, int size, TermsFacet.ComparatorType comparatorType, boolean allTerms, SearchContext context, ImmutableSet<BytesRef> excluded, SearchScript script) {
        this.indexFieldData = indexFieldData;
        this.size = size;
        this.comparatorType = comparatorType;
        this.script = script;
        this.excluded = excluded;
        this.facets = CacheRecycler.popLongIntMap();
        if (allTerms) {
            for (AtomicReaderContext readerContext : context.searcher().getTopReaderContext().leaves()) {
                int maxDoc = readerContext.reader().maxDoc();
                LongValues values = ((AtomicNumericFieldData)indexFieldData.load(readerContext)).getLongValues();
                if (values instanceof LongValues.WithOrdinals) {
                    LongValues.WithOrdinals valuesWithOrds = (LongValues.WithOrdinals)values;
                    Ordinals.Docs ordinals = valuesWithOrds.ordinals();
                    for (int ord = 1; ord < ordinals.getMaxOrd(); ++ord) {
                        this.facets.putIfAbsent(valuesWithOrds.getValueByOrd(ord), 0);
                    }
                    continue;
                }
                if (values.isMultiValued()) {
                    for (int docId = 0; docId < maxDoc; ++docId) {
                        if (!values.hasValue(docId)) continue;
                        LongValues.Iter iter = values.getIter(docId);
                        while (iter.hasNext()) {
                            this.facets.putIfAbsent(iter.next(), 0);
                        }
                    }
                    continue;
                }
                for (int docId = 0; docId < maxDoc; ++docId) {
                    if (!values.hasValue(docId)) continue;
                    long value = values.getValue(docId);
                    this.facets.putIfAbsent(value, 0);
                }
            }
        }
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        if (this.facets.isEmpty()) {
            CacheRecycler.pushLongIntMap(this.facets);
            return new InternalLongTermsFacet(facetName, this.comparatorType, this.size, ImmutableList.<InternalLongTermsFacet.LongEntry>of(), this.missing, this.total);
        }
        if (this.size < 5000) {
            EntryPriorityQueue ordered = new EntryPriorityQueue(this.size, this.comparatorType.comparator());
            TLongIntIterator it = this.facets.iterator();
            while (it.hasNext()) {
                it.advance();
                ordered.insertWithOverflow(new InternalLongTermsFacet.LongEntry(it.key(), it.value()));
            }
            InternalLongTermsFacet.LongEntry[] list = new InternalLongTermsFacet.LongEntry[ordered.size()];
            for (int i = ordered.size() - 1; i >= 0; --i) {
                list[i] = (InternalLongTermsFacet.LongEntry)ordered.pop();
            }
            CacheRecycler.pushLongIntMap(this.facets);
            return new InternalLongTermsFacet(facetName, this.comparatorType, this.size, Arrays.asList(list), this.missing, this.total);
        }
        BoundedTreeSet<TermsFacet.Entry> ordered = new BoundedTreeSet<TermsFacet.Entry>(this.comparatorType.comparator(), this.size);
        TLongIntIterator it = this.facets.iterator();
        while (it.hasNext()) {
            it.advance();
            ordered.add(new InternalLongTermsFacet.LongEntry(it.key(), it.value()));
        }
        CacheRecycler.pushLongIntMap(this.facets);
        return new InternalLongTermsFacet(facetName, this.comparatorType, this.size, ordered, this.missing, this.total);
    }

    public static class StaticAggregatorValueProc
    extends LongFacetAggregatorBase {
        private final TLongIntHashMap facets;

        public StaticAggregatorValueProc(TLongIntHashMap facets) {
            this.facets = facets;
        }

        @Override
        public void onValue(int docId, long value) {
            this.facets.adjustOrPutValue(value, 1, 1);
        }

        public final TLongIntHashMap facets() {
            return this.facets;
        }
    }

    public static class AggregatorValueProc
    extends StaticAggregatorValueProc {
        private final SearchScript script;
        private final TLongHashSet excluded;

        public AggregatorValueProc(TLongIntHashMap facets, Set<BytesRef> excluded, SearchScript script) {
            super(facets);
            this.script = script;
            if (excluded == null || excluded.isEmpty()) {
                this.excluded = null;
            } else {
                this.excluded = new TLongHashSet(excluded.size());
                for (BytesRef s : excluded) {
                    this.excluded.add(Long.parseLong(s.utf8ToString()));
                }
            }
        }

        @Override
        public void onValue(int docId, long value) {
            if (this.excluded != null && this.excluded.contains(value)) {
                return;
            }
            if (this.script != null) {
                this.script.setNextDocId(docId);
                this.script.setNextVar("term", value);
                Object scriptValue = this.script.run();
                if (scriptValue == null) {
                    return;
                }
                if (scriptValue instanceof Boolean) {
                    if (!((Boolean)scriptValue).booleanValue()) {
                        return;
                    }
                } else {
                    value = ((Number)scriptValue).longValue();
                }
            }
            super.onValue(docId, value);
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final StaticAggregatorValueProc aggregator;
        private LongValues values;

        public Collector() {
            this.aggregator = TermsLongFacetExecutor.this.script == null && TermsLongFacetExecutor.this.excluded.isEmpty() ? new StaticAggregatorValueProc(TermsLongFacetExecutor.this.facets) : new AggregatorValueProc(TermsLongFacetExecutor.this.facets, TermsLongFacetExecutor.this.excluded, TermsLongFacetExecutor.this.script);
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            if (TermsLongFacetExecutor.this.script != null) {
                TermsLongFacetExecutor.this.script.setScorer(scorer);
            }
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.values = ((AtomicNumericFieldData)TermsLongFacetExecutor.this.indexFieldData.load(context)).getLongValues();
            if (TermsLongFacetExecutor.this.script != null) {
                TermsLongFacetExecutor.this.script.setNextReader(context);
            }
        }

        public void collect(int doc) throws IOException {
            this.aggregator.onDoc(doc, this.values);
        }

        @Override
        public void postCollection() {
            TermsLongFacetExecutor.this.missing = this.aggregator.missing();
            TermsLongFacetExecutor.this.total = this.aggregator.total();
        }
    }
}

