/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.strings;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.text.BytesText;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.trove.iterator.TObjectIntIterator;
import org.elasticsearch.common.trove.map.hash.TObjectIntHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.terms.InternalTermsFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;

public class InternalStringTermsFacet
extends InternalTermsFacet {
    private static final BytesReference STREAM_TYPE = new HashedBytesArray("tTerms");
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(StreamInput in) throws IOException {
            return InternalStringTermsFacet.readTermsFacet(in);
        }
    };
    int requiredSize;
    long missing;
    long total;
    Collection<TermEntry> entries = ImmutableList.of();
    TermsFacet.ComparatorType comparatorType;

    public static void registerStream() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public BytesReference streamType() {
        return STREAM_TYPE;
    }

    InternalStringTermsFacet() {
    }

    public InternalStringTermsFacet(String name, TermsFacet.ComparatorType comparatorType, int requiredSize, Collection<TermEntry> entries, long missing, long total) {
        super(name);
        this.comparatorType = comparatorType;
        this.requiredSize = requiredSize;
        this.entries = entries;
        this.missing = missing;
        this.total = total;
    }

    public List<TermEntry> getEntries() {
        if (!(this.entries instanceof List)) {
            this.entries = ImmutableList.copyOf(this.entries);
        }
        return (List)this.entries;
    }

    @Override
    public Iterator<TermsFacet.Entry> iterator() {
        return this.entries.iterator();
    }

    @Override
    public long getMissingCount() {
        return this.missing;
    }

    @Override
    public long getTotalCount() {
        return this.total;
    }

    @Override
    public long getOtherCount() {
        long other = this.total;
        for (TermEntry entry : this.entries) {
            other -= (long)entry.getCount();
        }
        return other;
    }

    @Override
    public Facet reduce(List<Facet> facets) {
        if (facets.size() == 1) {
            return facets.get(0);
        }
        InternalStringTermsFacet first = null;
        TObjectIntHashMap aggregated = CacheRecycler.popObjectIntMap();
        long missing = 0L;
        long total = 0L;
        for (Facet facet : facets) {
            InternalTermsFacet termsFacet = (InternalTermsFacet)facet;
            missing += termsFacet.getMissingCount();
            total += termsFacet.getTotalCount();
            if (!(termsFacet instanceof InternalStringTermsFacet)) {
                return termsFacet.reduce(facets);
            }
            if (first == null) {
                first = (InternalStringTermsFacet)termsFacet;
            }
            for (TermsFacet.Entry entry : termsFacet.getEntries()) {
                aggregated.adjustOrPutValue(entry.getTerm(), entry.getCount(), entry.getCount());
            }
        }
        BoundedTreeSet<TermsFacet.Entry> ordered = new BoundedTreeSet<TermsFacet.Entry>(first.comparatorType.comparator(), first.requiredSize);
        TObjectIntIterator it = aggregated.iterator();
        while (it.hasNext()) {
            it.advance();
            ordered.add(new TermEntry((Text)it.key(), it.value()));
        }
        first.entries = ordered;
        first.missing = missing;
        first.total = total;
        CacheRecycler.pushObjectIntMap(aggregated);
        return first;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field(Fields._TYPE, "terms");
        builder.field(Fields.MISSING, this.missing);
        builder.field(Fields.TOTAL, this.total);
        builder.field(Fields.OTHER, this.getOtherCount());
        builder.startArray(Fields.TERMS);
        for (TermEntry entry : this.entries) {
            builder.startObject();
            builder.field(Fields.TERM, entry.getTerm());
            builder.field(Fields.COUNT, entry.getCount());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalStringTermsFacet readTermsFacet(StreamInput in) throws IOException {
        InternalStringTermsFacet facet = new InternalStringTermsFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.comparatorType = TermsFacet.ComparatorType.fromId(in.readByte());
        this.requiredSize = in.readVInt();
        this.missing = in.readVLong();
        this.total = in.readVLong();
        int size = in.readVInt();
        this.entries = new ArrayList<TermEntry>(size);
        for (int i = 0; i < size; ++i) {
            this.entries.add(new TermEntry(in.readText(), in.readVInt()));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.comparatorType.id());
        out.writeVInt(this.requiredSize);
        out.writeVLong(this.missing);
        out.writeVLong(this.total);
        out.writeVInt(this.entries.size());
        for (TermEntry entry : this.entries) {
            out.writeText(entry.getTerm());
            out.writeVInt(entry.getCount());
        }
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString MISSING = new XContentBuilderString("missing");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString OTHER = new XContentBuilderString("other");
        static final XContentBuilderString TERMS = new XContentBuilderString("terms");
        static final XContentBuilderString TERM = new XContentBuilderString("term");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");

        Fields() {
        }
    }

    public static class TermEntry
    implements TermsFacet.Entry {
        private Text term;
        private int count;

        public TermEntry(String term, int count) {
            this.term = new StringText(term);
            this.count = count;
        }

        public TermEntry(BytesRef term, int count) {
            this.term = new BytesText(new BytesArray(term));
            this.count = count;
        }

        public TermEntry(Text term, int count) {
            this.term = term;
            this.count = count;
        }

        @Override
        public Text getTerm() {
            return this.term;
        }

        @Override
        public Number getTermAsNumber() {
            return Double.parseDouble(this.term.string());
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public int compareTo(TermsFacet.Entry o) {
            int i = this.term.compareTo(o.getTerm());
            if (i == 0 && (i = this.count - o.getCount()) == 0) {
                i = System.identityHashCode(this) - System.identityHashCode(o);
            }
            return i;
        }
    }
}

