/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.strings;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.strings.HashedAggregator;
import org.elasticsearch.search.facet.terms.strings.HashedScriptAggregator;
import org.elasticsearch.search.internal.SearchContext;

public class TermsStringFacetExecutor
extends FacetExecutor {
    private final IndexFieldData indexFieldData;
    private final TermsFacet.ComparatorType comparatorType;
    private final SearchScript script;
    private final int size;
    long missing;
    long total;
    private final boolean allTerms;
    private final HashedAggregator aggregator;

    public TermsStringFacetExecutor(IndexFieldData indexFieldData, int size, TermsFacet.ComparatorType comparatorType, boolean allTerms, SearchContext context, ImmutableSet<BytesRef> excluded, Pattern pattern, SearchScript script) {
        this.indexFieldData = indexFieldData;
        this.size = size;
        this.comparatorType = comparatorType;
        this.script = script;
        this.allTerms = allTerms;
        this.aggregator = excluded.isEmpty() && pattern == null && script == null ? new HashedAggregator() : new HashedScriptAggregator(excluded, pattern, script);
        if (allTerms) {
            TermsStringFacetExecutor.loadAllTerms(context, indexFieldData, this.aggregator);
        }
    }

    @Override
    public Collector collector() {
        return new Collector(this.aggregator, this.allTerms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalFacet buildFacet(String facetName) {
        try {
            InternalFacet internalFacet = HashedAggregator.buildFacet(facetName, this.size, this.missing, this.total, this.comparatorType, this.aggregator);
            return internalFacet;
        }
        finally {
            this.aggregator.release();
        }
    }

    static void loadAllTerms(SearchContext context, IndexFieldData indexFieldData, HashedAggregator aggregator) {
        for (AtomicReaderContext readerContext : context.searcher().getTopReaderContext().leaves()) {
            BytesValues values;
            int maxDoc = readerContext.reader().maxDoc();
            if (indexFieldData instanceof IndexFieldData.WithOrdinals) {
                values = ((IndexFieldData.WithOrdinals)indexFieldData).load(readerContext).getBytesValues();
                Ordinals.Docs ordinals = ((BytesValues.WithOrdinals)values).ordinals();
                for (int ord = 1; ord < ordinals.getMaxOrd(); ++ord) {
                    BytesRef value = ((BytesValues.WithOrdinals)values).getValueByOrd(ord);
                    aggregator.addValue(value, value.hashCode(), values);
                }
                continue;
            }
            values = indexFieldData.load(readerContext).getBytesValues();
            if (values.isMultiValued()) {
                for (int docId = 0; docId < maxDoc; ++docId) {
                    if (!values.hasValue(docId)) continue;
                    BytesValues.Iter iter = values.getIter(docId);
                    while (iter.hasNext()) {
                        aggregator.addValue(iter.next(), iter.hash(), values);
                    }
                }
                continue;
            }
            BytesRef spare = new BytesRef();
            for (int docId = 0; docId < maxDoc; ++docId) {
                if (!values.hasValue(docId)) continue;
                int hash = values.getValueHashed(docId, spare);
                aggregator.addValue(spare, hash, values);
            }
        }
    }

    final class Collector
    extends FacetExecutor.Collector {
        private final HashedAggregator aggregator;
        private final boolean allTerms;
        private BytesValues values;

        Collector(HashedAggregator aggregator, boolean allTerms) {
            this.aggregator = aggregator;
            this.allTerms = allTerms;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            if (TermsStringFacetExecutor.this.script != null) {
                TermsStringFacetExecutor.this.script.setScorer(scorer);
            }
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.values = TermsStringFacetExecutor.this.indexFieldData.load(context).getBytesValues();
            if (TermsStringFacetExecutor.this.script != null) {
                TermsStringFacetExecutor.this.script.setNextReader(context);
            }
        }

        public void collect(int doc) throws IOException {
            this.aggregator.onDoc(doc, this.values);
        }

        @Override
        public void postCollection() {
            TermsStringFacetExecutor.this.missing = this.aggregator.missing();
            TermsStringFacetExecutor.this.total = this.aggregator.total();
        }
    }
}

