/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.termsstats.doubles;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.trove.ExtTDoubleObjectHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.termsstats.InternalTermsStatsFacet;
import org.elasticsearch.search.facet.termsstats.TermsStatsFacet;

public class InternalTermsStatsDoubleFacet
extends InternalTermsStatsFacet {
    private static final BytesReference STREAM_TYPE = new HashedBytesArray("dTS");
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(StreamInput in) throws IOException {
            return InternalTermsStatsDoubleFacet.readTermsStatsFacet(in);
        }
    };
    int requiredSize;
    long missing;
    Collection<DoubleEntry> entries = ImmutableList.of();
    TermsStatsFacet.ComparatorType comparatorType;

    public static void registerStream() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public BytesReference streamType() {
        return STREAM_TYPE;
    }

    public InternalTermsStatsDoubleFacet() {
    }

    public InternalTermsStatsDoubleFacet(String name, TermsStatsFacet.ComparatorType comparatorType, int requiredSize, Collection<DoubleEntry> entries, long missing) {
        super(name);
        this.comparatorType = comparatorType;
        this.requiredSize = requiredSize;
        this.entries = entries;
        this.missing = missing;
    }

    public List<DoubleEntry> getEntries() {
        if (!(this.entries instanceof List)) {
            this.entries = ImmutableList.copyOf(this.entries);
        }
        return (List)this.entries;
    }

    List<DoubleEntry> mutableList() {
        if (!(this.entries instanceof List)) {
            this.entries = new ArrayList<DoubleEntry>(this.entries);
        }
        return (List)this.entries;
    }

    @Override
    public Iterator<TermsStatsFacet.Entry> iterator() {
        return this.entries.iterator();
    }

    @Override
    public long getMissingCount() {
        return this.missing;
    }

    @Override
    public Facet reduce(List<Facet> facets) {
        DoubleEntry value;
        if (facets.size() == 1) {
            if (this.requiredSize == 0) {
                InternalTermsStatsDoubleFacet tsFacet = (InternalTermsStatsDoubleFacet)facets.get(0);
                if (!tsFacet.entries.isEmpty()) {
                    List<DoubleEntry> entries = tsFacet.mutableList();
                    Collections.sort(entries, this.comparatorType.comparator());
                }
            }
            return facets.get(0);
        }
        int missing = 0;
        ExtTDoubleObjectHashMap map = CacheRecycler.popDoubleObjectMap();
        for (Facet facet : facets) {
            InternalTermsStatsDoubleFacet tsFacet = (InternalTermsStatsDoubleFacet)facet;
            missing = (int)((long)missing + tsFacet.missing);
            for (TermsStatsFacet.Entry entry : tsFacet) {
                DoubleEntry doubleEntry = (DoubleEntry)entry;
                DoubleEntry current = (DoubleEntry)map.get(doubleEntry.term);
                if (current != null) {
                    current.count += doubleEntry.count;
                    current.totalCount += doubleEntry.totalCount;
                    current.total += doubleEntry.total;
                    if (doubleEntry.min < current.min) {
                        current.min = doubleEntry.min;
                    }
                    if (!(doubleEntry.max > current.max)) continue;
                    current.max = doubleEntry.max;
                    continue;
                }
                map.put(doubleEntry.term, doubleEntry);
            }
        }
        if (this.requiredSize == 0) {
            DoubleEntry[] entries1 = map.values(new DoubleEntry[map.size()]);
            Arrays.sort(entries1, this.comparatorType.comparator());
            CacheRecycler.pushDoubleObjectMap(map);
            return new InternalTermsStatsDoubleFacet(this.getName(), this.comparatorType, this.requiredSize, Arrays.asList(entries1), missing);
        }
        Object[] values = map.internalValues();
        Arrays.sort(values, this.comparatorType.comparator());
        ArrayList<DoubleEntry> ordered = new ArrayList<DoubleEntry>(map.size());
        for (int i = 0; i < this.requiredSize && (value = (DoubleEntry)values[i]) != null; ++i) {
            ordered.add(value);
        }
        CacheRecycler.pushDoubleObjectMap(map);
        return new InternalTermsStatsDoubleFacet(this.getName(), this.comparatorType, this.requiredSize, ordered, missing);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field(Fields._TYPE, "terms_stats");
        builder.field(Fields.MISSING, this.missing);
        builder.startArray(Fields.TERMS);
        for (DoubleEntry entry : this.entries) {
            builder.startObject();
            builder.field(Fields.TERM, entry.term);
            builder.field(Fields.COUNT, entry.getCount());
            builder.field(Fields.TOTAL_COUNT, entry.getTotalCount());
            builder.field(Fields.MIN, entry.getMin());
            builder.field(Fields.MAX, entry.getMax());
            builder.field(Fields.TOTAL, entry.getTotal());
            builder.field(Fields.MEAN, entry.getMean());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalTermsStatsDoubleFacet readTermsStatsFacet(StreamInput in) throws IOException {
        InternalTermsStatsDoubleFacet facet = new InternalTermsStatsDoubleFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.comparatorType = TermsStatsFacet.ComparatorType.fromId(in.readByte());
        this.requiredSize = in.readVInt();
        this.missing = in.readVLong();
        int size = in.readVInt();
        this.entries = new ArrayList<DoubleEntry>(size);
        for (int i = 0; i < size; ++i) {
            this.entries.add(new DoubleEntry(in.readDouble(), in.readVLong(), in.readVLong(), in.readDouble(), in.readDouble(), in.readDouble()));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.comparatorType.id());
        out.writeVInt(this.requiredSize);
        out.writeVLong(this.missing);
        out.writeVInt(this.entries.size());
        for (DoubleEntry entry : this.entries) {
            out.writeDouble(entry.term);
            out.writeVLong(entry.getCount());
            out.writeVLong(entry.getTotalCount());
            out.writeDouble(entry.getTotal());
            out.writeDouble(entry.getMin());
            out.writeDouble(entry.getMax());
        }
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString MISSING = new XContentBuilderString("missing");
        static final XContentBuilderString TERMS = new XContentBuilderString("terms");
        static final XContentBuilderString TERM = new XContentBuilderString("term");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");
        static final XContentBuilderString TOTAL_COUNT = new XContentBuilderString("total_count");
        static final XContentBuilderString MIN = new XContentBuilderString("min");
        static final XContentBuilderString MAX = new XContentBuilderString("max");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString MEAN = new XContentBuilderString("mean");

        Fields() {
        }
    }

    public static class DoubleEntry
    implements TermsStatsFacet.Entry {
        double term;
        long count;
        long totalCount;
        double total;
        double min;
        double max;

        public DoubleEntry(double term, long count, long totalCount, double total, double min, double max) {
            this.term = term;
            this.count = count;
            this.total = total;
            this.totalCount = totalCount;
            this.min = min;
            this.max = max;
        }

        @Override
        public Text getTerm() {
            return new StringText(Double.toString(this.term));
        }

        @Override
        public Number getTermAsNumber() {
            return this.term;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public long getTotalCount() {
            return this.totalCount;
        }

        @Override
        public double getMin() {
            return this.min;
        }

        @Override
        public double getMax() {
            return this.max;
        }

        @Override
        public double getTotal() {
            return this.total;
        }

        @Override
        public double getMean() {
            if (this.totalCount == 0L) {
                return 0.0;
            }
            return this.total / (double)this.totalCount;
        }

        @Override
        public int compareTo(TermsStatsFacet.Entry o) {
            DoubleEntry other = (DoubleEntry)o;
            return this.term < other.term ? -1 : (this.term == other.term ? 0 : 1);
        }
    }
}

