/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight;

import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.highlight.DefaultEncoder;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.SimpleHTMLEncoder;
import org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import org.apache.lucene.search.vectorhighlight.CustomFieldQuery;
import org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.apache.lucene.search.vectorhighlight.FragListBuilder;
import org.apache.lucene.search.vectorhighlight.FragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.ScoreOrderFragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.SimpleFragListBuilder;
import org.apache.lucene.search.vectorhighlight.SimpleFragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.SingleFragListBuilder;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.vectorhighlight.SimpleBoundaryScanner2;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.highlight.HighlightField;
import org.elasticsearch.search.highlight.Highlighter;
import org.elasticsearch.search.highlight.HighlighterContext;
import org.elasticsearch.search.highlight.SearchContextHighlight;
import org.elasticsearch.search.highlight.vectorhighlight.SourceScoreOrderFragmentsBuilder;
import org.elasticsearch.search.highlight.vectorhighlight.SourceSimpleFragmentsBuilder;
import org.elasticsearch.search.internal.SearchContext;

public class FastVectorHighlighter
implements Highlighter {
    private static final String CACHE_KEY = "highlight-fsv";
    private final Boolean termVectorMultiValue;

    @Inject
    public FastVectorHighlighter(Settings settings) {
        this.termVectorMultiValue = settings.getAsBoolean("search.highlight.term_vector_multi_value", (Boolean)true);
    }

    @Override
    public String[] names() {
        return new String[]{"fvh", "fast-vector-highlighter"};
    }

    @Override
    public HighlightField highlight(HighlighterContext highlighterContext) {
        Encoder encoder;
        SearchContextHighlight.Field field = highlighterContext.field;
        SearchContext context = highlighterContext.context;
        FetchSubPhase.HitContext hitContext = highlighterContext.hitContext;
        FieldMapper<?> mapper = highlighterContext.mapper;
        if (!(mapper.fieldType().storeTermVectors() && mapper.fieldType().storeTermVectorOffsets() && mapper.fieldType().storeTermVectorPositions())) {
            throw new ElasticSearchIllegalArgumentException("the field [" + field.field() + "] should be indexed with term vector with position offsets to be used with fast vector highlighter");
        }
        Encoder encoder2 = encoder = field.encoder().equals("html") ? Encoders.HTML : Encoders.DEFAULT;
        if (!hitContext.cache().containsKey(CACHE_KEY)) {
            hitContext.cache().put(CACHE_KEY, new HighlighterEntry());
        }
        HighlighterEntry cache = (HighlighterEntry)hitContext.cache().get(CACHE_KEY);
        try {
            MapperHighlightEntry entry = cache.mappers.get(mapper);
            FieldQuery fieldQuery = null;
            if (entry == null) {
                Object fragmentsBuilder;
                SingleFragListBuilder fragListBuilder;
                SimpleBoundaryScanner2 boundaryScanner = SimpleBoundaryScanner2.DEFAULT;
                if (field.boundaryMaxScan() != 20 || field.boundaryChars() != SimpleBoundaryScanner2.DEFAULT_BOUNDARY_CHARS) {
                    boundaryScanner = new SimpleBoundaryScanner2(field.boundaryMaxScan(), field.boundaryChars());
                }
                if (field.numberOfFragments() == 0) {
                    fragListBuilder = new SingleFragListBuilder();
                    fragmentsBuilder = mapper.fieldType().stored() ? new SimpleFragmentsBuilder(field.preTags(), field.postTags(), (BoundaryScanner)boundaryScanner) : new SourceSimpleFragmentsBuilder(mapper, context, field.preTags(), field.postTags(), boundaryScanner);
                } else {
                    SimpleFragListBuilder simpleFragListBuilder = fragListBuilder = field.fragmentOffset() == -1 ? new SimpleFragListBuilder() : new SimpleFragListBuilder(field.fragmentOffset());
                    fragmentsBuilder = field.scoreOrdered().booleanValue() ? (mapper.fieldType().stored() ? new ScoreOrderFragmentsBuilder(field.preTags(), field.postTags(), (BoundaryScanner)boundaryScanner) : new SourceScoreOrderFragmentsBuilder(mapper, context, field.preTags(), field.postTags(), boundaryScanner)) : (mapper.fieldType().stored() ? new SimpleFragmentsBuilder(field.preTags(), field.postTags(), (BoundaryScanner)boundaryScanner) : new SourceSimpleFragmentsBuilder(mapper, context, field.preTags(), field.postTags(), boundaryScanner));
                }
                fragmentsBuilder.setDiscreteMultiValueHighlighting(this.termVectorMultiValue.booleanValue());
                entry = new MapperHighlightEntry();
                entry.fragListBuilder = fragListBuilder;
                entry.fragmentsBuilder = fragmentsBuilder;
                if (cache.fvh == null) {
                    cache.fvh = new org.apache.lucene.search.vectorhighlight.FastVectorHighlighter();
                }
                CustomFieldQuery.highlightFilters.set(field.highlightFilter());
                if (field.requireFieldMatch().booleanValue()) {
                    if (cache.fieldMatchFieldQuery == null) {
                        cache.fieldMatchFieldQuery = new CustomFieldQuery(context.parsedQuery().query(), hitContext.topLevelReader(), true, field.requireFieldMatch());
                    }
                    fieldQuery = cache.fieldMatchFieldQuery;
                } else {
                    if (cache.noFieldMatchFieldQuery == null) {
                        cache.noFieldMatchFieldQuery = new CustomFieldQuery(context.parsedQuery().query(), hitContext.topLevelReader(), true, field.requireFieldMatch());
                    }
                    fieldQuery = cache.noFieldMatchFieldQuery;
                }
                cache.mappers.put(mapper, entry);
            }
            int numberOfFragments = field.numberOfFragments() == 0 ? Integer.MAX_VALUE : field.numberOfFragments();
            int fragmentCharSize = field.numberOfFragments() == 0 ? Integer.MAX_VALUE : field.fragmentCharSize();
            String[] fragments = cache.fvh.getBestFragments(fieldQuery, (IndexReader)hitContext.reader(), hitContext.docId(), mapper.names().indexName(), fragmentCharSize, numberOfFragments, entry.fragListBuilder, entry.fragmentsBuilder, field.preTags(), field.postTags(), encoder);
            if (fragments != null && fragments.length > 0) {
                return new HighlightField(field.field(), StringText.convertFromStringArray(fragments));
            }
        }
        catch (Exception e) {
            throw new FetchPhaseExecutionException(context, "Failed to highlight field [" + highlighterContext.fieldName + "]", (Throwable)e);
        }
        return null;
    }

    private static class Encoders {
        public static Encoder DEFAULT = new DefaultEncoder();
        public static Encoder HTML = new SimpleHTMLEncoder();

        private Encoders() {
        }
    }

    private class HighlighterEntry {
        public org.apache.lucene.search.vectorhighlight.FastVectorHighlighter fvh;
        public FieldQuery noFieldMatchFieldQuery;
        public FieldQuery fieldMatchFieldQuery;
        public Map<FieldMapper, MapperHighlightEntry> mappers = Maps.newHashMap();

        private HighlighterEntry() {
        }
    }

    private class MapperHighlightEntry {
        public FragListBuilder fragListBuilder;
        public FragmentsBuilder fragmentsBuilder;
        public org.apache.lucene.search.highlight.Highlighter highlighter;

        private MapperHighlightEntry() {
        }
    }
}

