/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight;

import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.lucene.search.vectorhighlight.SimpleBoundaryScanner2;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.SearchContext;

public class HighlighterParseElement
implements SearchParseElement {
    private static final String[] DEFAULT_PRE_TAGS = new String[]{"<em>"};
    private static final String[] DEFAULT_POST_TAGS = new String[]{"</em>"};
    private static final String[] STYLED_PRE_TAG = new String[]{"<em class=\"hlt1\">", "<em class=\"hlt2\">", "<em class=\"hlt3\">", "<em class=\"hlt4\">", "<em class=\"hlt5\">", "<em class=\"hlt6\">", "<em class=\"hlt7\">", "<em class=\"hlt8\">", "<em class=\"hlt9\">", "<em class=\"hlt10\">"};
    private static final String[] STYLED_POST_TAGS = new String[]{"</em>"};

    @Override
    public void parse(XContentParser parser, SearchContext context) throws Exception {
        XContentParser.Token token;
        String topLevelFieldName = null;
        ArrayList<SearchContextHighlight.Field> fields = Lists.newArrayList();
        String[] globalPreTags = DEFAULT_PRE_TAGS;
        String[] globalPostTags = DEFAULT_POST_TAGS;
        boolean globalScoreOrdered = false;
        boolean globalHighlightFilter = false;
        boolean globalRequireFieldMatch = false;
        int globalFragmentSize = 100;
        int globalNumOfFragments = 5;
        String globalEncoder = "default";
        int globalBoundaryMaxScan = 20;
        char[] globalBoundaryChars = SimpleBoundaryScanner2.DEFAULT_BOUNDARY_CHARS;
        String globalHighlighterType = null;
        String globalFragmenter = null;
        Map<String, Object> globalOptions = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                topLevelFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("pre_tags".equals(topLevelFieldName) || "preTags".equals(topLevelFieldName)) {
                    ArrayList<String> preTagsList = Lists.newArrayList();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        preTagsList.add(parser.text());
                    }
                    globalPreTags = preTagsList.toArray(new String[preTagsList.size()]);
                    continue;
                }
                if (!"post_tags".equals(topLevelFieldName) && !"postTags".equals(topLevelFieldName)) continue;
                ArrayList<String> postTagsList = Lists.newArrayList();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    postTagsList.add(parser.text());
                }
                globalPostTags = postTagsList.toArray(new String[postTagsList.size()]);
                continue;
            }
            if (token.isValue()) {
                if ("order".equals(topLevelFieldName)) {
                    globalScoreOrdered = "score".equals(parser.text());
                    continue;
                }
                if ("tags_schema".equals(topLevelFieldName) || "tagsSchema".equals(topLevelFieldName)) {
                    String schema = parser.text();
                    if (!"styled".equals(schema)) continue;
                    globalPreTags = STYLED_PRE_TAG;
                    globalPostTags = STYLED_POST_TAGS;
                    continue;
                }
                if ("highlight_filter".equals(topLevelFieldName) || "highlightFilter".equals(topLevelFieldName)) {
                    globalHighlightFilter = parser.booleanValue();
                    continue;
                }
                if ("fragment_size".equals(topLevelFieldName) || "fragmentSize".equals(topLevelFieldName)) {
                    globalFragmentSize = parser.intValue();
                    continue;
                }
                if ("number_of_fragments".equals(topLevelFieldName) || "numberOfFragments".equals(topLevelFieldName)) {
                    globalNumOfFragments = parser.intValue();
                    continue;
                }
                if ("encoder".equals(topLevelFieldName)) {
                    globalEncoder = parser.text();
                    continue;
                }
                if ("require_field_match".equals(topLevelFieldName) || "requireFieldMatch".equals(topLevelFieldName)) {
                    globalRequireFieldMatch = parser.booleanValue();
                    continue;
                }
                if ("boundary_max_scan".equals(topLevelFieldName) || "boundaryMaxScan".equals(topLevelFieldName)) {
                    globalBoundaryMaxScan = parser.intValue();
                    continue;
                }
                if ("boundary_chars".equals(topLevelFieldName) || "boundaryChars".equals(topLevelFieldName)) {
                    globalBoundaryChars = parser.text().toCharArray();
                    continue;
                }
                if ("type".equals(topLevelFieldName)) {
                    globalHighlighterType = parser.text();
                    continue;
                }
                if (!"fragmenter".equals(topLevelFieldName)) continue;
                globalFragmenter = parser.text();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT && "options".equals(topLevelFieldName)) {
                globalOptions = parser.map();
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT || !"fields".equals(topLevelFieldName)) continue;
            String highlightFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    highlightFieldName = parser.currentName();
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                SearchContextHighlight.Field field = new SearchContextHighlight.Field(highlightFieldName);
                String fieldName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        fieldName = parser.currentName();
                        continue;
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        if ("pre_tags".equals(fieldName) || "preTags".equals(fieldName)) {
                            ArrayList<String> preTagsList = Lists.newArrayList();
                            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                preTagsList.add(parser.text());
                            }
                            field.preTags(preTagsList.toArray(new String[preTagsList.size()]));
                            continue;
                        }
                        if (!"post_tags".equals(fieldName) && !"postTags".equals(fieldName)) continue;
                        ArrayList<String> postTagsList = Lists.newArrayList();
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            postTagsList.add(parser.text());
                        }
                        field.postTags(postTagsList.toArray(new String[postTagsList.size()]));
                        continue;
                    }
                    if (token.isValue()) {
                        if ("fragment_size".equals(fieldName) || "fragmentSize".equals(fieldName)) {
                            field.fragmentCharSize(parser.intValue());
                            continue;
                        }
                        if ("number_of_fragments".equals(fieldName) || "numberOfFragments".equals(fieldName)) {
                            field.numberOfFragments(parser.intValue());
                            continue;
                        }
                        if ("fragment_offset".equals(fieldName) || "fragmentOffset".equals(fieldName)) {
                            field.fragmentOffset(parser.intValue());
                            continue;
                        }
                        if ("highlight_filter".equals(fieldName) || "highlightFilter".equals(fieldName)) {
                            field.highlightFilter(parser.booleanValue());
                            continue;
                        }
                        if ("order".equals(fieldName)) {
                            field.scoreOrdered("score".equals(parser.text()));
                            continue;
                        }
                        if ("require_field_match".equals(fieldName) || "requireFieldMatch".equals(fieldName)) {
                            field.requireFieldMatch(parser.booleanValue());
                            continue;
                        }
                        if ("boundary_max_scan".equals(topLevelFieldName) || "boundaryMaxScan".equals(topLevelFieldName)) {
                            field.boundaryMaxScan(parser.intValue());
                            continue;
                        }
                        if ("boundary_chars".equals(topLevelFieldName) || "boundaryChars".equals(topLevelFieldName)) {
                            field.boundaryChars(parser.text().toCharArray());
                            continue;
                        }
                        if ("type".equals(fieldName)) {
                            field.highlighterType(parser.text());
                            continue;
                        }
                        if (!"fragmenter".equals(fieldName)) continue;
                        field.fragmenter(parser.text());
                        continue;
                    }
                    if (!fieldName.equals("options")) continue;
                    field.options(parser.map());
                }
                fields.add(field);
            }
        }
        if (globalPreTags != null && globalPostTags == null) {
            throw new SearchParseException(context, "Highlighter global preTags are set, but global postTags are not set");
        }
        for (SearchContextHighlight.Field field : fields) {
            if (field.preTags() == null) {
                field.preTags(globalPreTags);
            }
            if (field.postTags() == null) {
                field.postTags(globalPostTags);
            }
            if (field.highlightFilter() == null) {
                field.highlightFilter(globalHighlightFilter);
            }
            if (field.scoreOrdered() == null) {
                field.scoreOrdered(globalScoreOrdered);
            }
            if (field.fragmentCharSize() == -1) {
                field.fragmentCharSize(globalFragmentSize);
            }
            if (field.numberOfFragments() == -1) {
                field.numberOfFragments(globalNumOfFragments);
            }
            if (field.encoder() == null) {
                field.encoder(globalEncoder);
            }
            if (field.requireFieldMatch() == null) {
                field.requireFieldMatch(globalRequireFieldMatch);
            }
            if (field.boundaryMaxScan() == -1) {
                field.boundaryMaxScan(globalBoundaryMaxScan);
            }
            if (field.boundaryChars() == null) {
                field.boundaryChars(globalBoundaryChars);
            }
            if (field.highlighterType() == null) {
                field.highlighterType(globalHighlighterType);
            }
            if (field.fragmenter() == null) {
                field.fragmenter(globalFragmenter);
            }
            if (field.options() != null && field.options().size() != 0) continue;
            field.options(globalOptions);
        }
        context.highlight(new SearchContextHighlight(fields));
    }
}

