/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight.vectorhighlight;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.vectorhighlight.FieldFragList;
import org.apache.lucene.search.vectorhighlight.FieldPhraseList;
import org.apache.lucene.util.Version;
import org.elasticsearch.index.analysis.CustomAnalyzer;
import org.elasticsearch.index.analysis.EdgeNGramTokenFilterFactory;
import org.elasticsearch.index.analysis.EdgeNGramTokenizerFactory;
import org.elasticsearch.index.analysis.NGramTokenFilterFactory;
import org.elasticsearch.index.analysis.NGramTokenizerFactory;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.WordDelimiterTokenFilterFactory;
import org.elasticsearch.index.mapper.FieldMapper;

public final class FragmentBuilderHelper {
    private FragmentBuilderHelper() {
    }

    public static FieldFragList.WeightedFragInfo fixWeightedFragInfo(FieldMapper<?> mapper, Field[] values, FieldFragList.WeightedFragInfo fragInfo) {
        assert (fragInfo != null) : "FragInfo must not be null";
        assert (mapper.names().indexName().equals(values[0].name())) : "Expected FieldMapper for field " + values[0].name();
        if (!fragInfo.getSubInfos().isEmpty() && FragmentBuilderHelper.containsBrokenAnalysis(mapper.indexAnalyzer())) {
            List subInfos = fragInfo.getSubInfos();
            Collections.sort(subInfos, new Comparator<FieldFragList.WeightedFragInfo.SubInfo>(){

                @Override
                public int compare(FieldFragList.WeightedFragInfo.SubInfo o1, FieldFragList.WeightedFragInfo.SubInfo o2) {
                    int startOffset = ((FieldPhraseList.WeightedPhraseInfo.Toffs)o1.getTermsOffsets().get(0)).getStartOffset();
                    int startOffset2 = ((FieldPhraseList.WeightedPhraseInfo.Toffs)o2.getTermsOffsets().get(0)).getStartOffset();
                    return FragmentBuilderHelper.compare(startOffset, startOffset2);
                }
            });
            return new FieldFragList.WeightedFragInfo(Math.min(((FieldPhraseList.WeightedPhraseInfo.Toffs)((FieldFragList.WeightedFragInfo.SubInfo)fragInfo.getSubInfos().get(0)).getTermsOffsets().get(0)).getStartOffset(), fragInfo.getStartOffset()), fragInfo.getEndOffset(), subInfos, fragInfo.getTotalBoost());
        }
        return fragInfo;
    }

    private static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private static boolean containsBrokenAnalysis(Analyzer analyzer) {
        if (analyzer instanceof NamedAnalyzer) {
            analyzer = ((NamedAnalyzer)analyzer).analyzer();
        }
        if (analyzer instanceof CustomAnalyzer) {
            TokenFilterFactory[] tokenFilters;
            CustomAnalyzer a = (CustomAnalyzer)analyzer;
            if (a.tokenizerFactory() instanceof EdgeNGramTokenizerFactory || a.tokenizerFactory() instanceof NGramTokenizerFactory && !((NGramTokenizerFactory)a.tokenizerFactory()).version().onOrAfter(Version.LUCENE_42)) {
                return true;
            }
            for (TokenFilterFactory tokenFilterFactory : tokenFilters = a.tokenFilters()) {
                if (tokenFilterFactory instanceof WordDelimiterTokenFilterFactory || tokenFilterFactory instanceof EdgeNGramTokenFilterFactory) {
                    return true;
                }
                if (!(tokenFilterFactory instanceof NGramTokenFilterFactory) || ((NGramTokenFilterFactory)tokenFilterFactory).version().onOrAfter(Version.LUCENE_42)) continue;
                return true;
            }
        }
        return false;
    }
}

