/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rescore;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.SorterTemplate;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.rescore.RescoreSearchContext;
import org.elasticsearch.search.rescore.Rescorer;

final class QueryRescorer
implements Rescorer {
    public static final Rescorer INSTANCE = new QueryRescorer();
    public static final String NAME = "query";

    QueryRescorer() {
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void rescore(TopDocs topDocs, SearchContext context, RescoreSearchContext rescoreContext) throws IOException {
        assert (rescoreContext != null);
        QueryRescoreContext rescore = (QueryRescoreContext)rescoreContext;
        TopDocs queryTopDocs = context.queryResult().topDocs();
        if (queryTopDocs == null || queryTopDocs.totalHits == 0 || queryTopDocs.scoreDocs.length == 0) {
            return;
        }
        ContextIndexSearcher searcher = context.searcher();
        topDocs = searcher.search(rescore.query(), new TopDocsFilter(queryTopDocs), queryTopDocs.scoreDocs.length);
        context.queryResult().topDocs(this.merge(queryTopDocs, topDocs, rescore));
    }

    @Override
    public Explanation explain(int topLevelDocId, SearchContext context, RescoreSearchContext rescoreContext) throws IOException {
        QueryRescoreContext rescore = (QueryRescoreContext)context.rescore();
        ContextIndexSearcher searcher = context.searcher();
        Explanation primaryExplain = searcher.explain(context.query(), topLevelDocId);
        if (primaryExplain == null) {
            return new ComplexExplanation(false, 0.0f, "nothing matched");
        }
        Explanation rescoreExplain = searcher.explain(rescore.query(), topLevelDocId);
        float primaryWeight = rescore.queryWeight();
        ComplexExplanation prim = new ComplexExplanation(primaryExplain.isMatch(), primaryExplain.getValue() * primaryWeight, "product of:");
        prim.addDetail(primaryExplain);
        prim.addDetail(new Explanation(primaryWeight, "primaryWeight"));
        if (rescoreExplain != null) {
            ComplexExplanation sumExpl = new ComplexExplanation();
            sumExpl.setDescription("sum of:");
            sumExpl.addDetail((Explanation)prim);
            sumExpl.setMatch(Boolean.valueOf(prim.isMatch()));
            float secondaryWeight = rescore.rescoreQueryWeight();
            ComplexExplanation sec = new ComplexExplanation(rescoreExplain.isMatch(), rescoreExplain.getValue() * secondaryWeight, "product of:");
            sec.addDetail(rescoreExplain);
            sec.addDetail(new Explanation(secondaryWeight, "secondaryWeight"));
            sumExpl.addDetail((Explanation)sec);
            sumExpl.setValue(prim.getValue() + sec.getValue());
            return sumExpl;
        }
        return prim;
    }

    @Override
    public RescoreSearchContext parse(XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        QueryRescoreContext rescoreContext = new QueryRescoreContext(this);
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                if (!"rescore_query".equals(fieldName)) continue;
                ParsedQuery parsedQuery = context.queryParserService().parse(parser);
                rescoreContext.setParsedQuery(parsedQuery);
                continue;
            }
            if (!token.isValue()) continue;
            if ("query_weight".equals(fieldName)) {
                rescoreContext.setQueryWeight(parser.floatValue());
                continue;
            }
            if ("rescore_query_weight".equals(fieldName)) {
                rescoreContext.setRescoreQueryWeight(parser.floatValue());
                continue;
            }
            throw new ElasticSearchIllegalArgumentException("rescore doesn't support [" + fieldName + "]");
        }
        return rescoreContext;
    }

    private TopDocs merge(TopDocs primary, TopDocs secondary, QueryRescoreContext context) {
        DocIdSorter sorter = new DocIdSorter();
        DocIdSorter.access$102(sorter, primary.scoreDocs);
        sorter.mergeSort(0, sorter.array.length - 1);
        ScoreDoc[] primaryDocs = sorter.array;
        DocIdSorter.access$102(sorter, secondary.scoreDocs);
        sorter.mergeSort(0, sorter.array.length - 1);
        ScoreDoc[] secondaryDocs = sorter.array;
        int j = 0;
        float primaryWeight = context.queryWeight();
        float secondaryWeight = context.rescoreQueryWeight();
        for (int i = 0; i < primaryDocs.length && j < secondaryDocs.length; ++i) {
            if (primaryDocs[i].doc == secondaryDocs[j].doc) {
                primaryDocs[i].score = primaryDocs[i].score * primaryWeight + secondaryDocs[j++].score * secondaryWeight;
                continue;
            }
            primaryDocs[i].score *= primaryWeight;
        }
        ScoreSorter scoreSorter = new ScoreSorter();
        ScoreSorter.access$302(scoreSorter, primaryDocs);
        scoreSorter.mergeSort(0, primaryDocs.length - 1);
        primary.setMaxScore(primaryDocs[0].score);
        return primary;
    }

    private static final int compareDocId(ScoreDoc left, ScoreDoc right) {
        if (left.doc < right.doc) {
            return 1;
        }
        if (left.doc == right.doc) {
            return 0;
        }
        return -1;
    }

    @Override
    public void extractTerms(SearchContext context, RescoreSearchContext rescoreContext, Set<Term> termsSet) {
        ((QueryRescoreContext)context.rescore()).query().extractTerms(termsSet);
    }

    private static final class TopDocsFilter
    extends Filter {
        private final int[] docIds;

        public TopDocsFilter(TopDocs topDocs) {
            this.docIds = new int[topDocs.scoreDocs.length];
            ScoreDoc[] scoreDocs = topDocs.scoreDocs;
            for (int i = 0; i < scoreDocs.length; ++i) {
                this.docIds[i] = scoreDocs[i].doc;
            }
            Arrays.sort(this.docIds);
        }

        public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            int end;
            final int docBase = context.docBase;
            int limit = docBase + context.reader().maxDoc();
            int offset = Arrays.binarySearch(this.docIds, docBase);
            if (offset < 0) {
                offset = -offset - 1;
            }
            if ((end = Arrays.binarySearch(this.docIds, limit)) < 0) {
                end = -end - 1;
            }
            final int start = offset;
            final int stop = end;
            return new DocIdSet(){

                public DocIdSetIterator iterator() throws IOException {
                    return new DocIdSetIterator(){
                        private int current;
                        private int docId;
                        {
                            this.current = start;
                            this.docId = Integer.MAX_VALUE;
                        }

                        public int nextDoc() throws IOException {
                            if (this.current < stop) {
                                this.docId = TopDocsFilter.this.docIds[this.current++] - docBase;
                                return this.docId;
                            }
                            this.docId = Integer.MAX_VALUE;
                            return Integer.MAX_VALUE;
                        }

                        public int docID() {
                            return this.docId;
                        }

                        public int advance(int target) throws IOException {
                            if (target == Integer.MAX_VALUE) {
                                this.current = stop;
                                this.docId = Integer.MAX_VALUE;
                                return Integer.MAX_VALUE;
                            }
                            while (this.nextDoc() < target) {
                            }
                            return this.docId;
                        }

                        public long cost() {
                            return TopDocsFilter.this.docIds.length;
                        }
                    };
                }
            };
        }
    }

    private static final class ScoreSorter
    extends SorterTemplate {
        private ScoreDoc[] array;
        private ScoreDoc pivot;

        private ScoreSorter() {
        }

        protected void swap(int i, int j) {
            ScoreDoc scoreDoc = this.array[i];
            this.array[i] = this.array[j];
            this.array[j] = scoreDoc;
        }

        protected int compare(int i, int j) {
            int cmp = Float.compare(this.array[j].score, this.array[i].score);
            return cmp == 0 ? QueryRescorer.compareDocId(this.array[i], this.array[j]) : cmp;
        }

        protected void setPivot(int i) {
            this.pivot = this.array[i];
        }

        protected int comparePivot(int j) {
            int cmp = Float.compare(this.array[j].score, this.pivot.score);
            return cmp == 0 ? QueryRescorer.compareDocId(this.pivot, this.array[j]) : cmp;
        }

        static /* synthetic */ ScoreDoc[] access$302(ScoreSorter x0, ScoreDoc[] x1) {
            x0.array = x1;
            return x1;
        }
    }

    private static final class DocIdSorter
    extends SorterTemplate {
        private ScoreDoc[] array;
        private ScoreDoc pivot;

        private DocIdSorter() {
        }

        protected void swap(int i, int j) {
            ScoreDoc scoreDoc = this.array[i];
            this.array[i] = this.array[j];
            this.array[j] = scoreDoc;
        }

        protected int compare(int i, int j) {
            return QueryRescorer.compareDocId(this.array[i], this.array[j]);
        }

        protected void setPivot(int i) {
            this.pivot = this.array[i];
        }

        protected int comparePivot(int j) {
            return QueryRescorer.compareDocId(this.pivot, this.array[j]);
        }

        static /* synthetic */ ScoreDoc[] access$102(DocIdSorter x0, ScoreDoc[] x1) {
            x0.array = x1;
            return x1;
        }
    }

    static class QueryRescoreContext
    extends RescoreSearchContext {
        private ParsedQuery parsedQuery;
        private float queryWeight = 1.0f;
        private float rescoreQueryWeight = 1.0f;

        public QueryRescoreContext(QueryRescorer rescorer) {
            super(QueryRescorer.NAME, 10, rescorer);
        }

        public void setParsedQuery(ParsedQuery parsedQuery) {
            this.parsedQuery = parsedQuery;
        }

        public Query query() {
            return this.parsedQuery.query();
        }

        public float queryWeight() {
            return this.queryWeight;
        }

        public float rescoreQueryWeight() {
            return this.rescoreQueryWeight;
        }

        public void setRescoreQueryWeight(float rescoreQueryWeight) {
            this.rescoreQueryWeight = rescoreQueryWeight;
        }

        public void setQueryWeight(float queryWeight) {
            this.queryWeight = queryWeight;
        }
    }
}

