/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.suggest.SuggestContextParser;
import org.elasticsearch.search.suggest.SuggestUtils;
import org.elasticsearch.search.suggest.SuggestionSearchContext;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestParser;
import org.elasticsearch.search.suggest.term.TermSuggestParser;

public class SuggestParseElement
implements SearchParseElement {
    private final SuggestContextParser termSuggestParser = new TermSuggestParser();
    private final SuggestContextParser phraseSuggestParser = new PhraseSuggestParser();

    @Override
    public void parse(XContentParser parser, SearchContext context) throws Exception {
        SuggestionSearchContext suggestionSearchContext = this.parseInternal(parser, context.mapperService());
        context.suggest(suggestionSearchContext);
    }

    public SuggestionSearchContext parseInternal(XContentParser parser, MapperService mapperService) throws IOException {
        XContentParser.Token token;
        SuggestionSearchContext suggestionSearchContext = new SuggestionSearchContext();
        BytesRef globalText = null;
        String fieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("text".equals(fieldName)) {
                    globalText = parser.bytes();
                    continue;
                }
                throw new ElasticSearchIllegalArgumentException("[suggest] does not support [" + fieldName + "]");
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            String suggestionName = fieldName;
            BytesRef suggestText = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                SuggestContextParser contextParser;
                if (token == XContentParser.Token.FIELD_NAME) {
                    fieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if ("text".equals(fieldName)) {
                        suggestText = parser.bytes();
                        continue;
                    }
                    throw new ElasticSearchIllegalArgumentException("[suggest] does not support [" + fieldName + "]");
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                if (suggestionName == null) {
                    throw new ElasticSearchIllegalArgumentException("Suggestion must have name");
                }
                if ("term".equals(fieldName)) {
                    contextParser = this.termSuggestParser;
                } else if ("phrase".equals(fieldName)) {
                    contextParser = this.phraseSuggestParser;
                } else {
                    throw new ElasticSearchIllegalArgumentException("Suggester[" + fieldName + "] not supported");
                }
                this.parseAndVerify(parser, mapperService, suggestionSearchContext, globalText, suggestionName, suggestText, contextParser);
            }
        }
        return suggestionSearchContext;
    }

    public void parseAndVerify(XContentParser parser, MapperService mapperService, SuggestionSearchContext suggestionSearchContext, BytesRef globalText, String suggestionName, BytesRef suggestText, SuggestContextParser suggestParser) throws IOException {
        SuggestionSearchContext.SuggestionContext suggestion = suggestParser.parse(parser, mapperService);
        suggestion.setText(suggestText);
        SuggestUtils.verifySuggestion(mapperService, globalText, suggestion);
        suggestionSearchContext.addSuggestion(suggestionName, suggestion);
    }
}

