/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spell.DirectSpellChecker;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.SuggestUtils;
import org.elasticsearch.search.suggest.Suggester;
import org.elasticsearch.search.suggest.phrase.CandidateGenerator;
import org.elasticsearch.search.suggest.phrase.Correction;
import org.elasticsearch.search.suggest.phrase.DirectCandidateGenerator;
import org.elasticsearch.search.suggest.phrase.MultiCandidateGeneratorWrapper;
import org.elasticsearch.search.suggest.phrase.NoisyChannelSpellChecker;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestionContext;
import org.elasticsearch.search.suggest.phrase.WordScorer;

final class PhraseSuggester
implements Suggester<PhraseSuggestionContext> {
    private final BytesRef SEPARATOR = new BytesRef((CharSequence)" ");

    PhraseSuggester() {
    }

    @Override
    public Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> execute(String name, PhraseSuggestionContext suggestion, IndexReader indexReader, CharsRef spare) throws IOException {
        double realWordErrorLikelihood = suggestion.realworldErrorLikelyhood().floatValue();
        List<PhraseSuggestionContext.DirectCandidateGenerator> generators = suggestion.generators();
        CandidateGenerator[] gens = new CandidateGenerator[generators.size()];
        for (int i = 0; i < gens.length; ++i) {
            PhraseSuggestionContext.DirectCandidateGenerator generator = generators.get(i);
            DirectSpellChecker directSpellChecker = SuggestUtils.getDirectSpellChecker(generator);
            gens[i] = new DirectCandidateGenerator(directSpellChecker, generator.field(), generator.suggestMode(), indexReader, realWordErrorLikelihood, generator.size(), generator.preFilter(), generator.postFilter());
        }
        NoisyChannelSpellChecker checker = new NoisyChannelSpellChecker(realWordErrorLikelihood, suggestion.getRequireUnigram());
        BytesRef separator = suggestion.separator();
        TokenStream stream = checker.tokenStream(suggestion.getAnalyzer(), suggestion.getText(), spare, suggestion.getField());
        WordScorer wordScorer = suggestion.model().newScorer(indexReader, suggestion.getField(), realWordErrorLikelihood, separator);
        Correction[] corrections = checker.getCorrections(stream, new MultiCandidateGeneratorWrapper(suggestion.getShardSize(), gens), suggestion.maxErrors(), suggestion.getShardSize(), indexReader, wordScorer, separator, suggestion.confidence(), suggestion.gramSize());
        UnicodeUtil.UTF8toUTF16((BytesRef)suggestion.getText(), (CharsRef)spare);
        Suggest.Suggestion.Entry<Suggest.Suggestion.Entry.Option> resultEntry = new Suggest.Suggestion.Entry<Suggest.Suggestion.Entry.Option>(new StringText(spare.toString()), 0, spare.length);
        BytesRef byteSpare = new BytesRef();
        for (Correction correction : corrections) {
            UnicodeUtil.UTF8toUTF16((BytesRef)correction.join(this.SEPARATOR, byteSpare), (CharsRef)spare);
            StringText phrase = new StringText(spare.toString());
            resultEntry.addOption(new Suggest.Suggestion.Entry.Option(phrase, (float)correction.score));
        }
        Suggest.Suggestion<Suggest.Suggestion.Entry<Suggest.Suggestion.Entry.Option>> response = new Suggest.Suggestion<Suggest.Suggestion.Entry<Suggest.Suggestion.Entry.Option>>(name, suggestion.getSize());
        response.addTerm(resultEntry);
        return response;
    }
}

