/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.term;

import java.io.IOException;
import java.util.Comparator;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.suggest.Suggest;

public class TermSuggestion
extends Suggest.Suggestion<Entry> {
    public static Comparator<Suggest.Suggestion.Entry.Option> SCORE = new Score();
    public static Comparator<Suggest.Suggestion.Entry.Option> FREQUENCY = new Frequency();
    public static final int TYPE = 1;
    private Suggest.Suggestion.Sort sort;

    public TermSuggestion() {
    }

    public TermSuggestion(String name, int size, Suggest.Suggestion.Sort sort) {
        super(name, size);
        this.sort = sort;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    protected Comparator<Suggest.Suggestion.Entry.Option> sortComparator() {
        switch (this.sort) {
            case SCORE: {
                return SCORE;
            }
            case FREQUENCY: {
                return FREQUENCY;
            }
        }
        throw new ElasticSearchException("Could not resolve comparator for sort key: [" + (Object)((Object)this.sort) + "]");
    }

    @Override
    protected void innerReadFrom(StreamInput in) throws IOException {
        super.innerReadFrom(in);
        this.sort = Suggest.Suggestion.Sort.fromId(in.readByte());
    }

    @Override
    public void innerWriteTo(StreamOutput out) throws IOException {
        super.innerWriteTo(out);
        out.writeByte(this.sort.id());
    }

    @Override
    protected Entry newEntry() {
        return new Entry();
    }

    public static class Entry
    extends Suggest.Suggestion.Entry<Option> {
        Entry(Text text, int offset, int length) {
            super(text, offset, length);
        }

        Entry() {
        }

        @Override
        protected Option newOption() {
            return new Option();
        }

        public static class Option
        extends Suggest.Suggestion.Entry.Option {
            private int freq;

            protected Option(Text text, int freq, float score) {
                super(text, score);
                this.freq = freq;
            }

            @Override
            protected void mergeInto(Suggest.Suggestion.Entry.Option otherOption) {
                super.mergeInto(otherOption);
                this.freq += ((Option)otherOption).freq;
            }

            protected Option() {
            }

            public void setFreq(int freq) {
                this.freq = freq;
            }

            public int getFreq() {
                return this.freq;
            }

            @Override
            public void readFrom(StreamInput in) throws IOException {
                super.readFrom(in);
                this.freq = in.readVInt();
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
                out.writeVInt(this.freq);
            }

            @Override
            protected XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder = super.innerToXContent(builder, params);
                builder.field(Fields.FREQ, this.freq);
                return builder;
            }

            static class Fields {
                static final XContentBuilderString FREQ = new XContentBuilderString("freq");

                Fields() {
                }
            }
        }
    }

    public static class Frequency
    implements Comparator<Suggest.Suggestion.Entry.Option> {
        @Override
        public int compare(Suggest.Suggestion.Entry.Option first, Suggest.Suggestion.Entry.Option second) {
            int cmp = ((Entry.Option)second).getFreq() - ((Entry.Option)first).getFreq();
            if (cmp != 0) {
                return cmp;
            }
            cmp = Float.compare(second.getScore(), first.getScore());
            if (cmp != 0) {
                return cmp;
            }
            return first.getText().compareTo(second.getText());
        }
    }

    public static class Score
    implements Comparator<Suggest.Suggestion.Entry.Option> {
        @Override
        public int compare(Suggest.Suggestion.Entry.Option first, Suggest.Suggestion.Entry.Option second) {
            int cmp = Float.compare(second.getScore(), first.getScore());
            if (cmp != 0) {
                return cmp;
            }
            return FREQUENCY.compare(first, second);
        }
    }
}

