/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.threadpool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.base.Objects;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.SizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsAbortPolicy;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.MoreExecutors;
import org.elasticsearch.common.util.concurrent.XRejectedExecutionHandler;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPoolInfo;
import org.elasticsearch.threadpool.ThreadPoolStats;

public class ThreadPool
extends AbstractComponent {
    public static final String THREADPOOL_GROUP = "threadpool.";
    private volatile ImmutableMap<String, ExecutorHolder> executors;
    private final ImmutableMap<String, Settings> defaultExecutorTypeSettings;
    private final Queue<ExecutorHolder> retiredExecutors = new ConcurrentLinkedQueue<ExecutorHolder>();
    private final ScheduledThreadPoolExecutor scheduler;
    private final EstimatedTimeThread estimatedTimeThread;

    public ThreadPool() {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS, (NodeSettingsService)null);
    }

    @Inject
    public ThreadPool(Settings settings, @Nullable NodeSettingsService nodeSettingsService) {
        super(settings);
        Map<String, Settings> groupSettings = settings.getGroups(THREADPOOL_GROUP);
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int halfProcMaxAt5 = Math.min((availableProcessors + 1) / 2, 5);
        int halfProcMaxAt10 = Math.min((availableProcessors + 1) / 2, 10);
        this.defaultExecutorTypeSettings = ImmutableMap.builder().put("generic", ImmutableSettings.settingsBuilder().put("type", "cached").put("keep_alive", "30s").build()).put("index", ImmutableSettings.settingsBuilder().put("type", "fixed").put("size", availableProcessors).build()).put("bulk", ImmutableSettings.settingsBuilder().put("type", "fixed").put("size", availableProcessors).build()).put("get", ImmutableSettings.settingsBuilder().put("type", "fixed").put("size", availableProcessors).build()).put("search", ImmutableSettings.settingsBuilder().put("type", "fixed").put("size", availableProcessors * 3).put("queue_size", 1000).build()).put("percolate", ImmutableSettings.settingsBuilder().put("type", "fixed").put("size", availableProcessors).build()).put("management", ImmutableSettings.settingsBuilder().put("type", "scaling").put("keep_alive", "5m").put("size", 5).build()).put("flush", ImmutableSettings.settingsBuilder().put("type", "scaling").put("keep_alive", "5m").put("size", halfProcMaxAt5).build()).put("merge", ImmutableSettings.settingsBuilder().put("type", "scaling").put("keep_alive", "5m").put("size", halfProcMaxAt5).build()).put("refresh", ImmutableSettings.settingsBuilder().put("type", "scaling").put("keep_alive", "5m").put("size", halfProcMaxAt10).build()).put("warmer", ImmutableSettings.settingsBuilder().put("type", "scaling").put("keep_alive", "5m").put("size", halfProcMaxAt5).build()).put("snapshot", ImmutableSettings.settingsBuilder().put("type", "scaling").put("keep_alive", "5m").put("size", halfProcMaxAt5).build()).build();
        HashMap executors = Maps.newHashMap();
        for (Map.Entry executor : this.defaultExecutorTypeSettings.entrySet()) {
            executors.put(executor.getKey(), this.build((String)executor.getKey(), groupSettings.get(executor.getKey()), (Settings)executor.getValue()));
        }
        executors.put("same", new ExecutorHolder(MoreExecutors.sameThreadExecutor(), new Info("same", "same")));
        this.executors = ImmutableMap.copyOf(executors);
        this.scheduler = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, EsExecutors.daemonThreadFactory(settings, "scheduler"));
        this.scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.scheduler.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        if (nodeSettingsService != null) {
            nodeSettingsService.addListener(new ApplySettings());
        }
        TimeValue estimatedTimeInterval = this.componentSettings.getAsTime("estimated_time_interval", TimeValue.timeValueMillis(200L));
        this.estimatedTimeThread = new EstimatedTimeThread(EsExecutors.threadName(settings, "[timer]"), estimatedTimeInterval.millis());
        this.estimatedTimeThread.start();
    }

    public long estimatedTimeInMillis() {
        return this.estimatedTimeThread.estimatedTimeInMillis();
    }

    public ThreadPoolInfo info() {
        ArrayList<Info> infos = new ArrayList<Info>();
        for (ExecutorHolder holder : this.executors.values()) {
            String name = holder.info.name();
            if ("same".equals(name)) continue;
            infos.add(holder.info);
        }
        return new ThreadPoolInfo(infos);
    }

    public ThreadPoolStats stats() {
        ArrayList<ThreadPoolStats.Stats> stats = new ArrayList<ThreadPoolStats.Stats>();
        for (ExecutorHolder holder : this.executors.values()) {
            String name = holder.info.name();
            if ("same".equals(name)) continue;
            int threads = -1;
            int queue = -1;
            int active = -1;
            long rejected = -1L;
            int largest = -1;
            long completed = -1L;
            if (holder.executor instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)holder.executor;
                threads = threadPoolExecutor.getPoolSize();
                queue = threadPoolExecutor.getQueue().size();
                active = threadPoolExecutor.getActiveCount();
                largest = threadPoolExecutor.getLargestPoolSize();
                completed = threadPoolExecutor.getCompletedTaskCount();
                RejectedExecutionHandler rejectedExecutionHandler = threadPoolExecutor.getRejectedExecutionHandler();
                if (rejectedExecutionHandler instanceof XRejectedExecutionHandler) {
                    rejected = ((XRejectedExecutionHandler)rejectedExecutionHandler).rejected();
                }
            }
            stats.add(new ThreadPoolStats.Stats(name, threads, queue, active, rejected, largest, completed));
        }
        return new ThreadPoolStats(stats);
    }

    public Executor generic() {
        return this.executor("generic");
    }

    public Executor executor(String name) {
        Executor executor = this.executors.get((Object)name).executor;
        if (executor == null) {
            throw new ElasticSearchIllegalArgumentException("No executor found for [" + name + "]");
        }
        return executor;
    }

    public ScheduledExecutorService scheduler() {
        return this.scheduler;
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, TimeValue interval) {
        return this.scheduler.scheduleWithFixedDelay(new LoggingRunnable(command), interval.millis(), interval.millis(), TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> schedule(TimeValue delay, String name, Runnable command) {
        if (!"same".equals(name)) {
            command = new ThreadedRunnable(command, this.executor(name));
        }
        return this.scheduler.schedule(command, delay.millis(), TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.estimatedTimeThread.running = false;
        this.estimatedTimeThread.interrupt();
        this.scheduler.shutdown();
        for (ExecutorHolder executor : this.executors.values()) {
            if (!(executor.executor instanceof ThreadPoolExecutor)) continue;
            ((ThreadPoolExecutor)executor.executor).shutdown();
        }
    }

    public void shutdownNow() {
        this.estimatedTimeThread.running = false;
        this.estimatedTimeThread.interrupt();
        this.scheduler.shutdownNow();
        for (ExecutorHolder executor : this.executors.values()) {
            if (!(executor.executor instanceof ThreadPoolExecutor)) continue;
            ((ThreadPoolExecutor)executor.executor).shutdownNow();
        }
        while (!this.retiredExecutors.isEmpty()) {
            ((ThreadPoolExecutor)this.retiredExecutors.remove().executor).shutdownNow();
        }
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        boolean result = this.scheduler.awaitTermination(timeout, unit);
        for (ExecutorHolder executor : this.executors.values()) {
            if (!(executor.executor instanceof ThreadPoolExecutor)) continue;
            result &= ((ThreadPoolExecutor)executor.executor).awaitTermination(timeout, unit);
        }
        while (!this.retiredExecutors.isEmpty()) {
            result &= ((ThreadPoolExecutor)this.retiredExecutors.remove().executor).awaitTermination(timeout, unit);
        }
        return result;
    }

    private ExecutorHolder build(String name, @Nullable Settings settings, Settings defaultSettings) {
        return this.rebuild(name, null, settings, defaultSettings);
    }

    private ExecutorHolder rebuild(String name, ExecutorHolder previousExecutorHolder, @Nullable Settings settings, Settings defaultSettings) {
        if ("same".equals(name)) {
            return previousExecutorHolder;
        }
        if (settings == null) {
            settings = ImmutableSettings.Builder.EMPTY_SETTINGS;
        }
        Info previousInfo = previousExecutorHolder != null ? previousExecutorHolder.info : null;
        String type = settings.get("type", previousInfo != null ? previousInfo.type() : defaultSettings.get("type"));
        ThreadFactory threadFactory = EsExecutors.daemonThreadFactory(this.settings, name);
        if ("same".equals(type)) {
            if (previousExecutorHolder != null) {
                this.logger.debug("updating thread_pool [{}], type [{}]", name, type);
            } else {
                this.logger.debug("creating thread_pool [{}], type [{}]", name, type);
            }
            return new ExecutorHolder(MoreExecutors.sameThreadExecutor(), new Info(name, type));
        }
        if ("cached".equals(type)) {
            TimeValue defaultKeepAlive = defaultSettings.getAsTime("keep_alive", TimeValue.timeValueMinutes(5L));
            if (previousExecutorHolder != null) {
                if ("cached".equals(previousInfo.type())) {
                    TimeValue updatedKeepAlive = settings.getAsTime("keep_alive", previousInfo.keepAlive());
                    if (!previousInfo.keepAlive().equals(updatedKeepAlive)) {
                        this.logger.debug("updating thread_pool [{}], type [{}], keep_alive [{}]", name, type, updatedKeepAlive);
                        ((EsThreadPoolExecutor)previousExecutorHolder.executor).setKeepAliveTime(updatedKeepAlive.millis(), TimeUnit.MILLISECONDS);
                        return new ExecutorHolder(previousExecutorHolder.executor, new Info(name, type, -1, -1, updatedKeepAlive, null));
                    }
                    return previousExecutorHolder;
                }
                if (previousInfo.keepAlive() != null) {
                    defaultKeepAlive = previousInfo.keepAlive();
                }
            }
            TimeValue keepAlive = settings.getAsTime("keep_alive", defaultKeepAlive);
            if (previousExecutorHolder != null) {
                this.logger.debug("updating thread_pool [{}], type [{}], keep_alive [{}]", name, type, keepAlive);
            } else {
                this.logger.debug("creating thread_pool [{}], type [{}], keep_alive [{}]", name, type, keepAlive);
            }
            EsThreadPoolExecutor executor = new EsThreadPoolExecutor(0, Integer.MAX_VALUE, keepAlive.millis(), TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), threadFactory);
            return new ExecutorHolder(executor, new Info(name, type, -1, -1, keepAlive, null));
        }
        if ("fixed".equals(type)) {
            int defaultSize = defaultSettings.getAsInt("size", (Integer)(Runtime.getRuntime().availableProcessors() * 5));
            SizeValue defaultCapacity = defaultSettings.getAsSize("queue", defaultSettings.getAsSize("queue_size", null));
            String defaultRejectSetting = defaultSettings.get("reject_policy", "abort");
            String defaultQueueType = defaultSettings.get("queue_type", "linked");
            if (previousExecutorHolder != null) {
                if ("fixed".equals(previousInfo.type())) {
                    SizeValue updatedCapacity = settings.getAsSize("capacity", settings.getAsSize("queue", settings.getAsSize("queue_size", previousInfo.capacity())));
                    String updatedQueueType = settings.get("queue_type", previousInfo.queueType());
                    if (Objects.equal(previousInfo.capacity(), updatedCapacity) && previousInfo.queueType().equals(updatedQueueType)) {
                        int updatedSize = settings.getAsInt("size", (Integer)previousInfo.max());
                        String updatedRejectSetting = settings.get("reject_policy", previousInfo.rejectSetting());
                        if (previousInfo.max() != updatedSize) {
                            this.logger.debug("updating thread_pool [{}], type [{}], size [{}], queue_size [{}], reject_policy [{}], queue_type [{}]", name, type, updatedSize, updatedCapacity, updatedRejectSetting, updatedQueueType);
                            ((EsThreadPoolExecutor)previousExecutorHolder.executor).setCorePoolSize(updatedSize);
                            ((EsThreadPoolExecutor)previousExecutorHolder.executor).setMaximumPoolSize(updatedSize);
                            return new ExecutorHolder(previousExecutorHolder.executor, new Info(name, type, updatedSize, updatedSize, null, updatedCapacity, null, updatedRejectSetting, updatedQueueType));
                        }
                        if (!previousInfo.rejectSetting().equals(updatedRejectSetting)) {
                            this.logger.debug("updating thread_pool [{}], type [{}], size [{}], queue_size [{}], reject_policy [{}], queue_type [{}]", name, type, updatedSize, updatedCapacity, updatedRejectSetting, updatedQueueType);
                            ((EsThreadPoolExecutor)previousExecutorHolder.executor).setRejectedExecutionHandler(this.newRejectedExecutionHandler(name, updatedRejectSetting));
                            return new ExecutorHolder(previousExecutorHolder.executor, new Info(name, type, updatedSize, updatedSize, null, updatedCapacity, null, updatedRejectSetting, updatedQueueType));
                        }
                        return previousExecutorHolder;
                    }
                }
                if (previousInfo.max() >= 0) {
                    defaultSize = previousInfo.max();
                }
                defaultCapacity = previousInfo.capacity();
                if (previousInfo.rejectSetting != null) {
                    defaultRejectSetting = previousInfo.rejectSetting;
                }
                if (previousInfo.queueType() != null) {
                    defaultQueueType = previousInfo.queueType();
                }
            }
            int size = settings.getAsInt("size", (Integer)defaultSize);
            SizeValue capacity = settings.getAsSize("capacity", settings.getAsSize("queue", settings.getAsSize("queue_size", defaultCapacity)));
            String rejectSetting = settings.get("reject_policy", defaultRejectSetting);
            RejectedExecutionHandler rejectedExecutionHandler = this.newRejectedExecutionHandler(name, rejectSetting);
            String queueType = settings.get("queue_type", defaultQueueType);
            BlockingQueue<Runnable> workQueue = this.newQueue(capacity, queueType);
            this.logger.debug("creating thread_pool [{}], type [{}], size [{}], queue_size [{}], reject_policy [{}], queue_type [{}]", name, type, size, capacity, rejectSetting, queueType);
            EsThreadPoolExecutor executor = new EsThreadPoolExecutor(size, size, 0L, TimeUnit.MILLISECONDS, workQueue, threadFactory, rejectedExecutionHandler);
            return new ExecutorHolder(executor, new Info(name, type, size, size, null, capacity, null, rejectSetting, queueType));
        }
        if ("scaling".equals(type)) {
            TimeValue defaultKeepAlive = defaultSettings.getAsTime("keep_alive", TimeValue.timeValueMinutes(5L));
            int defaultMin = defaultSettings.getAsInt("min", (Integer)1);
            int defaultSize = defaultSettings.getAsInt("size", (Integer)(Runtime.getRuntime().availableProcessors() * 5));
            if (previousExecutorHolder != null) {
                if ("scaling".equals(previousInfo.getType())) {
                    TimeValue updatedKeepAlive = settings.getAsTime("keep_alive", previousInfo.getKeepAlive());
                    int updatedMin = settings.getAsInt("min", (Integer)previousInfo.getMin());
                    int updatedSize = settings.getAsInt("max", settings.getAsInt("size", (Integer)previousInfo.getMax()));
                    if (!previousInfo.keepAlive().equals(updatedKeepAlive) || previousInfo.min() != updatedMin || previousInfo.max() != updatedSize) {
                        this.logger.debug("updating thread_pool [{}], type [{}], keep_alive [{}]", name, type, updatedKeepAlive);
                        if (!previousInfo.getKeepAlive().equals(updatedKeepAlive)) {
                            ((EsThreadPoolExecutor)previousExecutorHolder.executor).setKeepAliveTime(updatedKeepAlive.millis(), TimeUnit.MILLISECONDS);
                        }
                        if (previousInfo.getMin() != updatedMin) {
                            ((EsThreadPoolExecutor)previousExecutorHolder.executor).setCorePoolSize(updatedMin);
                        }
                        if (previousInfo.getMax() != updatedSize) {
                            ((EsThreadPoolExecutor)previousExecutorHolder.executor).setMaximumPoolSize(updatedSize);
                        }
                        return new ExecutorHolder(previousExecutorHolder.executor, new Info(name, type, updatedMin, updatedSize, updatedKeepAlive, null));
                    }
                    return previousExecutorHolder;
                }
                if (previousInfo.getKeepAlive() != null) {
                    defaultKeepAlive = previousInfo.getKeepAlive();
                }
                if (previousInfo.getMin() >= 0) {
                    defaultMin = previousInfo.getMin();
                }
                if (previousInfo.getMax() >= 0) {
                    defaultSize = previousInfo.getMax();
                }
            }
            TimeValue keepAlive = settings.getAsTime("keep_alive", defaultKeepAlive);
            int min = settings.getAsInt("min", (Integer)defaultMin);
            int size = settings.getAsInt("max", settings.getAsInt("size", (Integer)defaultSize));
            if (previousExecutorHolder != null) {
                this.logger.debug("updating thread_pool [{}], type [{}], min [{}], size [{}], keep_alive [{}]", name, type, min, size, keepAlive);
            } else {
                this.logger.debug("creating thread_pool [{}], type [{}], min [{}], size [{}], keep_alive [{}]", name, type, min, size, keepAlive);
            }
            EsThreadPoolExecutor executor = EsExecutors.newScalingExecutorService(min, size, keepAlive.millis(), TimeUnit.MILLISECONDS, threadFactory);
            return new ExecutorHolder(executor, new Info(name, type, min, size, keepAlive, null));
        }
        if ("blocking".equals(type)) {
            TimeValue defaultKeepAlive = defaultSettings.getAsTime("keep_alive", TimeValue.timeValueMinutes(5L));
            int defaultMin = defaultSettings.getAsInt("min", (Integer)1);
            int defaultSize = defaultSettings.getAsInt("size", (Integer)(Runtime.getRuntime().availableProcessors() * 5));
            SizeValue defaultCapacity = defaultSettings.getAsSize("queue_size", new SizeValue(1000L));
            TimeValue defaultWaitTime = defaultSettings.getAsTime("wait_time", TimeValue.timeValueSeconds(60L));
            if (previousExecutorHolder != null) {
                if ("blocking".equals(previousInfo.getType())) {
                    SizeValue updatedCapacity = settings.getAsSize("capacity", settings.getAsSize("queue", settings.getAsSize("queue_size", defaultCapacity)));
                    TimeValue updatedWaitTime = settings.getAsTime("wait_time", defaultWaitTime);
                    if (previousInfo.capacity().equals(updatedCapacity) && previousInfo.waitTime().equals(updatedWaitTime)) {
                        TimeValue updatedKeepAlive = settings.getAsTime("keep_alive", previousInfo.getKeepAlive());
                        int updatedMin = settings.getAsInt("min", (Integer)previousInfo.getMin());
                        int updatedSize = settings.getAsInt("max", settings.getAsInt("size", (Integer)previousInfo.getMax()));
                        if (!previousInfo.getKeepAlive().equals(updatedKeepAlive) || !previousInfo.waitTime().equals(settings.getAsTime("wait_time", defaultWaitTime)) || previousInfo.getMin() != updatedMin || previousInfo.getMax() != updatedSize) {
                            this.logger.debug("updating thread_pool [{}], type [{}], keep_alive [{}]", name, type, updatedKeepAlive);
                            if (!previousInfo.getKeepAlive().equals(updatedKeepAlive)) {
                                ((EsThreadPoolExecutor)previousExecutorHolder.executor).setKeepAliveTime(updatedKeepAlive.millis(), TimeUnit.MILLISECONDS);
                            }
                            if (previousInfo.getMin() != updatedMin) {
                                ((EsThreadPoolExecutor)previousExecutorHolder.executor).setCorePoolSize(updatedMin);
                            }
                            if (previousInfo.getMax() != updatedSize) {
                                ((EsThreadPoolExecutor)previousExecutorHolder.executor).setMaximumPoolSize(updatedSize);
                            }
                            return new ExecutorHolder(previousExecutorHolder.executor, new Info(name, type, updatedMin, updatedSize, updatedKeepAlive, updatedCapacity, updatedWaitTime));
                        }
                        return previousExecutorHolder;
                    }
                }
                if (previousInfo.getKeepAlive() != null) {
                    defaultKeepAlive = previousInfo.getKeepAlive();
                }
                if (previousInfo.getMin() >= 0) {
                    defaultMin = previousInfo.getMin();
                }
                if (previousInfo.getMax() >= 0) {
                    defaultSize = previousInfo.getMax();
                }
                if (previousInfo.getCapacity() != null) {
                    defaultCapacity = previousInfo.getCapacity();
                }
                if (previousInfo.waitTime() != null) {
                    defaultWaitTime = previousInfo.getKeepAlive();
                }
            }
            TimeValue keepAlive = settings.getAsTime("keep_alive", defaultKeepAlive);
            int min = settings.getAsInt("min", (Integer)defaultMin);
            int size = settings.getAsInt("max", settings.getAsInt("size", (Integer)defaultSize));
            SizeValue capacity = settings.getAsSize("capacity", settings.getAsSize("queue", settings.getAsSize("queue_size", defaultCapacity)));
            TimeValue waitTime = settings.getAsTime("wait_time", defaultWaitTime);
            if (previousExecutorHolder != null) {
                this.logger.debug("updating thread_pool [{}], type [{}], min [{}], size [{}], queue_size [{}], keep_alive [{}], wait_time [{}]", name, type, min, size, capacity.singles(), keepAlive, waitTime);
            } else {
                this.logger.debug("creating thread_pool [{}], type [{}], min [{}], size [{}], queue_size [{}], keep_alive [{}], wait_time [{}]", name, type, min, size, capacity.singles(), keepAlive, waitTime);
            }
            EsThreadPoolExecutor executor = EsExecutors.newBlockingExecutorService(min, size, keepAlive.millis(), TimeUnit.MILLISECONDS, threadFactory, (int)capacity.singles(), waitTime.millis(), TimeUnit.MILLISECONDS);
            return new ExecutorHolder(executor, new Info(name, type, min, size, keepAlive, capacity, waitTime));
        }
        throw new ElasticSearchIllegalArgumentException("No type found [" + type + "], for [" + name + "]");
    }

    public void updateSettings(Settings settings) {
        Map<String, Settings> groupSettings = settings.getGroups("threadpool");
        if (groupSettings.isEmpty()) {
            return;
        }
        for (Map.Entry executor : this.defaultExecutorTypeSettings.entrySet()) {
            ExecutorHolder newExecutorHolder;
            ExecutorHolder oldExecutorHolder;
            Settings updatedSettings = groupSettings.get(executor.getKey());
            if (updatedSettings == null || (oldExecutorHolder = this.executors.get(executor.getKey())).equals(newExecutorHolder = this.rebuild((String)executor.getKey(), oldExecutorHolder, updatedSettings, (Settings)executor.getValue()))) continue;
            this.executors = MapBuilder.newMapBuilder(this.executors).put((String)executor.getKey(), newExecutorHolder).immutableMap();
            if (oldExecutorHolder.executor.equals(newExecutorHolder.executor) || !(oldExecutorHolder.executor instanceof EsThreadPoolExecutor)) continue;
            this.retiredExecutors.add(oldExecutorHolder);
            ((EsThreadPoolExecutor)oldExecutorHolder.executor).shutdown(new ExecutorShutdownListener(oldExecutorHolder));
        }
    }

    private BlockingQueue<Runnable> newQueue(SizeValue capacity, String queueType) {
        if (capacity == null) {
            return ConcurrentCollections.newBlockingQueue();
        }
        if ((int)capacity.singles() > 0) {
            if ("linked".equals(queueType)) {
                return new LinkedBlockingQueue<Runnable>((int)capacity.singles());
            }
            if ("array".equals(queueType)) {
                return new ArrayBlockingQueue<Runnable>((int)capacity.singles());
            }
            throw new ElasticSearchIllegalArgumentException("illegal queue_type set to [" + queueType + "], should be either linked or array");
        }
        return new SynchronousQueue<Runnable>();
    }

    private RejectedExecutionHandler newRejectedExecutionHandler(String name, String rejectSetting) {
        if ("abort".equals(rejectSetting)) {
            return new EsAbortPolicy();
        }
        if ("caller".equals(rejectSetting)) {
            return new ThreadPoolExecutor.CallerRunsPolicy();
        }
        throw new ElasticSearchIllegalArgumentException("reject_policy [" + rejectSetting + "] not valid for [" + name + "] thread pool");
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            ThreadPool.this.updateSettings(settings);
        }
    }

    public static class Info
    implements Streamable,
    ToXContent {
        private String name;
        private String type;
        private int min;
        private int max;
        private TimeValue keepAlive;
        private SizeValue capacity;
        private TimeValue waitTime;
        private String rejectSetting;
        private String queueType;

        Info() {
        }

        public Info(String name, String type) {
            this(name, type, -1);
        }

        public Info(String name, String type, int size) {
            this(name, type, size, size, null, null);
        }

        public Info(String name, String type, int min, int max, @Nullable TimeValue keepAlive, @Nullable SizeValue capacity) {
            this(name, type, min, max, keepAlive, capacity, null);
        }

        public Info(String name, String type, int min, int max, @Nullable TimeValue keepAlive, @Nullable SizeValue capacity, @Nullable TimeValue waitTime) {
            this(name, type, min, max, keepAlive, capacity, waitTime, null, null);
        }

        public Info(String name, String type, int min, int max, @Nullable TimeValue keepAlive, @Nullable SizeValue capacity, @Nullable TimeValue waitTime, String rejectSetting, String queueType) {
            this.name = name;
            this.type = type;
            this.min = min;
            this.max = max;
            this.keepAlive = keepAlive;
            this.capacity = capacity;
            this.waitTime = waitTime;
            this.rejectSetting = rejectSetting;
            this.queueType = queueType;
        }

        public String name() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public String type() {
            return this.type;
        }

        public String getType() {
            return this.type;
        }

        public int min() {
            return this.min;
        }

        public int getMin() {
            return this.min;
        }

        public int max() {
            return this.max;
        }

        public int getMax() {
            return this.max;
        }

        @Nullable
        public TimeValue keepAlive() {
            return this.keepAlive;
        }

        @Nullable
        public TimeValue getKeepAlive() {
            return this.keepAlive;
        }

        @Nullable
        public SizeValue capacity() {
            return this.capacity;
        }

        @Nullable
        public SizeValue getCapacity() {
            return this.capacity;
        }

        @Nullable
        public TimeValue waitTime() {
            return this.waitTime;
        }

        @Nullable
        public TimeValue getWaitTime() {
            return this.waitTime;
        }

        @Nullable
        public String rejectSetting() {
            return this.rejectSetting;
        }

        @Nullable
        public String getRejectSetting() {
            return this.rejectSetting;
        }

        @Nullable
        public String queueType() {
            return this.queueType;
        }

        @Nullable
        public String getQueueType() {
            return this.queueType;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.name = in.readString();
            this.type = in.readString();
            this.min = in.readInt();
            this.max = in.readInt();
            if (in.readBoolean()) {
                this.keepAlive = TimeValue.readTimeValue(in);
            }
            if (in.readBoolean()) {
                this.capacity = SizeValue.readSizeValue(in);
            }
            if (in.readBoolean()) {
                this.waitTime = TimeValue.readTimeValue(in);
            }
            this.rejectSetting = in.readOptionalString();
            this.queueType = in.readOptionalString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeString(this.type);
            out.writeInt(this.min);
            out.writeInt(this.max);
            if (this.keepAlive == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.keepAlive.writeTo(out);
            }
            if (this.capacity == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.capacity.writeTo(out);
            }
            if (this.waitTime == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.waitTime.writeTo(out);
            }
            out.writeOptionalString(this.rejectSetting);
            out.writeOptionalString(this.queueType);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.name, XContentBuilder.FieldCaseConversion.NONE);
            builder.field(Fields.TYPE, this.type);
            if (this.min != -1) {
                builder.field(Fields.MIN, this.min);
            }
            if (this.max != -1) {
                builder.field(Fields.MAX, this.max);
            }
            if (this.keepAlive != null) {
                builder.field(Fields.KEEP_ALIVE, this.keepAlive.toString());
            }
            if (this.capacity != null) {
                builder.field(Fields.CAPACITY, this.capacity.toString());
            }
            if (this.waitTime != null) {
                builder.field(Fields.WAIT_TIME, this.waitTime.toString());
            }
            if (this.rejectSetting != null) {
                builder.field(Fields.REJECT_POLICY, this.rejectSetting);
            }
            if (this.queueType != null) {
                builder.field(Fields.QUEUE_TYPE, this.queueType);
            }
            builder.endObject();
            return builder;
        }

        static final class Fields {
            static final XContentBuilderString TYPE = new XContentBuilderString("type");
            static final XContentBuilderString MIN = new XContentBuilderString("min");
            static final XContentBuilderString MAX = new XContentBuilderString("max");
            static final XContentBuilderString KEEP_ALIVE = new XContentBuilderString("keep_alive");
            static final XContentBuilderString CAPACITY = new XContentBuilderString("capacity");
            static final XContentBuilderString WAIT_TIME = new XContentBuilderString("wait_time");
            static final XContentBuilderString REJECT_POLICY = new XContentBuilderString("reject_policy");
            static final XContentBuilderString QUEUE_TYPE = new XContentBuilderString("queue_type");

            Fields() {
            }
        }
    }

    static class ExecutorHolder {
        public final Executor executor;
        public final Info info;

        ExecutorHolder(Executor executor, Info info) {
            this.executor = executor;
            this.info = info;
        }
    }

    static class EstimatedTimeThread
    extends Thread {
        final long interval;
        volatile boolean running = true;
        volatile long estimatedTimeInMillis;

        EstimatedTimeThread(String name, long interval) {
            super(name);
            this.interval = interval;
            this.setDaemon(true);
        }

        public long estimatedTimeInMillis() {
            return this.estimatedTimeInMillis;
        }

        @Override
        public void run() {
            while (this.running) {
                this.estimatedTimeInMillis = System.currentTimeMillis();
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException e) {
                    this.running = false;
                    return;
                }
                try {
                    FileSystemUtils.checkMkdirsStall(this.estimatedTimeInMillis);
                }
                catch (Exception exception) {}
            }
        }
    }

    class ThreadedRunnable
    implements Runnable {
        private final Runnable runnable;
        private final Executor executor;

        ThreadedRunnable(Runnable runnable, Executor executor) {
            this.runnable = runnable;
            this.executor = executor;
        }

        @Override
        public void run() {
            this.executor.execute(this.runnable);
        }

        public int hashCode() {
            return this.runnable.hashCode();
        }

        public boolean equals(Object obj) {
            return this.runnable.equals(obj);
        }

        public String toString() {
            return "[threaded] " + this.runnable.toString();
        }
    }

    class LoggingRunnable
    implements Runnable {
        private final Runnable runnable;

        LoggingRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                ThreadPool.this.logger.warn("failed to run {}", e, this.runnable.toString());
            }
        }

        public int hashCode() {
            return this.runnable.hashCode();
        }

        public boolean equals(Object obj) {
            return this.runnable.equals(obj);
        }

        public String toString() {
            return "[threaded] " + this.runnable.toString();
        }
    }

    class ExecutorShutdownListener
    implements EsThreadPoolExecutor.ShutdownListener {
        private ExecutorHolder holder;

        public ExecutorShutdownListener(ExecutorHolder holder) {
            this.holder = holder;
        }

        @Override
        public void onTerminated() {
            ThreadPool.this.retiredExecutors.remove(this.holder);
        }
    }

    public static class Names {
        public static final String SAME = "same";
        public static final String GENERIC = "generic";
        public static final String GET = "get";
        public static final String INDEX = "index";
        public static final String BULK = "bulk";
        public static final String SEARCH = "search";
        public static final String PERCOLATE = "percolate";
        public static final String MANAGEMENT = "management";
        public static final String FLUSH = "flush";
        public static final String MERGE = "merge";
        public static final String REFRESH = "refresh";
        public static final String WARMER = "warmer";
        public static final String SNAPSHOT = "snapshot";
    }
}

