/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty;

import java.io.IOException;
import java.io.NotSerializableException;
import org.elasticsearch.Version;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.ThrowableObjectOutputStream;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.CachedStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.transport.NotSerializableTransportException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseOptions;
import org.elasticsearch.transport.netty.NettyHeader;
import org.elasticsearch.transport.netty.NettyTransport;
import org.elasticsearch.transport.support.TransportStatus;

public class NettyTransportChannel
implements TransportChannel {
    private final NettyTransport transport;
    private final Version version;
    private final String action;
    private final Channel channel;
    private final long requestId;

    public NettyTransportChannel(NettyTransport transport, String action, Channel channel, long requestId, Version version) {
        this.version = version;
        this.transport = transport;
        this.action = action;
        this.channel = channel;
        this.requestId = requestId;
    }

    @Override
    public String action() {
        return this.action;
    }

    @Override
    public void sendResponse(TransportResponse response) throws IOException {
        this.sendResponse(response, TransportResponseOptions.EMPTY);
    }

    @Override
    public void sendResponse(TransportResponse response, TransportResponseOptions options) throws IOException {
        StreamOutput stream;
        if (this.transport.compress) {
            options.withCompress(true);
        }
        CachedStreamOutput.Entry cachedEntry = CachedStreamOutput.popEntry();
        byte status = 0;
        status = TransportStatus.setResponse(status);
        if (options.compress()) {
            status = TransportStatus.setCompress(status);
            cachedEntry.bytes().skip(19);
            stream = cachedEntry.handles(CompressorFactory.defaultCompressor());
            stream.setVersion(this.version);
            response.writeTo(stream);
            stream.close();
        } else {
            stream = cachedEntry.handles();
            stream.setVersion(this.version);
            cachedEntry.bytes().skip(19);
            response.writeTo(stream);
            stream.close();
        }
        ChannelBuffer buffer = cachedEntry.bytes().bytes().toChannelBuffer();
        NettyHeader.writeHeader(buffer, this.requestId, status, this.version);
        ChannelFuture future = this.channel.write(buffer);
        future.addListener(new NettyTransport.CacheFutureListener(cachedEntry));
    }

    @Override
    public void sendResponse(Throwable error) throws IOException {
        CachedStreamOutput.Entry cachedEntry = CachedStreamOutput.popEntry();
        try {
            BytesStreamOutput stream = cachedEntry.bytes();
            cachedEntry.bytes().skip(19);
            RemoteTransportException tx = new RemoteTransportException(this.transport.nodeName(), this.transport.wrapAddress(this.channel.getLocalAddress()), this.action, error);
            ThrowableObjectOutputStream too = new ThrowableObjectOutputStream(stream);
            too.writeObject(tx);
            too.close();
        }
        catch (NotSerializableException e) {
            cachedEntry.reset();
            BytesStreamOutput stream = cachedEntry.bytes();
            cachedEntry.bytes().skip(19);
            RemoteTransportException tx = new RemoteTransportException(this.transport.nodeName(), this.transport.wrapAddress(this.channel.getLocalAddress()), this.action, new NotSerializableTransportException(error));
            ThrowableObjectOutputStream too = new ThrowableObjectOutputStream(stream);
            too.writeObject(tx);
            too.close();
        }
        byte status = 0;
        status = TransportStatus.setResponse(status);
        status = TransportStatus.setError(status);
        ChannelBuffer buffer = cachedEntry.bytes().bytes().toChannelBuffer();
        NettyHeader.writeHeader(buffer, this.requestId, status, this.version);
        ChannelFuture future = this.channel.write(buffer);
        future.addListener(new NettyTransport.CacheFutureListener(cachedEntry));
    }
}

