/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.rss;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.interfaces.IVersionActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class DataCache {
    public static final String _rcsid = "@(#)$Id: DataCache.java 988245 2010-08-23 18:39:35Z kwright $";
    protected HashMap cacheData = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addData(IVersionActivity activities, String documentIdentifier, InputStream dataStream) throws ManifoldCFException, ServiceInterruption {
        try {
            File tempFile = File.createTempFile("_rsscache_", "tmp");
            try {
                ManifoldCF.addFile((File)tempFile);
                long checkSum = 0L;
                FileOutputStream os = new FileOutputStream(tempFile);
                try {
                    byte[] byteArray = new byte[65536];
                    while (true) {
                        int amt;
                        try {
                            amt = dataStream.read(byteArray, 0, byteArray.length);
                        }
                        catch (SocketTimeoutException e) {
                            Logging.connectors.warn((Object)("RSS: Socket timeout exception reading socket stream: " + e.getMessage()), (Throwable)e);
                            long currentTime = System.currentTimeMillis();
                            throw new ServiceInterruption("Read timeout: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, false);
                        }
                        catch (ConnectTimeoutException e) {
                            Logging.connectors.warn((Object)("RSS: Connect timeout exception reading socket stream: " + e.getMessage()), (Throwable)e);
                            long currentTime = System.currentTimeMillis();
                            throw new ServiceInterruption("Read timeout: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, false);
                        }
                        catch (InterruptedIOException e) {
                            throw new ManifoldCFException("Interrupted: " + e.getMessage(), 2);
                        }
                        catch (IOException e) {
                            Logging.connectors.warn((Object)("RSS: IO exception reading socket stream: " + e.getMessage()), (Throwable)e);
                            long currentTime = System.currentTimeMillis();
                            throw new ServiceInterruption("Read timeout: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, false);
                        }
                        if (amt == -1) {
                            break;
                        }
                        int i = 0;
                        while (i < amt) {
                            byte x = byteArray[i++];
                            long bytevalue = x;
                            checkSum = checkSum << 5 ^ checkSum >> 3 ^ bytevalue << 2 ^ bytevalue >> 3;
                        }
                        ((OutputStream)os).write(byteArray, 0, amt);
                        activities.checkJobStillActive();
                    }
                }
                finally {
                    ((OutputStream)os).close();
                }
                DataCache dataCache = this;
                synchronized (dataCache) {
                    this.deleteData(documentIdentifier);
                    this.cacheData.put(documentIdentifier, tempFile);
                    return checkSum;
                }
            }
            catch (IOException e) {
                ManifoldCF.deleteFile((File)tempFile);
                throw e;
            }
            catch (ServiceInterruption e) {
                ManifoldCF.deleteFile((File)tempFile);
                throw e;
            }
            catch (Error e) {
                ManifoldCF.deleteFile((File)tempFile);
                throw e;
            }
        }
        catch (SocketTimeoutException e) {
            throw new ManifoldCFException("Socket timeout exception creating temporary file: " + e.getMessage(), (Throwable)e);
        }
        catch (ConnectTimeoutException e) {
            throw new ManifoldCFException("Socket connect timeout exception creating temporary file: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception creating temporary file: " + e.getMessage(), (Throwable)e);
        }
    }

    public synchronized long getDataLength(String documentIdentifier) throws ManifoldCFException {
        File f = (File)this.cacheData.get(documentIdentifier);
        if (f == null) {
            return 0L;
        }
        return f.length();
    }

    public synchronized InputStream getData(String documentIdentifier) throws ManifoldCFException {
        File f = (File)this.cacheData.get(documentIdentifier);
        if (f == null) {
            return null;
        }
        try {
            return new FileInputStream(f);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception getting data length: " + e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void deleteData(String documentIdentifier) {
        File f = (File)this.cacheData.get(documentIdentifier);
        this.cacheData.remove(documentIdentifier);
        if (f != null) {
            ManifoldCF.deleteFile((File)f);
        }
    }
}

